/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.gui.projectpage;

import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.gui.ConfirmLinkScreen;
import dev.dediamondpro.resourcify.gui.DownloadWatcherScreen;
import dev.dediamondpro.resourcify.gui.PaginatedScreen;
import dev.dediamondpro.resourcify.gui.world.WorldDownloadingScreen;
import dev.dediamondpro.resourcify.libs.elementa.components.UIText;
import dev.dediamondpro.resourcify.libs.universal.ChatColor;
import dev.dediamondpro.resourcify.libs.universal.UScreen;
import dev.dediamondpro.resourcify.libs.universal.USound;
import dev.dediamondpro.resourcify.services.IVersion;
import dev.dediamondpro.resourcify.services.ProjectType;
import dev.dediamondpro.resourcify.util.DownloadManager;
import dev.dediamondpro.resourcify.util.Utils;
import dev.dediamondpro.resourcify.util.UtilsKt;
import java.io.File;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ1\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0018R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Ldev/dediamondpro/resourcify/gui/projectpage/VersionWrapper;", "", "Ldev/dediamondpro/resourcify/services/IVersion;", "version", "Ldev/dediamondpro/resourcify/services/ProjectType;", "type", "", "installed", "<init>", "(Ldev/dediamondpro/resourcify/services/IVersion;Ldev/dediamondpro/resourcify/services/ProjectType;Z)V", "get", "()Ldev/dediamondpro/resourcify/services/IVersion;", "Ljava/io/File;", "downloadFolder", "Ldev/dediamondpro/resourcify/libs/elementa/components/UIText;", "text", "Ldev/dediamondpro/resourcify/gui/PaginatedScreen;", "parent", "", "installText", "", "download", "(Ljava/io/File;Ldev/dediamondpro/resourcify/libs/elementa/components/UIText;Ldev/dediamondpro/resourcify/gui/PaginatedScreen;Ljava/lang/String;)V", "Ldev/dediamondpro/resourcify/services/IVersion;", "Ldev/dediamondpro/resourcify/services/ProjectType;", "Z", "getInstalled", "()Z", "setInstalled", "(Z)V", "Resourcify (1.21.4-neoforge)-1.7.5"})
public final class VersionWrapper {
    @NotNull
    private final IVersion version;
    @NotNull
    private final ProjectType type;
    private boolean installed;

    public VersionWrapper(@NotNull IVersion version, @NotNull ProjectType type2, boolean installed) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        this.version = version;
        this.type = type2;
        this.installed = installed;
    }

    public final boolean getInstalled() {
        return this.installed;
    }

    public final void setInstalled(boolean bl) {
        this.installed = bl;
    }

    @NotNull
    public final IVersion get() {
        return this.version;
    }

    public final void download(@NotNull File downloadFolder, @Nullable UIText text, @NotNull PaginatedScreen parent, @NotNull String installText) {
        block8: {
            URI url;
            block7: {
                Intrinsics.checkNotNullParameter((Object)downloadFolder, (String)"downloadFolder");
                Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
                Intrinsics.checkNotNullParameter((Object)installText, (String)"installText");
                if (this.installed) {
                    return;
                }
                url = this.version.getDownloadUrl();
                if (url == null) {
                    ConfirmScreen confirmScreen;
                    if (DownloadWatcherScreen.Companion.isUsable()) {
                        confirmScreen = new DownloadWatcherScreen(this.version.getViewUrl(), "zip", this.version.getFileSize(), this.version.getSha1(), parent, arg_0 -> VersionWrapper.download$lambda$0(this, downloadFolder, text, parent, arg_0));
                    } else {
                        String string = this.version.getViewUrl().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        confirmScreen = (ConfirmScreen)new ConfirmLinkScreen(string, parent, true);
                    }
                    ConfirmScreen screen = confirmScreen;
                    UScreen.Companion.displayScreen((Screen)screen);
                    return;
                }
                if (DownloadManager.INSTANCE.getProgress(url) != null) break block7;
                UIText uIText = text;
                if (uIText != null) {
                    uIText.setText(ChatColor.BOLD + UtilsKt.localize("resourcify.version.installing", new Object[0]));
                }
                String fileName = this.version.getFileName();
                if (this.type.getShouldExtract()) {
                    fileName = StringsKt.removeSuffix((String)fileName, (CharSequence)".zip");
                }
                File file = new File(downloadFolder, fileName);
                while (file.exists()) {
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    file = new File(downloadFolder, Utils.INSTANCE.incrementFileName(string));
                }
                DownloadManager.INSTANCE.download(file, this.version.getSha1(), url, this.type.getShouldExtract(), (Function0<Unit>)((Function0)() -> VersionWrapper.download$lambda$1(text, this)));
                if (this.type != ProjectType.WORLD) break block8;
                UScreen.Companion.displayScreen((Screen)new WorldDownloadingScreen(parent, file, url));
                break block8;
            }
            DownloadManager.INSTANCE.cancelDownload(url);
            UIText uIText = text;
            if (uIText == null) break block8;
            uIText.setText(installText);
        }
    }

    public static /* synthetic */ void download$default(VersionWrapper versionWrapper, File file, UIText uIText, PaginatedScreen paginatedScreen, String object, int n, Object object2) {
        if ((n & 8) != 0) {
            object = ChatColor.BOLD + UtilsKt.localize("resourcify.version.install", new Object[0]);
        }
        versionWrapper.download(file, uIText, paginatedScreen, (String)object);
    }

    private static final void download$lambda$0(VersionWrapper this$0, File $downloadFolder, UIText $text, PaginatedScreen $parent, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Holder.Reference reference = SoundEvents.NOTE_BLOCK_PLING;
        Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"NOTE_BLOCK_PLING");
        USound.INSTANCE.playSoundStatic((Holder<SoundEvent>)((Holder)reference), 1.0f, 1.0f);
        File file = null;
        try {
            if (this$0.type.getShouldExtract()) {
                file = new File($downloadFolder, StringsKt.removeSuffix((String)this$0.version.getFileName(), (CharSequence)".zip"));
                while (file.exists()) {
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    file = new File($downloadFolder, Utils.INSTANCE.incrementFileName(string));
                }
                File sourceFile = it.toFile();
                Intrinsics.checkNotNull((Object)sourceFile);
                DownloadManager.INSTANCE.extractWorldZip(sourceFile, file);
                if (!sourceFile.delete()) {
                    Constants.INSTANCE.getLOGGER().warn("Could not delete world file '" + it + "'.");
                }
            } else {
                file = new File($downloadFolder, this$0.version.getFileName());
                while (file.exists()) {
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    file = new File($downloadFolder, Utils.INSTANCE.incrementFileName(string));
                }
                File sourceFile = it.toFile();
                if (sourceFile.canWrite()) {
                    Files.move(it, file.toPath(), new CopyOption[0]);
                } else {
                    Files.copy(it, file.toPath(), new CopyOption[0]);
                    Constants.INSTANCE.getLOGGER().warn("Could not delete file '" + it + "'.");
                }
            }
            UIText uIText = $text;
            if (uIText != null) {
                uIText.setText(ChatColor.BOLD + UtilsKt.localize("resourcify.version.installed", new Object[0]));
            }
            if (this$0.type == ProjectType.WORLD) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                WorldDownloadingScreen.Companion.openWorld(string);
            } else {
                UScreen.Companion.displayScreen($parent);
            }
        }
        catch (Exception e) {
            Constants.INSTANCE.getLOGGER().error("An error occurred while processing file '" + it + "'", (Throwable)e);
            UScreen.Companion.displayScreen($parent);
        }
    }

    private static final Unit download$lambda$1(UIText $text, VersionWrapper this$0) {
        UIText uIText = $text;
        if (uIText != null) {
            uIText.setText(ChatColor.BOLD + UtilsKt.localize("resourcify.version.installed", new Object[0]));
        }
        this$0.installed = true;
        return Unit.INSTANCE;
    }
}

