/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.universal;

import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u0012\u0010\rJ\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\rJ\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J-\u0010\u0019\u001a\u00020\u00062\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0016\"\u00020\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eR*\u0010 \u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u0012\u0004\b#\u0010\u0003\u001a\u0004\b \u0010\"R*\u0010$\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010!\u0012\u0004\b%\u0010\u0003\u001a\u0004\b$\u0010\"R*\u0010&\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010!\u0012\u0004\b'\u0010\u0003\u001a\u0004\b&\u0010\"R*\u0010(\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010!\u0012\u0004\b)\u0010\u0003\u001a\u0004\b(\u0010\"R*\u0010*\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010!\u0012\u0004\b+\u0010\u0003\u001a\u0004\b*\u0010\"R*\u0010,\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010!\u0012\u0004\b-\u0010\u0003\u001a\u0004\b,\u0010\"\u00a8\u0006."}, d2={"Ldev/dediamondpro/resourcify/libs/universal/UDesktop;", "", "<init>", "()V", "Ljava/net/URI;", "uri", "", "browse", "(Ljava/net/URI;)Z", "browseDesktop", "Ljava/io/File;", "file", "edit", "(Ljava/io/File;)Z", "editDesktop", "", "getClipboardString", "()Ljava/lang/String;", "open", "openDesktop", "openSystemSpecific", "(Ljava/lang/String;)Z", "", "command", "checkExitStatus", "runCommand", "([Ljava/lang/String;Z)Z", "str", "", "setClipboardString", "(Ljava/lang/String;)V", "<set-?>", "isGnome", "Z", "()Z", "isGnome$annotations", "isKde", "isKde$annotations", "isLinux", "isLinux$annotations", "isMac", "isMac$annotations", "isWindows", "isWindows$annotations", "isXdg", "isXdg$annotations", "UniversalCraft 1.21.4-neoforge"})
@SourceDebugExtension(value={"SMAP\nUDesktop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UDesktop.kt\ngg/essential/universal/UDesktop\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n1741#2,3:204\n*S KotlinDebug\n*F\n+ 1 UDesktop.kt\ngg/essential/universal/UDesktop\n*L\n83#1:204,3\n*E\n"})
public final class UDesktop {
    @NotNull
    public static final UDesktop INSTANCE;
    private static boolean isLinux;
    private static boolean isXdg;
    private static boolean isKde;
    private static boolean isGnome;
    private static boolean isMac;
    private static boolean isWindows;

    private UDesktop() {
    }

    public static final boolean isLinux() {
        return isLinux;
    }

    @JvmStatic
    public static /* synthetic */ void isLinux$annotations() {
    }

    public static final boolean isXdg() {
        return isXdg;
    }

    @JvmStatic
    public static /* synthetic */ void isXdg$annotations() {
    }

    public static final boolean isKde() {
        return isKde;
    }

    @JvmStatic
    public static /* synthetic */ void isKde$annotations() {
    }

    public static final boolean isGnome() {
        return isGnome;
    }

    @JvmStatic
    public static /* synthetic */ void isGnome$annotations() {
    }

    public static final boolean isMac() {
        return isMac;
    }

    @JvmStatic
    public static /* synthetic */ void isMac$annotations() {
    }

    public static final boolean isWindows() {
        return isWindows;
    }

    @JvmStatic
    public static /* synthetic */ void isWindows$annotations() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean browse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (INSTANCE.browseDesktop(uri)) return true;
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        if (!INSTANCE.openSystemSpecific(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean open(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (INSTANCE.openDesktop(file)) return true;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        if (!INSTANCE.openSystemSpecific(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean edit(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (INSTANCE.editDesktop(file)) return true;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        if (!INSTANCE.openSystemSpecific(string)) return false;
        return true;
    }

    private final boolean openSystemSpecific(String file) {
        boolean bl;
        block9: {
            if (isLinux) {
                Object[] objectArray = new String[]{"xdg-open", "kde-open", "gnome-open"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String[] stringArray = new String[]{it, file};
                        if (!INSTANCE.runCommand(stringArray, true)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else if (isMac) {
                String[] stringArray = new String[]{"open", file};
                bl = UDesktop.runCommand$default(this, stringArray, false, 2, null);
            } else if (isWindows) {
                String[] stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", file};
                bl = UDesktop.runCommand$default(this, stringArray, false, 2, null);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean browseDesktop(URI uri) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            bl = false;
        } else {
            boolean bl2;
            try {
                if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    return false;
                }
                Desktop.getDesktop().browse(uri);
                bl2 = true;
            }
            catch (Throwable e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean openDesktop(File file) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            bl = false;
        } else {
            boolean bl2;
            try {
                if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    return false;
                }
                Desktop.getDesktop().open(file);
                bl2 = true;
            }
            catch (Throwable e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean editDesktop(File file) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            bl = false;
        } else {
            boolean bl2;
            try {
                if (!Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                    return false;
                }
                Desktop.getDesktop().edit(file);
                bl2 = true;
            }
            catch (Throwable e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean runCommand(String[] command, boolean checkExitStatus) {
        boolean bl;
        try {
            Process process = Runtime.getRuntime().exec(command);
            if (process == null) {
                return false;
            }
            Process process2 = process;
            bl = checkExitStatus ? (process2.waitFor(3L, TimeUnit.SECONDS) ? process2.exitValue() == 0 : true) : process2.isAlive();
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean runCommand$default(UDesktop uDesktop, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return uDesktop.runCommand(stringArray, bl);
    }

    @JvmStatic
    @NotNull
    public static final String getClipboardString() {
        String string = UMinecraft.getMinecraft().keyboardHandler.getClipboard();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMinecraft().keyboardHandler.clipboard");
        return string;
    }

    @JvmStatic
    public static final void setClipboardString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        UMinecraft.getMinecraft().keyboardHandler.setClipboard(str);
    }

    static {
        String string;
        INSTANCE = new UDesktop();
        try {
            string = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            string = null;
        }
        String osName = string;
        isLinux = osName != null && (StringsKt.startsWith$default((String)osName, (String)"Linux", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osName, (String)"LINUX", (boolean)false, (int)2, null));
        isMac = osName != null && StringsKt.startsWith$default((String)osName, (String)"Mac", (boolean)false, (int)2, null);
        boolean bl = isWindows = osName != null && StringsKt.startsWith$default((String)osName, (String)"Windows", (boolean)false, (int)2, null);
        if (isLinux) {
            String string2;
            String string3 = System.getenv("XDG_SESSION_ID");
            if (string3 != null) {
                String it = string3;
                boolean bl2 = false;
                isXdg = ((CharSequence)it).length() > 0;
            }
            if ((string2 = System.getenv("GDMSESSION")) != null) {
                String string4 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                string2 = string4;
                if (string4 != null) {
                    String it = string2;
                    boolean bl3 = false;
                    isGnome = StringsKt.contains$default((CharSequence)it, (CharSequence)"gnome", (boolean)false, (int)2, null);
                    isKde = StringsKt.contains$default((CharSequence)it, (CharSequence)"kde", (boolean)false, (int)2, null);
                }
            }
        } else {
            isXdg = false;
            isKde = false;
            isGnome = false;
        }
    }
}

