/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.gui;

import dev.dediamondpro.resourcify.libs.universal.UDesktop;
import dev.dediamondpro.resourcify.libs.universal.UScreen;
import dev.dediamondpro.resourcify.util.Utils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B=\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\n\u001a\u00020\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0016R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0015R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0017R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0018R\u001c\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00190\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Ldev/dediamondpro/resourcify/gui/DownloadWatcherScreen;", "Lnet/minecraft/client/gui/screens/ConfirmScreen;", "Ljava/net/URI;", "url", "", "extension", "", "size", "sha1", "Lnet/minecraft/client/gui/screens/Screen;", "previousScreen", "Ljava/util/function/Consumer;", "Ljava/nio/file/Path;", "fileCallback", "<init>", "(Ljava/net/URI;Ljava/lang/String;JLjava/lang/String;Lnet/minecraft/client/gui/screens/Screen;Ljava/util/function/Consumer;)V", "", "tick", "()V", "onClose", "Ljava/net/URI;", "Ljava/lang/String;", "J", "Lnet/minecraft/client/gui/screens/Screen;", "Ljava/util/function/Consumer;", "Ljava/nio/file/WatchService;", "kotlin.jvm.PlatformType", "watchService", "Ljava/nio/file/WatchService;", "", "closedWatchService", "Z", "Companion", "Resourcify (1.21.1-forge)-1.7.5"})
public final class DownloadWatcherScreen
extends ConfirmScreen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI url;
    @NotNull
    private final String extension;
    private final long size;
    @NotNull
    private final String sha1;
    @NotNull
    private final Screen previousScreen;
    @NotNull
    private final Consumer<Path> fileCallback;
    private final WatchService watchService;
    private boolean closedWatchService;
    @NotNull
    private static final Lazy<Path> downloadFolder$delegate = LazyKt.lazy(DownloadWatcherScreen::downloadFolder_delegate$lambda$1);

    public DownloadWatcherScreen(@NotNull URI url, @NotNull String extension, long size, @NotNull String sha1, @NotNull Screen previousScreen, @NotNull Consumer<Path> fileCallback) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)sha1, (String)"sha1");
        Intrinsics.checkNotNullParameter((Object)previousScreen, (String)"previousScreen");
        Intrinsics.checkNotNullParameter(fileCallback, (String)"fileCallback");
        BooleanConsumer booleanConsumer = arg_0 -> DownloadWatcherScreen._init_$lambda$0(url, previousScreen, arg_0);
        Component component2 = (Component)Component.translatable((String)"resourcify.manual_download.title");
        Object[] objectArray = new Object[1];
        Path path = DownloadWatcherScreen.Companion.getDownloadFolder();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"access$getDownloadFolder(...)");
        objectArray[0] = ((Object)path.toAbsolutePath()).toString();
        super(booleanConsumer, component2, (Component)Component.translatable((String)"resourcify.manual_download.description", (Object[])objectArray), (Component)Component.translatable((String)"resourcify.manual_download.open"), (Component)Component.translatable((String)"resourcify.manual_download.cancel"));
        this.url = url;
        this.extension = extension;
        this.size = size;
        this.sha1 = sha1;
        this.previousScreen = previousScreen;
        this.fileCallback = fileCallback;
        this.watchService = FileSystems.getDefault().newWatchService();
        objectArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY};
        DownloadWatcherScreen.Companion.getDownloadFolder().register(this.watchService, (WatchEvent.Kind<?>[])objectArray);
    }

    public void tick() {
        if (this.closedWatchService) {
            return;
        }
        WatchKey key = this.watchService.poll();
        while (key != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (!Intrinsics.areEqual(event.kind(), StandardWatchEventKinds.ENTRY_CREATE) && !Intrinsics.areEqual(event.kind(), StandardWatchEventKinds.ENTRY_MODIFY)) continue;
                Object obj = event.context();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.nio.file.Path");
                Path newFile = (Path)obj;
                Path absolutePath = DownloadWatcherScreen.Companion.getDownloadFolder().resolve(newFile);
                File file = absolutePath.toFile();
                Intrinsics.checkNotNull((Object)file);
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)this.extension) || !file.exists() || file.length() != this.size || !Intrinsics.areEqual((Object)Utils.INSTANCE.getSha1(file), (Object)this.sha1)) continue;
                this.fileCallback.accept(absolutePath);
                this.closedWatchService = true;
                this.watchService.close();
                super.tick();
                return;
            }
            key.reset();
            key = this.watchService.poll();
        }
        super.tick();
    }

    public void onClose() {
        this.closedWatchService = true;
        this.watchService.close();
        super.onClose();
    }

    private static final void _init_$lambda$0(URI $url, Screen $previousScreen, boolean result) {
        if (result) {
            UDesktop.browse($url);
        } else {
            UScreen.Companion.displayScreen($previousScreen);
        }
    }

    private static final Path downloadFolder_delegate$lambda$1() {
        String[] stringArray = new String[]{"Downloads"};
        return Paths.get(System.getProperty("user.home"), stringArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R#\u0010\r\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Ldev/dediamondpro/resourcify/gui/DownloadWatcherScreen$Companion;", "", "<init>", "()V", "", "isUsable", "()Z", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "downloadFolder$delegate", "Lkotlin/Lazy;", "getDownloadFolder", "()Ljava/nio/file/Path;", "downloadFolder", "Resourcify (1.21.1-forge)-1.7.5"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDownloadFolder() {
            Lazy lazy = downloadFolder$delegate;
            return (Path)lazy.getValue();
        }

        public final boolean isUsable() {
            Path path = this.getDownloadFolder();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"<get-downloadFolder>(...)");
            Path path2 = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

