/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.constraints.animation;

import dev.dediamondpro.resourcify.libs.elementa.ElementaVersion;
import dev.dediamondpro.resourcify.libs.elementa.UIComponent;
import dev.dediamondpro.resourcify.libs.elementa.components.Window;
import dev.dediamondpro.resourcify.libs.elementa.constraints.SuperConstraint;
import dev.dediamondpro.resourcify.libs.elementa.constraints.animation.AnimationStrategy;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B!\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\fJ\r\u0010\u0014\u001a\u00020\n\u00a2\u0006\u0004\b\u0014\u0010\fJ\r\u0010\u0015\u001a\u00020\n\u00a2\u0006\u0004\b\u0015\u0010\fJ\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0016H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019R\"\u0010\u001b\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u0012\"\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0007\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\"R\"\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010 \u001a\u0004\b$\u0010\"\"\u0004\b%\u0010&R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010 \u001a\u0004\b-\u0010\"\u0082\u0001\u0007./01234\u00a8\u00065"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/AnimationComponent;", "T", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/SuperConstraint;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/AnimationStrategy;", "strategy", "", "totalFrames", "delayFrames", "<init>", "(Lgg/essential/elementa/constraints/animation/AnimationStrategy;II)V", "", "animationFrame", "()V", "", "getPercentComplete", "()F", "", "isComplete", "()Z", "pause", "resume", "stop", "Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;", "component", "update$Elementa", "(Ldev/dediamondpro/resourcify/libs/elementa/UIComponent;)V", "update", "animationPaused", "Z", "getAnimationPaused", "setAnimationPaused", "(Z)V", "I", "getDelayFrames", "()I", "elapsedFrames", "getElapsedFrames", "setElapsedFrames", "(I)V", "", "lastUpdateTime", "J", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/AnimationStrategy;", "getStrategy", "()Lgg/essential/elementa/constraints/animation/AnimationStrategy;", "getTotalFrames", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/ColorAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/FieldAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/HeightAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/RadiusAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/WidthAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/XAnimationComponent;", "Ldev/dediamondpro/resourcify/libs/elementa/constraints/animation/YAnimationComponent;", "Elementa"})
public abstract class AnimationComponent<T>
implements SuperConstraint<T> {
    @NotNull
    private final AnimationStrategy strategy;
    private final int totalFrames;
    private final int delayFrames;
    private int elapsedFrames;
    private boolean animationPaused;
    private long lastUpdateTime;

    private AnimationComponent(AnimationStrategy strategy, int totalFrames, int delayFrames) {
        this.strategy = strategy;
        this.totalFrames = totalFrames;
        this.delayFrames = delayFrames;
        this.lastUpdateTime = -1L;
    }

    @NotNull
    public final AnimationStrategy getStrategy() {
        return this.strategy;
    }

    public final int getTotalFrames() {
        return this.totalFrames;
    }

    public final int getDelayFrames() {
        return this.delayFrames;
    }

    public final int getElapsedFrames() {
        return this.elapsedFrames;
    }

    public final void setElapsedFrames(int n) {
        this.elapsedFrames = n;
    }

    public final boolean getAnimationPaused() {
        return this.animationPaused;
    }

    public final void setAnimationPaused(boolean bl) {
        this.animationPaused = bl;
    }

    public final void update$Elementa(@NotNull UIComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Window window = Window.Companion.ofOrNull(component2);
        if (window == null) {
            return;
        }
        Window window2 = window;
        if (window2.getVersion$Elementa().compareTo((Enum)ElementaVersion.Companion.getV8$Elementa()) < 0) {
            return;
        }
        long now = window2.getAnimationTimeMs();
        if (this.lastUpdateTime == -1L) {
            this.lastUpdateTime = now;
        }
        int dtMs = (int)(now - this.lastUpdateTime);
        this.lastUpdateTime = now;
        if (!this.animationPaused) {
            this.elapsedFrames = RangesKt.coerceAtMost((int)(this.elapsedFrames + dtMs), (int)(this.totalFrames + this.delayFrames));
        }
    }

    @Override
    @Deprecated(message="See [ElementaVersion.V8].")
    public void animationFrame() {
        SuperConstraint.super.animationFrame();
        if (this.isComplete() || this.animationPaused) {
            return;
        }
        int n = this.elapsedFrames;
        this.elapsedFrames = n + 1;
    }

    public final void stop() {
        this.elapsedFrames = this.totalFrames + this.delayFrames;
    }

    public final void pause() {
        this.animationPaused = true;
    }

    public final void resume() {
        this.animationPaused = false;
    }

    public final boolean isComplete() {
        return this.elapsedFrames - this.delayFrames >= this.totalFrames;
    }

    public final float getPercentComplete() {
        return this.strategy.getValue((float)Math.max(this.elapsedFrames - this.delayFrames, 0) / (float)this.totalFrames);
    }

    public /* synthetic */ AnimationComponent(AnimationStrategy strategy, int totalFrames, int delayFrames, DefaultConstructorMarker $constructor_marker) {
        this(strategy, totalFrames, delayFrames);
    }
}

