/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.services.ads;

import com.google.gson.reflect.TypeToken;
import dev.dediamondpro.resourcify.config.Config;
import dev.dediamondpro.resourcify.services.ads.IAdProvider;
import dev.dediamondpro.resourcify.util.JsonUtil;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.UtilsKt;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\f\u0010\u0003R$\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/dediamondpro/resourcify/services/ads/DefaultAdProvider;", "Ldev/dediamondpro/resourcify/services/ads/IAdProvider;", "<init>", "()V", "", "isAdAvailable", "()Z", "Ljava/util/concurrent/CompletableFuture;", "Ldev/dediamondpro/resourcify/services/ads/IAdProvider$IAd;", "get", "()Ljava/util/concurrent/CompletableFuture;", "", "fetchAds", "", "Ldev/dediamondpro/resourcify/services/ads/DefaultAdProvider$RemoteAd;", "ads", "Ljava/util/concurrent/CompletableFuture;", "RemoteAd", "Resourcify (1.21.1-forge)-1.7.5"})
@SourceDebugExtension(value={"SMAP\nDefaultAdProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAdProvider.kt\ndev/dediamondpro/resourcify/services/ads/DefaultAdProvider\n+ 2 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtilKt\n+ 3 JsonUtil.kt\ndev/dediamondpro/resourcify/util/JsonUtilKt\n*L\n1#1,64:1\n178#2,5:65\n35#3,2:70\n*S KotlinDebug\n*F\n+ 1 DefaultAdProvider.kt\ndev/dediamondpro/resourcify/services/ads/DefaultAdProvider\n*L\n38#1:65,5\n38#1:70,2\n*E\n"})
public final class DefaultAdProvider
implements IAdProvider {
    @NotNull
    public static final DefaultAdProvider INSTANCE = new DefaultAdProvider();
    @Nullable
    private static CompletableFuture<List<RemoteAd>> ads;

    private DefaultAdProvider() {
    }

    @Override
    public boolean isAdAvailable() {
        return Config.Companion.getInstance().getAdsEnabled();
    }

    @Override
    @NotNull
    public CompletableFuture<IAdProvider.IAd> get() {
        this.fetchAds();
        CompletionStage<Object> completionStage = ads;
        if (completionStage == null || (completionStage = completionStage.thenApply(arg_0 -> DefaultAdProvider.get$lambda$1(DefaultAdProvider::get$lambda$0, arg_0))) == null) {
            completionStage = MultiThreadingKt.supply(DefaultAdProvider::get$lambda$2);
        }
        return completionStage;
    }

    private final void fetchAds() {
        if (ads != null) {
            CompletableFuture<List<RemoteAd>> completableFuture = ads;
            boolean bl = completableFuture != null ? !completableFuture.isCompletedExceptionally() : false;
            if (bl) {
                return;
            }
        }
        ads = MultiThreadingKt.supplyAsync(DefaultAdProvider::fetchAds$lambda$3);
    }

    private static final IAdProvider.IAd get$lambda$0(List it) {
        Intrinsics.checkNotNull((Object)it);
        return (IAdProvider.IAd)CollectionsKt.randomOrNull((Collection)it, (Random)((Random)Random.Default));
    }

    private static final IAdProvider.IAd get$lambda$1(Function1 $tmp0, Object p0) {
        return (IAdProvider.IAd)$tmp0.invoke(p0);
    }

    private static final IAdProvider.IAd get$lambda$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List fetchAds$lambda$3() {
        Object object;
        void $this$getJson_u24default$iv;
        URI uRI = NetworkUtilKt.toURI("https://api.dediamondpro.dev/resourcify/ads");
        boolean useCache$iv = false;
        int attempts$iv = 3;
        Map headers$iv = MapsKt.emptyMap();
        boolean $i$f$getJson = false;
        String string = NetworkUtilKt.getString((URI)$this$getJson_u24default$iv, useCache$iv, attempts$iv, headers$iv);
        if (string != null) {
            String $this$fromJson$iv$iv = string;
            boolean $i$f$fromJson = false;
            Type type$iv$iv = new TypeToken<List<? extends RemoteAd>>(){}.getType();
            object = JsonUtil.INSTANCE.getGson().fromJson($this$fromJson$iv$iv, type$iv$iv);
        } else {
            object = null;
        }
        List list = (List)object;
        if (list == null) {
            throw new IllegalStateException("Failed to fetch ads.".toString());
        }
        return list;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0016\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\u00048\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\n\u00a8\u0006\u0010"}, d2={"Ldev/dediamondpro/resourcify/services/ads/DefaultAdProvider$RemoteAd;", "Ldev/dediamondpro/resourcify/services/ads/IAdProvider$IAd;", "<init>", "()V", "", "getText", "()Ljava/lang/String;", "getImageBase64", "getUrl", "text", "Ljava/lang/String;", "", "translate", "Ljava/lang/Boolean;", "icon", "url", "Resourcify (1.21.1-forge)-1.7.5"})
    public static final class RemoteAd
    implements IAdProvider.IAd {
        @NotNull
        private final String text;
        @Nullable
        private final Boolean translate;
        @Nullable
        private final String icon;
        @NotNull
        private final String url;

        public RemoteAd() {
            this.text = "";
            this.url = "";
        }

        @Override
        @NotNull
        public String getText() {
            if (Intrinsics.areEqual((Object)this.translate, (Object)true)) {
                return UtilsKt.localizeExtension(this.text, new Object[0]);
            }
            return this.text;
        }

        @Override
        @Nullable
        public String getImageBase64() {
            return this.icon;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.url;
        }
    }
}

