/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import dev.dediamondpro.resourcify.platform.Platform;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ7\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0010\u0010\u0011J=\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00122\u0006\u0010\u0005\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u0013\u0010\u0014J=\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00122\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\n2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0003J\r\u0010\u0019\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u0003R\u0014\u0010\u001a\u001a\u00020\n8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR \u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR(\u0010 \u001a\u0016\u0012\u0004\u0012\u00020\t\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00120\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001f\u00a8\u0006\""}, d2={"Ldev/dediamondpro/resourcify/util/NetworkUtil;", "", "<init>", "()V", "Ljava/net/URL;", "url", "Ljavax/net/ssl/HttpsURLConnection;", "setupConnection", "(Ljava/net/URL;)Ljavax/net/ssl/HttpsURLConnection;", "Ljava/net/URI;", "", "attempts", "", "", "headers", "", "getOrFetch", "(Ljava/net/URI;ILjava/util/Map;)[B", "Ljava/util/concurrent/CompletableFuture;", "getOrFetchAsync", "(Ljava/net/URI;ILjava/util/Map;)Ljava/util/concurrent/CompletableFuture;", "uri", "startFetch", "", "pruneCache", "clearCache", "MAX_CACHE_SIZE", "I", "Ljava/util/concurrent/ConcurrentHashMap;", "Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "currentlyFetching", "CacheObject", "Resourcify (1.21.1-forge)-1.7.5"})
@SourceDebugExtension(value={"SMAP\nNetworkUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,288:1\n1#2:289\n1053#3:290\n216#4,2:291\n*S KotlinDebug\n*F\n+ 1 NetworkUtil.kt\ndev/dediamondpro/resourcify/util/NetworkUtil\n*L\n100#1:290\n74#1:291,2\n*E\n"})
public final class NetworkUtil {
    @NotNull
    public static final NetworkUtil INSTANCE = new NetworkUtil();
    private static final int MAX_CACHE_SIZE = 100000000;
    @NotNull
    private static final ConcurrentHashMap<URI, CacheObject> cache = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<URI, CompletableFuture<byte[]>> currentlyFetching = new ConcurrentHashMap();

    private NetworkUtil() {
    }

    @NotNull
    public final HttpsURLConnection setupConnection(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection con = (HttpsURLConnection)uRLConnection;
        con.setRequestProperty("User-Agent", "Resourcify/1.7.5 (" + Platform.INSTANCE.getMcVersion() + "-" + Platform.INSTANCE.getLoader() + ")");
        con.setRequestProperty("Accept-Encoding", "gzip, deflate");
        con.setConnectTimeout(5000);
        con.setReadTimeout(5000);
        return con;
    }

    @Nullable
    public final byte[] getOrFetch(@NotNull URI url, int attempts, @NotNull Map<String, String> headers) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                object = cache.get(url);
                if (object == null) break block4;
                byte[] byArray = ((CacheObject)object).getBytes();
                object = byArray;
                if (byArray != null) break block5;
            }
            CompletableFuture<byte[]> completableFuture = currentlyFetching.get(url);
            Object object2 = completableFuture != null ? completableFuture.get() : null;
            object = object2;
            if (object2 == null) {
                object = this.startFetch(url, attempts, headers).get();
            }
        }
        return object;
    }

    public static /* synthetic */ byte[] getOrFetch$default(NetworkUtil networkUtil, URI uRI, int n, Map map2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return networkUtil.getOrFetch(uRI, n, map2);
    }

    @NotNull
    public final CompletableFuture<byte[]> getOrFetchAsync(@NotNull URI url, int attempts, @NotNull Map<String, String> headers) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter(headers, (String)"headers");
                object = cache.get(url);
                if (object == null) break block4;
                byte[] byArray = ((CacheObject)object).getBytes();
                object = byArray;
                if (byArray == null) break block4;
                CompletableFuture<byte[]> it = object;
                boolean bl = false;
                CompletableFuture<byte[]> completableFuture = MultiThreadingKt.supplyAsync(() -> NetworkUtil.getOrFetchAsync$lambda$1$lambda$0(it));
                object = completableFuture;
                if (completableFuture != null) break block5;
            }
            if ((object = currentlyFetching.get(url)) == null) {
                object = this.startFetch(url, attempts, headers);
            }
        }
        return object;
    }

    public static /* synthetic */ CompletableFuture getOrFetchAsync$default(NetworkUtil networkUtil, URI uRI, int n, Map map2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return networkUtil.getOrFetchAsync(uRI, n, map2);
    }

    private final CompletableFuture<byte[]> startFetch(URI uri, int attempts, Map<String, String> headers) {
        CompletableFuture<byte[]> completableFuture;
        CompletableFuture<byte[]> $this$startFetch_u24lambda_u247 = completableFuture = MultiThreadingKt.supplyAsync(() -> NetworkUtil.startFetch$lambda$6(attempts, uri, headers));
        boolean bl = false;
        ((Map)currentlyFetching).put(uri, $this$startFetch_u24lambda_u247);
        CompletionStage completionStage = completableFuture.whenComplete((arg_0, arg_1) -> NetworkUtil.startFetch$lambda$9((arg_0, arg_1) -> NetworkUtil.startFetch$lambda$8(uri, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        return completionStage;
    }

    static /* synthetic */ CompletableFuture startFetch$default(NetworkUtil networkUtil, URI uRI, int n, Map map2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        return networkUtil.startFetch(uRI, n, map2);
    }

    /*
     * WARNING - void declaration
     */
    private final void pruneCache() {
        Collection<CacheObject> collection = cache.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        int n = 0;
        for (Object t : iterable) {
            void it;
            CacheObject cacheObject = (CacheObject)t;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getSize();
            n = n2 + n3;
        }
        int cacheSize = n;
        if (cacheSize <= 100000000) {
            return;
        }
        Collection<CacheObject> collection2 = cache.values();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"<get-values>(...)");
        Iterable $this$sortedBy$iv = collection2;
        boolean $i$f$sortedBy = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                CacheObject it = (CacheObject)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getLastAccess());
                it = (CacheObject)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getLastAccess()));
            }
        });
        int i2 = 0;
        while (cacheSize > 100000000) {
            Object e = sorted.get(i2);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            CacheObject element = (CacheObject)e;
            cache.remove(element.getUrl());
            cacheSize -= element.getSize();
            ++i2;
        }
    }

    public final void clearCache() {
        for (Map.Entry entry : ((Map)currentlyFetching).entrySet()) {
            URI url = (URI)entry.getKey();
            CompletableFuture future = (CompletableFuture)entry.getValue();
            try {
                future.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentlyFetching.remove(url);
        }
        cache.clear();
    }

    private static final byte[] getOrFetchAsync$lambda$1$lambda$0(byte[] $it) {
        return $it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final byte[] startFetch$lambda$6(int $attempts, URI $uri, Map $headers) {
        for (i = 0; i < $attempts; ++i) {
            try {
                v0 = $uri.toURL();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toURL(...)");
                var6_7 = NetworkUtilKt.setupConnection(v0);
                $this$startFetch_u24lambda_u246_u24lambda_u243 = var6_7;
                $i$a$-apply-NetworkUtil$startFetch$1$result$1 = false;
                $this$forEach$iv = $headers;
                $i$f$forEach = false;
                var11_16 = $this$forEach$iv.entrySet().iterator();
                while (var11_16.hasNext()) {
                    var13_18 = element$iv = var11_16.next();
                    $i$a$-forEach-NetworkUtil$startFetch$1$result$1$1 = false;
                    key = (String)var13_18.getKey();
                    value = (String)var13_18.getValue();
                    $this$startFetch_u24lambda_u246_u24lambda_u243.setRequestProperty(key, value);
                }
                var5_6 = NetworkUtilKt.getEncodedInputStream((URLConnection)var6_7);
                if (var5_6 == null) ** GOTO lbl-1000
                var7_8 = var5_6;
                $i$a$-apply-NetworkUtil$startFetch$1$result$1 = null;
                try {
                    it = (InputStream)var7_8;
                    $i$a$-use-NetworkUtil$startFetch$1$result$2 = false;
                    it = ByteStreamsKt.readBytes((InputStream)it);
                }
                catch (Throwable var10_14) {
                    $i$a$-apply-NetworkUtil$startFetch$1$result$1 = var10_14;
                    throw var10_14;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var7_8, (Throwable)$i$a$-apply-NetworkUtil$startFetch$1$result$1);
                }
                var6_7 = it;
                if (var6_7 != null) {
                    it = var6_7;
                    $i$a$-let-NetworkUtil$startFetch$1$result$3 = false;
                    ((Map)NetworkUtil.cache).put($uri, new CacheObject($uri, (byte[])it, 0L, 4, null));
                    v1 = it;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = result = null;
                }
                if (result != null) {
                    return result;
                }
            }
            catch (Exception e) {
                Constants.INSTANCE.getLOGGER().error("Failed to fetch \"" + NetworkUtil.INSTANCE + "\"", (Throwable)e);
            }
            Thread.sleep(250L);
        }
        return null;
    }

    private static final Unit startFetch$lambda$8(URI $uri, byte[] byArray, Throwable throwable) {
        currentlyFetching.remove($uri);
        INSTANCE.pruneCache();
        return Unit.INSTANCE;
    }

    private static final void startFetch$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c2\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J.\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001fR\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010 \u001a\u0004\b!\u0010\u0010\"\u0004\b\"\u0010#R\u0017\u0010$\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010\u0019\u00a8\u0006'"}, d2={"Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "", "Ljava/net/URI;", "url", "", "bytes", "", "lastAccess", "<init>", "(Ljava/net/URI;[BJ)V", "getBytes", "()[B", "component1", "()Ljava/net/URI;", "component2", "component3", "()J", "copy", "(Ljava/net/URI;[BJ)Ldev/dediamondpro/resourcify/util/NetworkUtil$CacheObject;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/net/URI;", "getUrl", "[B", "J", "getLastAccess", "setLastAccess", "(J)V", "size", "I", "getSize", "Resourcify (1.21.1-forge)-1.7.5"})
    private static final class CacheObject {
        @NotNull
        private final URI url;
        @NotNull
        private final byte[] bytes;
        private long lastAccess;
        private final int size;

        public CacheObject(@NotNull URI url, @NotNull byte[] bytes, long lastAccess) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            this.url = url;
            this.bytes = bytes;
            this.lastAccess = lastAccess;
            this.size = this.bytes.length;
        }

        public /* synthetic */ CacheObject(URI uRI, byte[] byArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l = UMinecraft.getTime();
            }
            this(uRI, byArray, l);
        }

        @NotNull
        public final URI getUrl() {
            return this.url;
        }

        public final long getLastAccess() {
            return this.lastAccess;
        }

        public final void setLastAccess(long l) {
            this.lastAccess = l;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final byte[] getBytes() {
            this.lastAccess = UMinecraft.getTime();
            return this.bytes;
        }

        @NotNull
        public final URI component1() {
            return this.url;
        }

        private final byte[] component2() {
            return this.bytes;
        }

        public final long component3() {
            return this.lastAccess;
        }

        @NotNull
        public final CacheObject copy(@NotNull URI url, @NotNull byte[] bytes, long lastAccess) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return new CacheObject(url, bytes, lastAccess);
        }

        public static /* synthetic */ CacheObject copy$default(CacheObject cacheObject, URI uRI, byte[] byArray, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uRI = cacheObject.url;
            }
            if ((n & 2) != 0) {
                byArray = cacheObject.bytes;
            }
            if ((n & 4) != 0) {
                l = cacheObject.lastAccess;
            }
            return cacheObject.copy(uRI, byArray, l);
        }

        @NotNull
        public String toString() {
            return "CacheObject(url=" + this.url + ", bytes=" + Arrays.toString(this.bytes) + ", lastAccess=" + this.lastAccess + ")";
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + Arrays.hashCode(this.bytes);
            result = result * 31 + Long.hashCode(this.lastAccess);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheObject)) {
                return false;
            }
            CacheObject cacheObject = (CacheObject)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)cacheObject.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.bytes, (Object)cacheObject.bytes)) {
                return false;
            }
            return this.lastAccess == cacheObject.lastAccess;
        }
    }
}

