/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.Constants;
import java.awt.Color;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/dediamondpro/resourcify/util/Utils;", "", "<init>", "()V", "Ljava/io/File;", "file", "", "getSha1", "(Ljava/io/File;)Ljava/lang/String;", "Ljava/awt/Color;", "color", "getShadowColor", "(Ljava/awt/Color;)Ljava/awt/Color;", "fileName", "incrementFileName", "(Ljava/lang/String;)Ljava/lang/String;", "asset", "Lnet/minecraft/resources/ResourceLocation;", "createResourceLocation", "(Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "Resourcify (1.21.1-forge)-1.7.5"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ndev/dediamondpro/resourcify/util/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n1#2:110\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getSha1(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
                MessageDigest digest = messageDigest;
                byte[] buffer = new byte[1024];
                int count = 0;
                while (true) {
                    int n;
                    int it2 = n = it.read(buffer);
                    boolean bl2 = false;
                    count = it2;
                    if (n == -1) break;
                    digest.update(buffer, 0, count);
                }
                byte[] byArray = digest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                byte[] digested = byArray;
                StringBuilder sb = new StringBuilder();
                for (byte b : digested) {
                    String string = Integer.toString((b & 0xFF) + 256, CharsKt.checkRadix((int)16));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    String string2 = string.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    sb.append(string2);
                }
                String string = sb.toString();
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            Constants.INSTANCE.getLOGGER().error("Failed to get SHA-1 for file \"" + file + "\"", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Constants.INSTANCE.getLOGGER().error("Failed to get SHA-1 for file \"" + file + "\"", (Throwable)e);
        }
        return null;
    }

    @NotNull
    public final Color getShadowColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int rgb = color.getRGB();
        return new Color((rgb & 0xFCFCFC) >> 2 | rgb & 0xFF000000);
    }

    @NotNull
    public final String incrementFileName(@NotNull String fileName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Regex regex = new Regex("\\((\\d+)\\)(\\.\\w+)?$");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)fileName, (int)0, (int)2, null);
        if (matchResult != null) {
            int currentNumber = Integer.parseInt((String)matchResult.getGroupValues().get(1));
            String extension = (String)matchResult.getGroupValues().get(2);
            CharSequence charSequence = fileName;
            String string = "(" + (currentNumber + 1) + ")" + extension;
            object = regex.replace(charSequence, string);
        } else {
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex != -1) {
                String string = fileName.substring(0, dotIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = fileName.substring(dotIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string + " (1)." + string2;
            } else {
                object = fileName + " (1)";
            }
        }
        return object;
    }

    @NotNull
    public final ResourceLocation createResourceLocation(@NotNull String asset) {
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        ResourceLocation resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"resourcify", (String)asset);
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"fromNamespaceAndPath(...)");
        return resourceLocation;
    }
}

