/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.config.Config;
import dev.dediamondpro.resourcify.gui.ConfirmLinkScreen;
import dev.dediamondpro.resourcify.gui.projectpage.ProjectScreen;
import dev.dediamondpro.resourcify.libs.minemark.providers.BrowserProvider;
import dev.dediamondpro.resourcify.libs.universal.UScreen;
import dev.dediamondpro.resourcify.platform.TickHandler;
import dev.dediamondpro.resourcify.services.IProject;
import dev.dediamondpro.resourcify.services.IService;
import dev.dediamondpro.resourcify.services.ProjectType;
import dev.dediamondpro.resourcify.services.ServiceRegistry;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ldev/dediamondpro/resourcify/util/ConfirmingBrowserProvider;", "Ldev/dediamondpro/resourcify/libs/minemark/providers/BrowserProvider;", "<init>", "()V", "", "url", "", "browse", "(Ljava/lang/String;)V", "Ldev/dediamondpro/resourcify/gui/projectpage/ProjectScreen;", "screen", "", "tryCreateScreen", "(Ljava/lang/String;Ldev/dediamondpro/resourcify/gui/projectpage/ProjectScreen;)Z", "Resourcify (1.21.5-neoforge)-1.7.5"})
public final class ConfirmingBrowserProvider
implements BrowserProvider {
    @NotNull
    public static final ConfirmingBrowserProvider INSTANCE = new ConfirmingBrowserProvider();

    private ConfirmingBrowserProvider() {
    }

    @Override
    public void browse(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String actualUrl = url;
        if (StringsKt.startsWith$default((String)actualUrl, (String)"/linkout?remoteUrl=", (boolean)false, (int)2, null)) {
            actualUrl = URLDecoder.decode(URLDecoder.decode(StringsKt.removePrefix((String)actualUrl, (CharSequence)"/linkout?remoteUrl="), "UTF-8"), "UTF-8");
        }
        Screen screen = UScreen.Companion.getCurrentScreen();
        if (Config.Companion.getInstance().getOpenLinkInResourcify() && screen instanceof ProjectScreen && this.tryCreateScreen(actualUrl, (ProjectScreen)screen)) {
            return;
        }
        UScreen.Companion.displayScreen((Screen)new ConfirmLinkScreen(actualUrl, UScreen.Companion.getCurrentScreen(), false, 4, null));
    }

    private final boolean tryCreateScreen(String url, ProjectScreen screen) {
        URI uRI = NetworkUtilKt.toURIOrNull(url);
        if (uRI == null) {
            return false;
        }
        URI uri = uRI;
        for (IService service : ServiceRegistry.INSTANCE.getAllServices()) {
            if (!service.canFetchProjectUrl(uri)) continue;
            CompletableFuture<IProject> completableFuture = service.fetchProjectFromUrl(uri);
            if (completableFuture == null) {
                return false;
            }
            CompletableFuture<IProject> future = completableFuture;
            future.whenComplete((arg_0, arg_1) -> ConfirmingBrowserProvider.tryCreateScreen$lambda$2((arg_0, arg_1) -> ConfirmingBrowserProvider.tryCreateScreen$lambda$1(url, service, screen, arg_0, arg_1), arg_0, arg_1));
            return true;
        }
        return false;
    }

    private static final Unit tryCreateScreen$lambda$1$lambda$0(Throwable $error, IProject $project, String $url, IService $service, ProjectScreen $screen) {
        if ($error != null || $project == null) {
            Constants.INSTANCE.getLOGGER().warn("Failed to fetch project for \"" + $url + "\" from source \"" + $service.getName() + "\"", $error);
            UScreen.Companion.displayScreen((Screen)new ConfirmLinkScreen($url, UScreen.Companion.getCurrentScreen(), false, 4, null));
            return Unit.INSTANCE;
        }
        ProjectType type2 = $project.getType();
        File downloadFolder = type2.getDirectoryFromCurrent($screen.getType(), $screen.getDownloadFolder());
        UScreen.Companion.displayScreen(new ProjectScreen($service, $project, type2, downloadFolder));
        return Unit.INSTANCE;
    }

    private static final Unit tryCreateScreen$lambda$1(String $url, IService $service, ProjectScreen $screen, IProject project, Throwable error) {
        TickHandler.INSTANCE.runAtNextTick((Function0<Unit>)((Function0)() -> ConfirmingBrowserProvider.tryCreateScreen$lambda$1$lambda$0(error, project, $url, $service, $screen)));
        return Unit.INSTANCE;
    }

    private static final void tryCreateScreen$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

