/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.util;

import dev.dediamondpro.resourcify.Constants;
import dev.dediamondpro.resourcify.platform.Platform;
import dev.dediamondpro.resourcify.util.DownloadData;
import dev.dediamondpro.resourcify.util.MultiThreadingKt;
import dev.dediamondpro.resourcify.util.NetworkUtilKt;
import dev.dediamondpro.resourcify.util.QueuedDownload;
import dev.dediamondpro.resourcify.util.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n2\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u001d\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020$0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010&\u00a8\u0006)"}, d2={"Ldev/dediamondpro/resourcify/util/DownloadManager;", "", "<init>", "()V", "Ljava/io/File;", "file", "", "sha512", "Ljava/net/URI;", "uri", "", "extract", "Lkotlin/Function0;", "", "callback", "download", "(Ljava/io/File;Ljava/lang/String;Ljava/net/URI;ZLkotlin/jvm/functions/Function0;)V", "", "getProgress", "(Ljava/net/URI;)Ljava/lang/Float;", "cancelDownload", "(Ljava/net/URI;)V", "downloadNext", "zipFile", "dest", "extractWorldZip", "(Ljava/io/File;Ljava/io/File;)V", "Lorg/apache/commons/compress/archivers/zip/ZipArchiveEntry;", "entry", "targetDir", "prefix", "resolvePath", "(Lorg/apache/commons/compress/archivers/zip/ZipArchiveEntry;Ljava/io/File;Ljava/lang/String;)Ljava/io/File;", "tempFolder", "Ljava/io/File;", "", "Ldev/dediamondpro/resourcify/util/QueuedDownload;", "queuedDownloads", "Ljava/util/Map;", "Ldev/dediamondpro/resourcify/util/DownloadData;", "downloadsInProgress", "Resourcify (1.21.5-fabric)-1.7.5"})
@SourceDebugExtension(value={"SMAP\nDownloadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadManager.kt\ndev/dediamondpro/resourcify/util/DownloadManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1#2:178\n*E\n"})
public final class DownloadManager {
    @NotNull
    public static final DownloadManager INSTANCE = new DownloadManager();
    @NotNull
    private static final File tempFolder = Platform.INSTANCE.getFileInGameDir("resourcify-temp");
    @NotNull
    private static final Map<URI, QueuedDownload> queuedDownloads = new LinkedHashMap();
    @NotNull
    private static final Map<URI, DownloadData> downloadsInProgress = new LinkedHashMap();

    private DownloadManager() {
    }

    public final void download(@NotNull File file, @Nullable String sha512, @NotNull URI uri, boolean extract, @Nullable Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        queuedDownloads.put(uri, new QueuedDownload(file, sha512, extract, callback));
        this.downloadNext();
    }

    public static /* synthetic */ void download$default(DownloadManager downloadManager, File file, String string, URI uRI, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            function0 = null;
        }
        downloadManager.download(file, string, uRI, bl, (Function0<Unit>)function0);
    }

    @Nullable
    public final Float getProgress(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (queuedDownloads.containsKey(uri)) {
            return Float.valueOf(0.0f);
        }
        if (!downloadsInProgress.containsKey(uri)) {
            return null;
        }
        Object object = downloadsInProgress.get(uri);
        if (object == null || (object = ((DownloadData)object).getLength()) == null) {
            return Float.valueOf(0.0f);
        }
        int length = (Integer)object;
        Object object2 = downloadsInProgress.get(uri);
        return Float.valueOf((object2 != null && (object2 = ((DownloadData)object2).getFile()) != null ? (float)((File)object2).length() : 0.0f) / (float)length);
    }

    public final void cancelDownload(@NotNull URI uri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (queuedDownloads.containsKey(uri)) {
            queuedDownloads.remove(uri);
            return;
        }
        if (!downloadsInProgress.containsKey(uri)) {
            return;
        }
        Object object2 = downloadsInProgress.get(uri);
        if (object2 != null && (object2 = ((DownloadData)object2).getFuture()) != null) {
            ((CompletableFuture)object2).cancel(true);
        }
        if ((object = downloadsInProgress.get(uri)) != null && (object = ((DownloadData)object).getFile()) != null) {
            ((File)object).delete();
        }
        downloadsInProgress.remove(uri);
    }

    private final void downloadNext() {
        if (downloadsInProgress.size() >= 2) {
            return;
        }
        URI uRI = (URI)CollectionsKt.firstOrNull((Iterable)queuedDownloads.keySet());
        if (uRI == null) {
            return;
        }
        URI url = uRI;
        QueuedDownload queuedDownload = queuedDownloads.remove(url);
        if (queuedDownload == null) {
            return;
        }
        QueuedDownload queuedDownload2 = queuedDownload;
        tempFolder.mkdirs();
        Ref.ObjectRef tempFile = new Ref.ObjectRef();
        tempFile.element = new File(tempFolder, queuedDownload2.getFile().getName() + ".tmp");
        int i2 = 0;
        while (((File)tempFile.element).exists()) {
            tempFile.element = new File(tempFolder, queuedDownload2.getFile().getName() + "-" + i2 + ".tmp");
        }
        Map<URI, DownloadData> map2 = downloadsInProgress;
        CompletionStage completionStage = MultiThreadingKt.runAsync(() -> DownloadManager.downloadNext$lambda$3(url, tempFile, queuedDownload2)).whenComplete((arg_0, arg_1) -> DownloadManager.downloadNext$lambda$5((arg_0, arg_1) -> DownloadManager.downloadNext$lambda$4(url, tempFile, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
        DownloadData downloadData = new DownloadData((CompletableFuture)completionStage, (File)tempFile.element, null, 4, null);
        map2.put(url, downloadData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extractWorldZip(@NotNull File zipFile, @NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.mkdirs();
        Closeable closeable = (Closeable)new ZipFile(zipFile);
        Throwable throwable = null;
        try {
            ZipArchiveEntry entry;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            Object prefixToRemove = null;
            Stack<ZipArchiveEntry> entriesToExtract = new Stack<ZipArchiveEntry>();
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                entry = (ZipArchiveEntry)entries.nextElement();
                entriesToExtract.push(entry);
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String fileName = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
                if (!Intrinsics.areEqual((Object)fileName, (Object)"level.dat")) continue;
                String string2 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                prefixToRemove = StringsKt.substringBeforeLast$default((String)string2, (String)"/", null, (int)2, null);
                prefixToRemove = ((CharSequence)prefixToRemove).length() == 0 ? null : (String)prefixToRemove + "/";
                break;
            }
            while (!((Collection)entriesToExtract).isEmpty() || entries.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = entry = !((Collection)entriesToExtract).isEmpty() ? (ZipArchiveEntry)entriesToExtract.pop() : (ZipArchiveEntry)entries.nextElement();
                if (prefixToRemove != null) {
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (!StringsKt.startsWith$default((String)string, prefixToRemove, (boolean)false, (int)2, null)) continue;
                }
                Intrinsics.checkNotNull((Object)entry);
                File entryFile = INSTANCE.resolvePath(entry, dest, (String)prefixToRemove);
                if (entry.isDirectory()) {
                    entryFile.mkdirs();
                    continue;
                }
                entryFile.getParentFile().mkdirs();
                Closeable closeable2 = zip.getInputStream(entry);
                Throwable throwable2 = null;
                try {
                    InputStream it = (InputStream)closeable2;
                    boolean bl2 = false;
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(it, entryFile.toPath(), copyOptionArray);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final File resolvePath(ZipArchiveEntry entry, File targetDir, String prefix) {
        String string;
        String it = entry.getName();
        boolean bl = false;
        if (prefix != null) {
            Intrinsics.checkNotNull((Object)it);
            string = StringsKt.removePrefix((String)it, (CharSequence)prefix);
        } else {
            string = it;
        }
        String entryName = string;
        Intrinsics.checkNotNull((Object)entryName);
        File destination = FilesKt.normalize((File)FilesKt.resolve((File)targetDir, (String)entryName));
        String string2 = destination.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        String string3 = FilesKt.normalize((File)targetDir).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        if (!StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) {
            throw new IllegalStateException(("Bad zip entry, " + entry.getName() + " is not in correct directory.").toString());
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void downloadNext$lambda$3(URI $url, Ref.ObjectRef $tempFile, QueuedDownload $queuedDownload) {
        block12: {
            URL uRL = $url.toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
            HttpsURLConnection con = NetworkUtilKt.setupConnection(uRL);
            DownloadData downloadData = downloadsInProgress.get($url);
            if (downloadData != null) {
                downloadData.setLength(con.getContentLength());
            }
            CopyOption[] copyOptionArray = (CopyOption[])NetworkUtilKt.getEncodedInputStream(con);
            Throwable throwable = null;
            try {
                InputStream it22 = (InputStream)copyOptionArray;
                boolean bl = false;
                InputStream inputStream = it22;
                Intrinsics.checkNotNull((Object)inputStream);
                CopyOption[] copyOptionArray2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long it22 = Files.copy(inputStream, ((File)$tempFile.element).toPath(), copyOptionArray2);
            }
            catch (Throwable it22) {
                throwable = it22;
                throw it22;
            }
            finally {
                CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable);
            }
            if (!downloadsInProgress.containsKey($url)) {
                ((File)$tempFile.element).delete();
                return;
            }
            String string = $queuedDownload.getSha1();
            if (string != null) {
                String it = string;
                boolean bl = false;
                String hash = Utils.INSTANCE.getSha1((File)$tempFile.element);
                if (!Intrinsics.areEqual((Object)hash, (Object)it)) {
                    ((File)$tempFile.element).delete();
                    throw new IllegalStateException(("Hash " + hash + " does not match expected hash " + it + "!").toString());
                }
            }
            if ($queuedDownload.getExtract()) {
                File targetFolder = $queuedDownload.getFile();
                INSTANCE.extractWorldZip((File)$tempFile.element, targetFolder);
            } else {
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.move(((File)$tempFile.element).toPath(), $queuedDownload.getFile().toPath(), copyOptionArray);
            }
            ((File)$tempFile.element).delete();
            Function0<Unit> function0 = $queuedDownload.getCallback();
            if (function0 == null) break block12;
            Function0<Unit> it = function0;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final Unit downloadNext$lambda$4(URI $url, Ref.ObjectRef $tempFile, Void void_, Throwable throwable) {
        if (throwable != null) {
            Constants.INSTANCE.getLOGGER().error("Failed to download '" + $url + "'", throwable);
            ((File)$tempFile.element).delete();
        }
        downloadsInProgress.remove($url);
        INSTANCE.downloadNext();
        return Unit.INSTANCE;
    }

    private static final void downloadNext$lambda$5(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

