/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.internal;

import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableBlock;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableBody;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableCell;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableHead;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.TableRow;
import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import dev.dediamondpro.resourcify.libs.commonmark.node.Node;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.text.TextContentNodeRendererContext;
import dev.dediamondpro.resourcify.libs.commonmark.renderer.text.TextContentWriter;

public class TableTextContentNodeRenderer
extends TableNodeRenderer {
    private final TextContentWriter textContentWriter;
    private final TextContentNodeRendererContext context;

    public TableTextContentNodeRenderer(TextContentNodeRendererContext context) {
        this.textContentWriter = context.getWriter();
        this.context = context;
    }

    @Override
    protected void renderBlock(TableBlock tableBlock) {
        this.renderChildren(tableBlock);
        if (tableBlock.getNext() != null) {
            this.textContentWriter.write("\n");
        }
    }

    @Override
    protected void renderHead(TableHead tableHead) {
        this.renderChildren(tableHead);
    }

    @Override
    protected void renderBody(TableBody tableBody) {
        this.renderChildren(tableBody);
    }

    @Override
    protected void renderRow(TableRow tableRow) {
        this.textContentWriter.line();
        this.renderChildren(tableRow);
        this.textContentWriter.line();
    }

    @Override
    protected void renderCell(TableCell tableCell) {
        this.renderChildren(tableCell);
        this.textContentWriter.write('|');
        this.textContentWriter.whitespace();
    }

    private void renderLastCell(TableCell tableCell) {
        this.renderChildren(tableCell);
    }

    private void renderChildren(Node parent) {
        Node node2 = parent.getFirstChild();
        while (node2 != null) {
            Node next = node2.getNext();
            if (node2 instanceof TableCell && next == null) {
                this.renderLastCell((TableCell)node2);
            } else {
                this.context.render(node2);
            }
            node2 = next;
        }
    }
}

