/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.mixins;

import dev.dediamondpro.resourcify.gui.injections.ImageButton;
import dev.dediamondpro.resourcify.gui.injections.PackScreensAddition;
import dev.dediamondpro.resourcify.platform.Platform;
import dev.dediamondpro.resourcify.services.ProjectType;
import java.util.List;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Screen.class})
abstract class ScreenMixin {
    @Shadow
    @Final
    private List<Renderable> renderables;
    @Shadow
    @Final
    private List<NarratableEntry> narratables;
    @Shadow
    @Final
    private List<GuiEventListener> children;
    @Unique
    private List<ImageButton> resourcifyCustomButtons;

    ScreenMixin() {
    }

    @Inject(method={"init(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;triggerImmediateNarration(Z)V", shift=At.Shift.BEFORE)})
    private void onInit(CallbackInfo ci) {
        this.handleInit_Resourcify();
    }

    @Inject(method={"resize(Lnet/minecraft/client/Minecraft;II)V"}, at={@At(value="TAIL")})
    private void onResize(CallbackInfo ci) {
        this.handleInit_Resourcify();
    }

    @Unique
    private void handleInit_Resourcify() {
        if (this.resourcifyCustomButtons == null) {
            String title = Platform.INSTANCE.getTranslateKey((Screen)this);
            ProjectType type2 = PackScreensAddition.INSTANCE.getType(title);
            if (type2 == null) {
                return;
            }
            this.resourcifyCustomButtons = PackScreensAddition.INSTANCE.getButtons((Screen)this, type2);
            if (this.resourcifyCustomButtons == null) {
                return;
            }
        }
        this.updateButtons_Resourcify(this.children);
        this.updateButtons_Resourcify(this.renderables);
        this.updateButtons_Resourcify(this.narratables);
    }

    @Unique
    private <T> void updateButtons_Resourcify(List<T> list) {
        for (ImageButton button : this.resourcifyCustomButtons) {
            button.updateLocation((Screen)this);
            if (list.contains((Object)button)) continue;
            list.add((T)((Object)button));
        }
    }
}

