/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.platform;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.repository.Pack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Ldev/dediamondpro/resourcify/platform/Platform;", "", "<init>", "()V", "", "getMcVersion", "()Ljava/lang/String;", "getLoader", "Lnet/minecraft/client/gui/screens/Screen;", "screen", "getTranslateKey", "(Lnet/minecraft/client/gui/screens/Screen;)Ljava/lang/String;", "Lnet/minecraft/server/packs/repository/Pack$ResourcesSupplier;", "resources", "Ljava/io/File;", "getFileFromPackResourceSupplier", "(Lnet/minecraft/server/packs/repository/Pack$ResourcesSupplier;)Ljava/io/File;", "name", "getFileInGameDir", "(Ljava/lang/String;)Ljava/io/File;", "Resourcify (1.21.8-neoforge)-1.7.5"})
public final class Platform {
    @NotNull
    public static final Platform INSTANCE = new Platform();

    private Platform() {
    }

    @NotNull
    public final String getMcVersion() {
        String string = SharedConstants.getCurrentVersion().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return string;
    }

    @NotNull
    public final String getLoader() {
        return "neoforge";
    }

    @NotNull
    public final String getTranslateKey(@NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        ComponentContents content = screen.getTitle().getContents();
        if (!(content instanceof TranslatableContents)) {
            String optifineTranslation = I18n.get((String)"of.options.shadersTitle", (Object[])new Object[0]);
            if (!Intrinsics.areEqual((Object)optifineTranslation, (Object)"of.options.shadersTitle") && Intrinsics.areEqual((Object)optifineTranslation, (Object)screen.getTitle().getString())) {
                return "of.options.shadersTitle";
            }
            String string = screen.getTitle().getString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            return string;
        }
        String string = ((TranslatableContents)content).getKey();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
        return string;
    }

    @Nullable
    public final File getFileFromPackResourceSupplier(@NotNull Pack.ResourcesSupplier resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        if (!(resources instanceof FilePackResources.FileResourcesSupplier)) {
            return null;
        }
        return ((FilePackResources.FileResourcesSupplier)resources).content;
    }

    @NotNull
    public final File getFileInGameDir(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new File(Minecraft.getInstance().gameDirectory, name);
    }
}

