/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.kvakva.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.mossylib.utils.CodecUtils;
import net.lopymine.mossylib.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvaKvaConfig {
    public static final Codec<KvaKvaConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.option((String)"mod_enabled", (Object)true, (Codec)Codec.BOOL, KvaKvaConfig::isModEnabled), (App)CodecUtils.option((String)"russian_variants_enabled", (Object)true, (Codec)Codec.BOOL, KvaKvaConfig::isRussianVariantsEnabled), (App)CodecUtils.option((String)"english_variants_enabled", (Object)false, (Codec)Codec.BOOL, KvaKvaConfig::isEnglishVariantsEnabled), (App)CodecUtils.option((String)"peaceful_mode", (Object)false, (Codec)Codec.BOOL, KvaKvaConfig::isPeacefulMode)).apply((Applicative)instance, KvaKvaConfig::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("kvakva.json5").toFile();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"KvaKva/Config");
    private static KvaKvaConfig INSTANCE;
    private boolean modEnabled;
    private boolean russianVariantsEnabled;
    private boolean englishVariantsEnabled;
    private boolean peacefulMode;

    private KvaKvaConfig() {
        throw new IllegalArgumentException();
    }

    public static KvaKvaConfig getInstance() {
        return INSTANCE == null ? KvaKvaConfig.reload() : INSTANCE;
    }

    public static KvaKvaConfig reload() {
        INSTANCE = KvaKvaConfig.read();
        return INSTANCE;
    }

    public static KvaKvaConfig getNewInstance() {
        return (KvaKvaConfig)CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static KvaKvaConfig read() {
        return (KvaKvaConfig)ConfigUtils.readConfig(CODEC, (File)CONFIG_FILE, (Logger)LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig((Object)this, CODEC, (File)CONFIG_FILE, (Logger)LOGGER);
    }

    @Generated
    public boolean isModEnabled() {
        return this.modEnabled;
    }

    @Generated
    public boolean isRussianVariantsEnabled() {
        return this.russianVariantsEnabled;
    }

    @Generated
    public boolean isEnglishVariantsEnabled() {
        return this.englishVariantsEnabled;
    }

    @Generated
    public boolean isPeacefulMode() {
        return this.peacefulMode;
    }

    @Generated
    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    @Generated
    public void setRussianVariantsEnabled(boolean russianVariantsEnabled) {
        this.russianVariantsEnabled = russianVariantsEnabled;
    }

    @Generated
    public void setEnglishVariantsEnabled(boolean englishVariantsEnabled) {
        this.englishVariantsEnabled = englishVariantsEnabled;
    }

    @Generated
    public void setPeacefulMode(boolean peacefulMode) {
        this.peacefulMode = peacefulMode;
    }

    @Generated
    public KvaKvaConfig(boolean modEnabled, boolean russianVariantsEnabled, boolean englishVariantsEnabled, boolean peacefulMode) {
        this.modEnabled = modEnabled;
        this.russianVariantsEnabled = russianVariantsEnabled;
        this.englishVariantsEnabled = englishVariantsEnabled;
        this.peacefulMode = peacefulMode;
    }
}

