/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Commands;

import dev.xhue.neon.NeON;
import dev.xhue.neon.Utils.FireworkUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandHandler
implements CommandExecutor {
    private final NeON plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public CommandHandler(NeON plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (command.getName().equalsIgnoreCase("neon")) {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("neon.reload")) {
                    Component noPermMessage = this.miniMessage.deserialize((Object)(NeON.prefix + "<red>You do not have permission to execute this command.</red>"));
                    sender.sendMessage(noPermMessage);
                    this.plugin.getPluginLogger().warning(this.legacyFromMiniMessage(NeON.prefix + "<red>Permission denied for " + sender.getName() + ".</red>"));
                    return true;
                }
                try {
                    if (this.plugin.getConfigManager().reloadConfig()) {
                        Component successMessage = this.miniMessage.deserialize((Object)(NeON.prefix + "<dark_gray> \u00bb <gray>NeON configuration reloaded <green>successfully<gray>!</green>"));
                        sender.sendMessage(successMessage);
                        this.plugin.getPluginLogger().info(this.legacyFromMiniMessage(NeON.prefix + "<dark_gray> \u00bb <gray>Configuration reloaded by " + sender.getName() + ".</gray>"));
                    } else {
                        Component errorMessage = this.miniMessage.deserialize((Object)(NeON.prefix + "<dark_gray> \u00bb <red>Failed to reload NeON configuration. Configuration in memory remains unchanged. Check console for errors.</red>"));
                        sender.sendMessage(errorMessage);
                    }
                }
                catch (Exception e) {
                    Component errorMessage = this.miniMessage.deserialize((Object)(NeON.prefix + "<dark_gray> \u00bb <red>Failed to reload NeON configuration. Configuration in memory remains unchanged. Check console for errors.</red>"));
                    sender.sendMessage(errorMessage);
                    this.plugin.getPluginLogger().severe(this.legacyFromMiniMessage(NeON.prefix + "<dark_gray> \u00bb <red>Error reloading configuration: " + e.getMessage() + "</red>"));
                    e.printStackTrace();
                }
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("firework")) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    FireworkUtil.spawnRandomFirework(player.getLocation());
                    this.plugin.getPluginLogger().info(this.legacyFromMiniMessage(NeON.prefix + "<dark_gray> \u00bb <gray>Firework launched by " + player.getName() + ".</gray>"));
                } else {
                    sender.sendMessage(this.legacyFromMiniMessage(NeON.prefix + "<dark_gray> | <red>This command can only be run by a player."));
                }
            } else {
                Component usageMessage = this.miniMessage.deserialize((Object)(NeON.prefix + "<dark_gray> \u00bb <yellow>Usage: /neon reload</yellow>"));
                sender.sendMessage(usageMessage);
                return true;
            }
        }
        return false;
    }

    private String legacyFromMiniMessage(String miniMsg) {
        return LegacyComponentSerializer.legacySection().serialize(this.miniMessage.deserialize((Object)miniMsg));
    }
}

