/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Config;

import dev.xhue.neon.Config.ConfigGenerator;
import dev.xhue.neon.NeON;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final File configFile;
    public FileConfiguration config;
    private final Logger logger = Logger.getLogger("NeON");
    private final File dataFolder;
    private final String fileName;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmmss");

    public ConfigManager(File dataFolder, String fileName) {
        this.dataFolder = dataFolder;
        this.fileName = fileName;
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        this.configFile = new File(dataFolder, fileName);
        if (!this.configFile.exists() || this.configFile.length() == 0L) {
            this.generateConfig(dataFolder, fileName);
        } else {
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        }
        this.reloadConfig();
    }

    private void generateConfig(File dataFolder, String fileName) {
        try {
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            ArrayList<String> header = ConfigManager.getHeader();
            this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
            this.config.options().setHeader(header);
            this.saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ArrayList<String> getHeader() {
        ArrayList<String> header = new ArrayList<String>();
        header.add("  ###################################");
        header.add("         \u2590 \u2584 \u2584\u2584\u2584 .       \u2590 \u2584 ");
        header.add("        \u2022\u2588\u258c\u2590\u2588\u2580\u2584.\u2580\u00b7\u25aa     \u2022\u2588\u258c\u2590\u2588");
        header.add("        \u2590\u2588\u2590\u2590\u258c\u2590\u2580\u2580\u25aa\u2584 \u2584\u2588\u2580\u2584 \u2590\u2588\u2590\u2590\u258c");
        header.add("        \u2588\u2588\u2590\u2588\u258c\u2590\u2588\u2584\u2584\u258c\u2590\u2588\u258c.\u2590\u258c\u2588\u2588\u2590\u2588\u258c");
        header.add("        \u2580\u2580 \u2588\u25aa \u2580\u2580\u2580  \u2580\u2588\u2584\u2580\u25aa\u2580\u2580 \u2588\u25aa by xHue");
        header.add("  ###################################");
        header.add(" ");
        header.add("  Copyright (c) 2025 thelabcorner (xHue) \u2550 https://creativecommons.org/licenses/by-nc-sa/4.0/");
        header.add("  This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.");
        header.add("  You may use, modify and share this work for non-commercial purposes with attribution; all derivatives must use the same license.");
        header.add(" ");
        header.add("  ------");
        header.add("  Thanks for downloading NeON! This is your configuration file.");
        header.add(" ");
        header.add("  Indentation is EXTREMELY IMPORTANT in YAML files. Please ensure you maintain the generated layout.");
        header.add("  If you encounter issues, please first check the server console for errors.");
        header.add("  If that yields no immediate result, try putting your config file through YAML validator, like: https://www.yamllint.com/");
        header.add("  If all else fails, please open an issue on the GitHub repository: https://github.com/thelabcorner/NeON");
        header.add(" ");
        header.add("  ------");
        header.add("  NeON parses every string format value for NeON-specific + PlaceholderAPI placeholders, Legacy (&a-f,0-9) Color-Codes, and MiniMessage adventure formatting.");
        header.add("  This means you can use any of these formats in your strings, even as a mixture, and NeON will parse them for you.");
        header.add("  For example: \"<dark_gray>[&a+&8] <#FF00FF>%essentials_nickname%\"");
        header.add("  ");
        header.add("  NeON is compatible with most vanish plugins, but it's important to note that Essentials vanish is not supported. Use a plugin like SuperVanish or VanishNoPacket for best results.");
        header.add("  ");
        header.add("  NeON is dependant on PlaceholderAPI (https://www.spigotmc.org/resources/placeholderapi.6245/) you must have it installed for the placeholders to work.");
        header.add("  If you are installing PlaceholderAPI for the first time, be sure to download the 'Player', 'Server' and 'Essentials' expansions.");
        header.add("  You can install PlaceholderAPI expansions ingame using the command: /papi ecloud download <expansion>");
        header.add("  See here for a list of available expansions: https://wiki.placeholderapi.com/users/placeholder-list/");
        header.add("  ");
        header.add("  ------");
        header.add("  This file was automatically generated by NeON [v" + NeON.getPlugin().getDescription().getVersion() + "] on " + String.valueOf(new Date()));
        header.add("  ------");
        header.add("  If the generation version/date above is multiple versions behind, consider allowing NeON to regenerate this file.");
        header.add("  When updating NeON, this config file should automatically update with any new keys (preserving your existing config). However, in the event of a key being removed or changed, beware that this may cause issues.");
        header.add("  It's recommended to keep a backup of your config file before updating, just in case!");
        header.add(" ");
        header.add("  If you wish to have NeON generate a new configuration file, simply delete or rename the old file.");
        header.add("  In the event NeON detects an invalid configuration file, it will attempt to rename the old file and generate a new one. YML can be a nightmare!");
        header.add(" ");
        header.add("  ------");
        header.add("  If you want to support the development of NeON, please consider donating to me on Ko-fi: https://ko-fi.com/xhue");
        header.add(" ");
        return header;
    }

    public boolean reloadConfig() {
        if (this.configFile == null) {
            System.out.println("[DEBUG] Cannot reload configuration: file path is not set.");
            return false;
        }
        if (!this.configFile.exists()) {
            System.out.println("[DEBUG] Cannot reload configuration: File not found at expected path: " + this.configFile.getPath() + ". The existing configuration in memory remains unchanged.");
            this.generateConfig(this.dataFolder, this.fileName);
            ConfigGenerator.generateConfig(this, this.logger);
            return false;
        }
        YamlConfiguration newConfig = new YamlConfiguration();
        try {
            newConfig.load(this.configFile);
            this.config = newConfig;
            System.out.println("[DEBUG] Successfully reloaded configuration from " + this.configFile.getPath());
            return true;
        }
        catch (FileNotFoundException e) {
            System.out.println("[ERROR] Config Reload failed: Configuration file disappeared unexpectedly: " + this.configFile.getPath());
            if (!this.configFile.exists() || this.configFile.length() == 0L) {
                this.generateConfig(this.dataFolder, this.fileName);
                ConfigGenerator.generateConfig(this, this.logger);
            }
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            System.out.println("[ERROR] Config Reload failed: Could not read configuration file: " + this.configFile.getPath());
            e.printStackTrace();
            return false;
        }
        catch (InvalidConfigurationException e) {
            System.out.println("[ERROR] Config Reload failed: Invalid configuration format: " + this.configFile.getPath());
            e.printStackTrace();
            this.handleInvalidConfigFile(e);
            return false;
        }
        catch (Exception e) {
            System.out.println("[ERROR] Config Reload failed: An unexpected error occurred while reloading the configuration: " + this.configFile.getPath());
            if (!this.configFile.exists() || this.configFile.length() == 0L) {
                this.generateConfig(this.dataFolder, this.fileName);
                ConfigGenerator.generateConfig(this, this.logger);
            }
            e.printStackTrace();
            return false;
        }
    }

    private void handleInvalidConfigFile(InvalidConfigurationException e) {
        this.logger.log(Level.SEVERE, "Config Reload failed: Invalid configuration format detected in file: " + this.configFile.getPath() + ". Attempting to backup invalid file and restore last known good configuration.", e);
        if (e.getCause() != null) {
            this.logger.log(Level.SEVERE, "Underlying cause: ", e.getCause());
        }
        String timestamp = DATE_FORMAT.format(new Date());
        String invalidFileName = this.configFile.getName() + "." + timestamp + ".INVALID";
        File invalidFile = new File(this.configFile.getParentFile(), invalidFileName);
        try {
            Files.move(this.configFile.toPath(), invalidFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.logger.info("Backed up invalid configuration file to: " + invalidFile.getPath());
        }
        catch (IOException moveEx) {
            this.logger.log(Level.SEVERE, "Failed to rename/backup the invalid configuration file: " + this.configFile.getPath() + " to " + invalidFile.getPath(), moveEx);
            this.logger.warning("Aborting restore of last known good configuration because backup failed.");
            return;
        }
        this.logger.info("Attempting to save the last known good configuration back to: " + this.configFile.getPath());
        this.saveConfig();
    }

    public Object get(String key) {
        this.reloadConfig();
        return this.config.get(key);
    }

    public void set(String key, Object value) {
        this.config.set(key, value);
        this.saveConfig();
    }

    public void addIfAbsent(String key, Object value, String comment) {
        ArrayList<String> commentLines = null;
        if (comment != null && !comment.isBlank()) {
            commentLines = new ArrayList<String>();
            commentLines.addAll(Arrays.asList(comment.split("\r?\n")));
        }
        this.addIfAbsentInternal(key, value, commentLines);
    }

    public void addIfAbsent(String key, Object value, List<String> comment) {
        this.addIfAbsentInternal(key, value, comment);
    }

    private void addIfAbsentInternal(String key, Object value, List<String> commentLines) {
        if (!this.config.contains(key)) {
            this.logger.info("[DEBUG] Key '" + key + "' is absent. Adding value: " + String.valueOf(value));
            HashMap existingComments = new HashMap();
            for (String string : this.config.getKeys(true)) {
                List lines = this.config.getComments(string);
                if (lines == null || lines.isEmpty()) continue;
                existingComments.put(string, new ArrayList(lines));
            }
            this.config.set(key, value);
            if (commentLines != null && !commentLines.isEmpty()) {
                this.logger.info("[DEBUG] Adding comment to key: " + key);
                ArrayList<Object> formattedComment = new ArrayList<Object>();
                formattedComment.add(" ");
                formattedComment.add(" \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                for (String line : commentLines) {
                    formattedComment.add(" " + line);
                }
                formattedComment.add(" \u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                this.config.setComments(key, formattedComment);
            }
            for (Map.Entry entry : existingComments.entrySet()) {
                String existingKey = (String)entry.getKey();
                if (existingKey.equals(key)) continue;
                this.config.setComments(existingKey, (List)entry.getValue());
            }
            this.saveConfig();
        } else {
            this.logger.info("[DEBUG] Key '" + key + "' already exists. Skipping addition.");
        }
    }

    public void remove(String key) {
        this.config.set(key, null);
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

