/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon;

import dev.xhue.neon.NeON;
import dev.xhue.neon.Utils.SerializerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class HologramManager {
    private static final double LINE_SPACING = 0.25;
    private static final Map<UUID, HologramEntry> activeHolograms = new ConcurrentHashMap<UUID, HologramEntry>();
    private static final Map<UUID, HologramEntry> trackingHolograms = new ConcurrentHashMap<UUID, HologramEntry>();
    private static boolean taskStarted = false;
    private static boolean trackingTaskStarted = false;
    private static final NamespacedKey HOLOGRAM_KEY = new NamespacedKey((Plugin)NeON.getPlugin(), "neon_hologram");

    public static List<TextDisplay> spawnHologram(Player player, List<String> lines, float minPitch, float maxPitch, long durationTicks, JavaPlugin plugin, double distance) {
        return HologramManager.spawnStandardHologram(player, lines, durationTicks, plugin, minPitch, maxPitch, distance, false, 0.0, 0);
    }

    public static List<TextDisplay> spawnBouncingHologram(Player player, List<String> lines, float minPitch, float maxPitch, long durationTicks, JavaPlugin plugin, double distance, double amplitude, int frequencyTicks) {
        return HologramManager.spawnStandardHologram(player, lines, durationTicks, plugin, minPitch, maxPitch, distance, true, amplitude, frequencyTicks);
    }

    private static List<TextDisplay> spawnStandardHologram(Player player, List<String> lines, long durationTicks, JavaPlugin plugin, float minPitch, float maxPitch, double distance, boolean bouncing, double amplitude, int frequencyTicks) {
        Location spawnLocation = HologramManager.getHologramBaseLocation(player, distance, lines.size(), minPitch, maxPitch);
        List<TextDisplay> displays = HologramManager.createTextDisplays(lines, spawnLocation);
        UUID id = UUID.randomUUID();
        long spawnTime = System.currentTimeMillis();
        activeHolograms.put(id, new HologramEntry(displays, spawnTime, durationTicks));
        HologramManager.startAutoRemovalTask(plugin);
        if (bouncing) {
            HologramManager.startBouncingTask(player, displays, id, spawnTime, durationTicks, spawnLocation, amplitude, frequencyTicks, plugin);
        }
        return displays;
    }

    public static List<TextDisplay> spawnTrackingHologram(Player player, List<String> lines, float minPitch, float maxPitch, long durationTicks, JavaPlugin plugin, double distance, boolean shouldThrob) {
        HologramManager.removeTrackingHologram(player);
        List<TextDisplay> displays = HologramManager.createTextDisplays(lines, player.getLocation());
        trackingHolograms.put(player.getUniqueId(), new HologramEntry(displays, System.currentTimeMillis(), durationTicks));
        HologramManager.startTrackingTask(plugin, distance, lines.size(), minPitch, maxPitch, shouldThrob);
        return displays;
    }

    public static void removeTrackingHologram(Player player) {
        HologramManager.removeHologramByEntry(trackingHolograms.remove(player.getUniqueId()));
    }

    public static void removeAllTrackingHolograms() {
        trackingHolograms.values().forEach(HologramManager::removeHologramByEntry);
        trackingHolograms.clear();
    }

    public static void removeHologram(List<TextDisplay> displays) {
        displays.forEach(Entity::remove);
        activeHolograms.values().removeIf(entry -> entry.displays.equals(displays));
    }

    public static void removeAllHolograms() {
        activeHolograms.values().forEach(HologramManager::removeHologramByEntry);
        activeHolograms.clear();
    }

    public static void hologramCleanup() {
        for (World world : Bukkit.getWorlds()) {
            for (TextDisplay display : world.getEntitiesByClass(TextDisplay.class)) {
                if (!display.getPersistentDataContainer().has(HOLOGRAM_KEY, PersistentDataType.BOOLEAN)) continue;
                display.remove();
            }
        }
        activeHolograms.clear();
        trackingHolograms.clear();
    }

    private static void startAutoRemovalTask(JavaPlugin plugin) {
        if (taskStarted) {
            return;
        }
        taskStarted = true;
        new BukkitRunnable(){

            public void run() {
                long now = System.currentTimeMillis();
                activeHolograms.entrySet().removeIf(entry -> {
                    HologramEntry hologram = (HologramEntry)entry.getValue();
                    if (hologram.durationTicks > 0L && now - hologram.spawnTime >= hologram.durationTicks * 50L) {
                        HologramManager.removeHologramByEntry(hologram);
                        return true;
                    }
                    return false;
                });
                if (activeHolograms.isEmpty()) {
                    taskStarted = false;
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)plugin, 20L, 20L);
    }

    private static void startTrackingTask(JavaPlugin plugin, final double distance, int linesCount, final float minPitch, final float maxPitch, final boolean throbbing) {
        if (trackingTaskStarted) {
            return;
        }
        trackingTaskStarted = true;
        double lerpFactor = 0.6;
        double amplitude = 0.15;
        int periodTicks = 20;
        new BukkitRunnable(){
            int tick = 0;

            public void run() {
                long now = System.currentTimeMillis();
                double modulatedDistance = distance;
                if (throbbing) {
                    modulatedDistance += Math.sin((double)this.tick / 20.0 * 1.25 * Math.PI) * 0.15;
                }
                double finalModulatedDistance = modulatedDistance;
                trackingHolograms.entrySet().removeIf(entry -> {
                    Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
                    HologramEntry hologram = (HologramEntry)entry.getValue();
                    if (player == null || !player.isOnline() || hologram.durationTicks > 0L && now - hologram.spawnTime >= hologram.durationTicks * 50L) {
                        HologramManager.removeHologramByEntry(hologram);
                        return true;
                    }
                    Location baseLocation = HologramManager.getHologramBaseLocation(player, finalModulatedDistance, hologram.displays.size(), minPitch, maxPitch);
                    double y = baseLocation.getY();
                    for (TextDisplay display : hologram.displays) {
                        Location target = baseLocation.clone();
                        target.setY(y);
                        float clampedPitch = Math.min(target.getPitch(), 0.0f);
                        target.setPitch(clampedPitch);
                        Location current = display.getLocation();
                        Location lerped = current.clone().add(target.clone().subtract(current).multiply(0.6));
                        lerped.setYaw(target.getYaw());
                        lerped.setPitch(clampedPitch);
                        display.teleport(lerped);
                        y -= 0.25;
                    }
                    return false;
                });
                if (trackingHolograms.isEmpty()) {
                    trackingTaskStarted = false;
                    this.cancel();
                }
                ++this.tick;
            }
        }.runTaskTimer((Plugin)plugin, 1L, 1L);
    }

    private static void startBouncingTask(final Player player, final List<TextDisplay> displays, final UUID id, final long spawnTime, final long durationTicks, final Location baseLocation, final double amplitude, final int frequencyTicks, JavaPlugin plugin) {
        new BukkitRunnable(){
            int tick = 0;
            final double baseY = baseLocation.getY();

            public void run() {
                if (!player.isOnline() || !activeHolograms.containsKey(id)) {
                    this.cancel();
                    return;
                }
                long now = System.currentTimeMillis();
                if (durationTicks > 0L && now - spawnTime >= durationTicks * 50L) {
                    HologramManager.removeHologramByEntry(activeHolograms.remove(id));
                    this.cancel();
                    return;
                }
                double offsetY = Math.sin((double)this.tick / (double)frequencyTicks * 2.0 * Math.PI) * amplitude;
                double y = this.baseY + offsetY;
                for (TextDisplay display : displays) {
                    Location target = baseLocation.clone();
                    target.setY(y);
                    display.teleport(target);
                    y -= 0.25;
                }
                ++this.tick;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 1L);
    }

    private static List<TextDisplay> createTextDisplays(List<String> lines, Location baseLocation) {
        ArrayList<TextDisplay> displays = new ArrayList<TextDisplay>();
        World world = baseLocation.getWorld();
        if (world == null) {
            return displays;
        }
        double y = baseLocation.getY() + 0.25 * (double)(lines.size() - 1) / 2.0;
        for (String line : lines) {
            Location lineLoc = baseLocation.clone();
            lineLoc.setY(y);
            TextDisplay display = (TextDisplay)world.spawn(lineLoc, TextDisplay.class, td -> HologramManager.configureTextDisplay(td, line));
            displays.add(display);
            y -= 0.25;
        }
        return displays;
    }

    private static void configureTextDisplay(TextDisplay td, String line) {
        Component component = SerializerUtil.legacyToMiniMessageComponent(line);
        td.text(component);
        td.setBillboard(Display.Billboard.CENTER);
        td.setSeeThrough(true);
        td.setShadowed(true);
        td.setPersistent(true);
        td.setGravity(false);
        td.setLineWidth(1000);
        td.getPersistentDataContainer().set(HOLOGRAM_KEY, PersistentDataType.BOOLEAN, (Object)true);
    }

    private static Location getHologramBaseLocation(Player player, double distance, int linesCount, float minPitch, float maxPitch) {
        Location eyeLoc = player.getEyeLocation().clone();
        float pitch = Math.min(eyeLoc.getPitch(), minPitch);
        pitch = Math.max(pitch, maxPitch);
        float yaw = eyeLoc.getYaw();
        Location directionLoc = new Location(eyeLoc.getWorld(), 0.0, 0.0, 0.0, yaw, pitch);
        Vector direction = directionLoc.getDirection().normalize();
        Location target = eyeLoc.add(direction.multiply(distance));
        target.setY(target.getY() + 0.25 * (double)(linesCount - 1) / 2.0);
        return target;
    }

    private static void removeHologramByEntry(HologramEntry entry) {
        if (entry != null) {
            entry.displays.forEach(Entity::remove);
        }
    }

    private static class HologramEntry {
        final List<TextDisplay> displays;
        final long spawnTime;
        final long durationTicks;

        HologramEntry(List<TextDisplay> displays, long spawnTime, long durationTicks) {
            this.displays = displays;
            this.spawnTime = spawnTime;
            this.durationTicks = durationTicks;
        }
    }
}

