/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Listeners;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;

public class FireworkDamageListener
implements Listener {
    public static final Map<UUID, ExplosionRecord> recentExplosions = new ConcurrentHashMap<UUID, ExplosionRecord>();

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (recentExplosions.isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() != EntityDamageEvent.DamageCause.ENTITY_EXPLOSION) {
            return;
        }
        Location pLoc = player.getLocation();
        String matchedId = null;
        for (Map.Entry<UUID, ExplosionRecord> entry : recentExplosions.entrySet()) {
            double distanceSq;
            ExplosionRecord rec = entry.getValue();
            if (!rec.loc.getWorld().equals((Object)pLoc.getWorld()) || !((distanceSq = rec.loc.distanceSquared(pLoc)) <= 16.0)) continue;
            matchedId = rec.id;
            break;
        }
        if (matchedId != null) {
            event.setCancelled(true);
        }
    }

    public static class ExplosionRecord {
        public final String id;
        public final Location loc;

        public ExplosionRecord(String id, Location loc) {
            this.id = id;
            this.loc = loc;
        }
    }
}

