/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Utils;

import dev.xhue.neon.NeON;
import java.util.Locale;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BossBarUtils {
    public static void handleBossBar(final Player player, Component bossbarComponent, String colorStr, String styleStr, final long durationTicks, final String direction) {
        BossBar.Overlay style;
        BossBar.Color color;
        try {
            color = BossBar.Color.valueOf((String)colorStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            NeON.getPlugin().getLogger().warning("Invalid BossBar color specified: " + colorStr + ". Defaulting to PURPLE.");
            color = BossBar.Color.PURPLE;
        }
        try {
            style = BossBar.Overlay.valueOf((String)styleStr.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            NeON.getPlugin().getLogger().warning("Invalid BossBar style specified: " + styleStr + ". Defaulting to PROGRESS.");
            style = BossBar.Overlay.PROGRESS;
        }
        final BossBar bossBar = BossBar.bossBar((Component)bossbarComponent, (float)1.0f, (BossBar.Color)color, (BossBar.Overlay)style);
        player.showBossBar(bossBar);
        if (durationTicks > 0L) {
            new BukkitRunnable(){
                private long ticksElapsed = 0L;
                private final long totalTicks = durationTicks;

                public void run() {
                    if (this.ticksElapsed >= this.totalTicks) {
                        player.hideBossBar(bossBar);
                        this.cancel();
                        return;
                    }
                    float t = (float)(this.ticksElapsed + 1L) / (float)this.totalTicks;
                    float progress = switch (direction.toUpperCase(Locale.ROOT)) {
                        case "RIGHT_TO_LEFT" -> (float)(this.totalTicks - this.ticksElapsed) / (float)this.totalTicks;
                        case "LEFT_TO_RIGHT" -> t;
                        case "RIGHT_TO_LEFT_CUBIC" -> 1.0f - BossBarUtils.cubicBezier(t, 0.4f, 0.0f, 0.2f, 1.0f);
                        case "LEFT_TO_RIGHT_CUBIC" -> BossBarUtils.cubicBezier(t, 0.4f, 0.0f, 0.2f, 1.0f);
                        case "SOLID" -> 1.0f;
                        default -> (float)(this.totalTicks - this.ticksElapsed) / (float)this.totalTicks;
                    };
                    progress = Math.max(0.0f, Math.min(1.0f, progress));
                    bossBar.progress(progress);
                    ++this.ticksElapsed;
                }
            }.runTaskTimer((Plugin)NeON.getPlugin(), 0L, 1L);
        }
    }

    private static float cubicBezier(float t, float p1, float p2, float p3, float p4) {
        float u = 1.0f - t;
        return u * u * u * 0.0f + 3.0f * u * u * t * p1 + 3.0f * u * t * t * p2 + t * t * t * 1.0f;
    }
}

