/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Utils;

import dev.xhue.neon.Utils.SerializerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CenteringUtil {
    private static final int CENTER_PX = 154;
    private static final Map<Character, Integer> CHAR_WIDTHS = new HashMap<Character, Integer>();
    private static final int DEFAULT_WIDTH = 5;
    private static final Pattern LEGACY_PATTERN;
    private static final Pattern LEGACY_HEX;

    public static String getCenteredMessage(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        String legacy = SerializerUtil.miniMessageToLegacy(message);
        String plain = CenteringUtil.stripFormattingForWidthCalculation(legacy);
        int msgPx = 0;
        for (char c : plain.toCharArray()) {
            msgPx += CHAR_WIDTHS.getOrDefault(Character.valueOf(c), 5).intValue();
        }
        int halfMsg = msgPx / 2;
        int spacesPx = 154 - halfMsg;
        int spaceCount = spacesPx > 0 ? spacesPx / CHAR_WIDTHS.get(Character.valueOf(' ')) : 0;
        return " ".repeat(spaceCount) + message;
    }

    private static String stripFormattingForWidthCalculation(String text) {
        StringBuilder result = new StringBuilder(text.length());
        int tagDepth = 0;
        boolean inEscape = false;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if ((c == '&' || c == '\u00a7') && i + 1 < len) {
                char next = text.charAt(i + 1);
                if ("0123456789abcdefklmnorABCDEFKLMNOR".indexOf(next) >= 0) {
                    ++i;
                    continue;
                }
                if (next == 'x' && i + 13 < len) {
                    boolean isHex = true;
                    for (int j = 0; j < 6; ++j) {
                        if ((text.charAt(i + 2 + j * 2) == '&' || text.charAt(i + 2 + j * 2) == '\u00a7') && "0123456789abcdefABCDEF".indexOf(text.charAt(i + 3 + j * 2)) >= 0) continue;
                        isHex = false;
                        break;
                    }
                    if (isHex) {
                        i += 13;
                        continue;
                    }
                }
            }
            if (inEscape) {
                if (tagDepth == 0) {
                    result.append(c);
                }
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == '<') {
                ++tagDepth;
                continue;
            }
            if (c == '>' && tagDepth > 0) {
                --tagDepth;
                continue;
            }
            if (tagDepth != 0) continue;
            result.append(c);
        }
        return result.toString();
    }

    static {
        "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".chars().forEach(c -> CHAR_WIDTHS.put(Character.valueOf((char)c), 5));
        CHAR_WIDTHS.put(Character.valueOf(' '), 4);
        CHAR_WIDTHS.put(Character.valueOf('!'), 1);
        CHAR_WIDTHS.put(Character.valueOf('\"'), 3);
        CHAR_WIDTHS.put(Character.valueOf('#'), 5);
        CHAR_WIDTHS.put(Character.valueOf('$'), 5);
        CHAR_WIDTHS.put(Character.valueOf('%'), 5);
        CHAR_WIDTHS.put(Character.valueOf('&'), 5);
        CHAR_WIDTHS.put(Character.valueOf('\''), 1);
        CHAR_WIDTHS.put(Character.valueOf('('), 4);
        CHAR_WIDTHS.put(Character.valueOf(')'), 4);
        CHAR_WIDTHS.put(Character.valueOf('*'), 5);
        CHAR_WIDTHS.put(Character.valueOf('+'), 5);
        CHAR_WIDTHS.put(Character.valueOf(','), 1);
        CHAR_WIDTHS.put(Character.valueOf('-'), 5);
        CHAR_WIDTHS.put(Character.valueOf('.'), 1);
        CHAR_WIDTHS.put(Character.valueOf('/'), 5);
        CHAR_WIDTHS.put(Character.valueOf(':'), 1);
        CHAR_WIDTHS.put(Character.valueOf(';'), 1);
        CHAR_WIDTHS.put(Character.valueOf('<'), 4);
        CHAR_WIDTHS.put(Character.valueOf('='), 5);
        CHAR_WIDTHS.put(Character.valueOf('>'), 4);
        CHAR_WIDTHS.put(Character.valueOf('?'), 5);
        CHAR_WIDTHS.put(Character.valueOf('['), 3);
        CHAR_WIDTHS.put(Character.valueOf('\\'), 5);
        CHAR_WIDTHS.put(Character.valueOf(']'), 3);
        CHAR_WIDTHS.put(Character.valueOf('^'), 5);
        CHAR_WIDTHS.put(Character.valueOf('_'), 5);
        CHAR_WIDTHS.put(Character.valueOf('`'), 2);
        CHAR_WIDTHS.put(Character.valueOf('{'), 3);
        CHAR_WIDTHS.put(Character.valueOf('|'), 1);
        CHAR_WIDTHS.put(Character.valueOf('}'), 3);
        CHAR_WIDTHS.put(Character.valueOf('~'), 5);
        LEGACY_PATTERN = Pattern.compile("([&\u00a7])([0-9a-fk-orA-FK-OR])");
        LEGACY_HEX = Pattern.compile("([&\u00a7])x((?:[&\u00a7][0-9a-fA-F]){6})");
    }
}

