/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Utils;

import dev.xhue.neon.Listeners.FireworkDamageListener;
import dev.xhue.neon.NeON;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class FireworkUtil {
    public static final NamespacedKey fireworkKey = new NamespacedKey("neon", "firework_key");

    public static void spawnFirework(Location location, List<Color> colors, List<Color> fadeColors, FireworkEffect.Type type, boolean flicker, boolean trail, int power) {
        Firework firework = (Firework)location.getWorld().spawn(location, Firework.class);
        FireworkMeta meta = firework.getFireworkMeta();
        FireworkEffect effect = FireworkEffect.builder().with(type).withColor(colors).withFade(fadeColors).flicker(flicker).trail(trail).build();
        meta.addEffect(effect);
        meta.setPower(power);
        PersistentDataContainer data = meta.getPersistentDataContainer();
        data.set(fireworkKey, PersistentDataType.STRING, (Object)"true");
        firework.setFireworkMeta(meta);
        UUID recordId = UUID.randomUUID();
        FireworkDamageListener.recentExplosions.put(recordId, new FireworkDamageListener.ExplosionRecord("true", firework.getLocation().clone()));
        Bukkit.getScheduler().runTaskLater((Plugin)NeON.getPlugin(), () -> FireworkDamageListener.recentExplosions.remove(recordId), 60L);
    }

    public static void spawnRandomFirework(Location location) {
        Random random = new Random();
        int numColors = random.nextInt(20) + 1;
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < numColors; ++i) {
            colors.add(Color.fromRGB((int)random.nextInt(256), (int)random.nextInt(256), (int)random.nextInt(256)));
        }
        int numFadeColors = random.nextInt(20) + 1;
        ArrayList<Color> fadeColors = new ArrayList<Color>();
        for (int i = 0; i < numFadeColors; ++i) {
            fadeColors.add(Color.fromRGB((int)random.nextInt(256), (int)random.nextInt(256), (int)random.nextInt(256)));
        }
        FireworkEffect.Type type = FireworkEffect.Type.values()[random.nextInt(FireworkEffect.Type.values().length)];
        boolean flicker = random.nextBoolean();
        boolean trail = random.nextBoolean();
        int power = random.nextInt(1) + 1;
        FireworkUtil.spawnFirework(location, colors, fadeColors, type, flicker, trail, power);
    }

    public static Color hexToColor(String hex) {
        hex = hex.replace("#", "");
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return Color.fromRGB((int)r, (int)g, (int)b);
    }
}

