/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ResourcePackUtils {
    private static final File CACHE_FILE = new File("plugins/NeON/resourcepack_sha1.cache");
    private static final Map<String, String> cache = new HashMap<String, String>();
    private static final String DELIM = "%===%";

    private static void loadCache() {
        if (!CACHE_FILE.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(CACHE_FILE), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                int separatorIndex;
                if (line.trim().isEmpty() || line.startsWith("#") || (separatorIndex = line.indexOf(DELIM)) <= 0) continue;
                String url = line.substring(0, separatorIndex);
                String sha1 = line.substring(separatorIndex + DELIM.length());
                cache.put(url, sha1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void saveCache() {
        try {
            CACHE_FILE.getParentFile().mkdirs();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(CACHE_FILE), StandardCharsets.UTF_8));){
                writer.write("###################################\n");
                writer.write("        \u2590 \u2584 \u2584\u2584\u2584 .       \u2590 \u2584 \n");
                writer.write("       \u2022\u2588\u258c\u2590\u2588\u2580\u2584.\u2580\u00b7\u25aa     \u2022\u2588\u258c\u2590\u2588\n");
                writer.write("       \u2590\u2588\u2590\u2590\u258c\u2590\u2580\u2580\u25aa\u2584 \u2584\u2588\u2580\u2584 \u2590\u2588\u2590\u2590\u258c\n");
                writer.write("       \u2588\u2588\u2590\u2588\u258c\u2590\u2588\u2584\u2584\u258c\u2590\u2588\u258c.\u2590\u258c\u2588\u2588\u2590\u2588\u258c\n");
                writer.write("       \u2580\u2580 \u2588\u25aa \u2580\u2580\u2580  \u2580\u2588\u2584\u2580\u25aa\u2580\u2580 \u2588\u25aa by xHue\n");
                writer.write("###################################\n");
                writer.write("# NeON Resource Pack SHA-1 cache\n");
                writer.write("# This file was auto-generated by NeON on: [" + String.valueOf(new Date()) + "]\n");
                writer.write("# Please do not edit this file manually.\n");
                writer.write("# \n");
                writer.write("# This file contains the SHA-1 hashes of resource packs.\n");
                writer.write("# It is used to verify the integrity of player-downloaded packs.\n");
                writer.write("# \n");
                writer.write("# If you want to clear the pack sha-1 cache, simply delete this file.\n");
                writer.write("# Format: URL%===%SHA1\n");
                writer.write("###################################\n\n");
                for (Map.Entry<String, String> entry : cache.entrySet()) {
                    writer.write(entry.getKey() + DELIM + entry.getValue() + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getSHA1ForPack(String urlString) throws Exception {
        if (cache.containsKey(urlString)) {
            return cache.get(urlString);
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try (InputStream is = new URI(urlString).toURL().openStream();){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
        }
        byte[] hash = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : hash) {
            sb.append(String.format("%02x", b));
        }
        String sha1 = sb.toString();
        cache.put(urlString, sha1);
        ResourcePackUtils.saveCache();
        return sha1;
    }

    static {
        ResourcePackUtils.loadCache();
    }
}

