/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class SerializerUtil {
    private static final Map<Character, String> LEGACY_TO_MINIMESSAGE_MAP = Map.ofEntries(Map.entry(Character.valueOf('0'), "<black>"), Map.entry(Character.valueOf('1'), "<dark_blue>"), Map.entry(Character.valueOf('2'), "<dark_green>"), Map.entry(Character.valueOf('3'), "<dark_aqua>"), Map.entry(Character.valueOf('4'), "<dark_red>"), Map.entry(Character.valueOf('5'), "<dark_purple>"), Map.entry(Character.valueOf('6'), "<gold>"), Map.entry(Character.valueOf('7'), "<gray>"), Map.entry(Character.valueOf('8'), "<dark_gray>"), Map.entry(Character.valueOf('9'), "<blue>"), Map.entry(Character.valueOf('a'), "<green>"), Map.entry(Character.valueOf('b'), "<aqua>"), Map.entry(Character.valueOf('c'), "<red>"), Map.entry(Character.valueOf('d'), "<light_purple>"), Map.entry(Character.valueOf('e'), "<yellow>"), Map.entry(Character.valueOf('f'), "<white>"), Map.entry(Character.valueOf('k'), "<obf>"), Map.entry(Character.valueOf('l'), "<b>"), Map.entry(Character.valueOf('m'), "<st>"), Map.entry(Character.valueOf('n'), "<u>"), Map.entry(Character.valueOf('o'), "<i>"), Map.entry(Character.valueOf('r'), "<reset>"));
    private static final Map<String, Character> MINIMESSAGE_TO_LEGACY_MAP = LEGACY_TO_MINIMESSAGE_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    private static final Pattern LEGACY_SPIGOT_HEX_PATTERN = Pattern.compile("[&\u00a7]x([&\u00a7][0-9a-fA-F]){6}", 2);
    private static final Pattern MINIMESSAGE_HEX_PATTERN = Pattern.compile("<(?:color:)?#([0-9a-fA-F]{6})>", 2);
    private static final Pattern MINIMESSAGE_TAG_PATTERN = Pattern.compile("<(/?[a-zA-Z_]+)>");
    private static final Pattern LEGACY_PATTERN = Pattern.compile("([&\u00a7])([0-9a-fk-orA-FK-OR])");

    public static String legacyToMiniMessage(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder hexProcessed = new StringBuilder();
        Matcher hexMatcher = LEGACY_SPIGOT_HEX_PATTERN.matcher(input);
        while (hexMatcher.find()) {
            String match = hexMatcher.group(0);
            String hex = match.substring(2).replace("&", "").replace("\u00a7", "");
            hexMatcher.appendReplacement(hexProcessed, "<color:#" + hex + ">");
        }
        hexMatcher.appendTail(hexProcessed);
        StringBuilder out = new StringBuilder();
        Matcher m = LEGACY_PATTERN.matcher(hexProcessed.toString());
        while (m.find()) {
            char code = Character.toLowerCase(m.group(2).charAt(0));
            String replacement = LEGACY_TO_MINIMESSAGE_MAP.getOrDefault(Character.valueOf(code), "");
            m.appendReplacement(out, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(out);
        return out.toString();
    }

    public static String miniMessageToLegacy(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        Matcher hexMatcher = MINIMESSAGE_HEX_PATTERN.matcher(input);
        while (hexMatcher.find()) {
            String hex = hexMatcher.group(1).toLowerCase();
            StringBuilder legacyHex = new StringBuilder("&x");
            for (char c : hex.toCharArray()) {
                legacyHex.append('&').append(c);
            }
            hexMatcher.appendReplacement(out, Matcher.quoteReplacement(legacyHex.toString()));
        }
        hexMatcher.appendTail(out);
        String processed = out.toString();
        out = new StringBuilder();
        Matcher tagMatcher = MINIMESSAGE_TAG_PATTERN.matcher(processed);
        while (tagMatcher.find()) {
            String fullTag = tagMatcher.group(0).toLowerCase();
            String tagName = tagMatcher.group(1).toLowerCase();
            Character legacyCode = MINIMESSAGE_TO_LEGACY_MAP.get(fullTag);
            Object replacement = legacyCode != null ? "&" + legacyCode : (tagName.startsWith("/") ? "&r" : "");
            tagMatcher.appendReplacement(out, Matcher.quoteReplacement((String)replacement));
        }
        tagMatcher.appendTail(out);
        return out.toString();
    }

    public static Component legacyToMiniMessageComponent(String input) {
        return MiniMessage.miniMessage().deserialize((Object)SerializerUtil.legacyToMiniMessage(input));
    }
}

