/*
 * Decompiled with CFR 0.152.
 */
package dev.xhue.neon.Utils;

import java.lang.reflect.Field;
import java.util.Locale;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.jetbrains.annotations.NotNull;

public class SoundUtils {
    @NotNull
    public static Sound getSoundOrThrow(@NotNull String key) {
        if (key.startsWith("minecraft:")) {
            key = key.substring("minecraft:".length());
        }
        try {
            NamespacedKey nsk = NamespacedKey.minecraft((String)key.toLowerCase(Locale.ROOT));
            Field field = Registry.class.getDeclaredField("SOUND_EVENT");
            Object registry = field.get(null);
            return (Sound)registry.getClass().getMethod("getOrThrow", NamespacedKey.class).invoke(registry, nsk);
        }
        catch (NoSuchFieldException e) {
            String normalized = key.toUpperCase(Locale.ROOT).replace('.', '_');
            try {
                return (Sound)Sound.class.getMethod("valueOf", String.class).invoke(null, normalized);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Sound.valueOf(String) is not available in this Bukkit version.", ex);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid sound key: " + key, ex);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid sound key: " + key, e);
        }
    }
}

