/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.durability_visibility_options.client;

import com.danrus.durability_visibility_options.client.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_317;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class ArmorHudRender
implements HudRenderCallback {
    public class_310 client = class_310.method_1551();

    public void onHudRender(class_332 drawContext, float v) {
        class_317 renderTickCounter = new class_317(0.0f, 0L, f -> 0.0f);
        this.onHudRender(drawContext, renderTickCounter);
    }

    public void onHudRender(class_332 drawContext, class_317 renderTickCounter) {
        if (!ModConfig.get().showArmorDurabilityHud) {
            return;
        }
        if (!ModConfig.get().showArmorDurabilityHudInCreative) {
            assert (this.client.field_1724 != null);
            if (this.client.field_1724.method_7337()) {
                return;
            }
        }
        class_4587 matrices = drawContext.method_51448();
        class_327 textRenderer = this.client.field_1772;
        matrices.method_22903();
        matrices.method_46416((float)this.calculateRootMatrixPosition().get(0).intValue(), (float)this.calculateRootMatrixPosition().get(1).intValue(), 500.0f);
        float scale = ModConfig.get().armorDurabilityHudScale;
        matrices.method_22905(scale, scale, scale);
        ArmorHudRender.getArmorItems().forEach(itemStack -> {
            if (itemStack.method_7909() == class_1802.field_8162 || this.getDurabilityPercent((class_1799)itemStack) > ModConfig.get().showArmorDurabilityHudFromPercent) {
                return;
            }
            this.drawArmorPieceAndDurability(drawContext, textRenderer, (class_1799)itemStack);
            if (ModConfig.get().armorHudAlignment == ModConfig.ArmorAlignment.VERTICAL) {
                matrices.method_46416(0.0f, (float)ModConfig.get().armorDurabilityHudMirgin, 0.0f);
            } else {
                Object durability = this.getDurabilityText((class_1799)itemStack);
                if (ModConfig.get().showArmorDurabilityHudPercentSymbol) {
                    durability = (String)durability + "%";
                }
                matrices.method_46416((float)(ModConfig.get().armorDurabilityHudMirgin + textRenderer.method_1727((String)durability)), 0.0f, 0.0f);
            }
        });
        matrices.method_22909();
    }

    public static List<class_1799> getArmorItems() {
        assert (class_310.method_1551().field_1724 != null);
        List itemsOriginal = class_310.method_1551().field_1724.method_31548().field_7548.reversed();
        ArrayList<class_1799> items = new ArrayList<class_1799>(List.of());
        for (int i = 0; i < 4; ++i) {
            if (((class_1799)itemsOriginal.get(i)).method_7909() == class_1802.field_8162) continue;
            items.add((class_1799)itemsOriginal.get(i));
        }
        return items;
    }

    private int getDurabilityPercent(class_1799 stack) {
        return (int)((float)(stack.method_7936() - stack.method_7919()) / (float)stack.method_7936() * 100.0f);
    }

    private String getDurabilityText(class_1799 stack) {
        Object durability = String.valueOf(this.getDurabilityPercent(stack));
        if (ModConfig.get().showArmorDurabilityHudPercentSymbol) {
            durability = (String)durability + "%";
        }
        return durability;
    }

    private void drawArmorPieceAndDurability(class_332 drawContext, class_327 textRenderer, class_1799 stack) {
        if (stack.method_7909() == class_1802.field_8162) {
            return;
        }
        String durability = this.getDurabilityText(stack);
        int percentWidth = textRenderer.method_1727(durability);
        int itemWidth = 24;
        int additionalIconHorizontalOffset = 0;
        switch (ModConfig.get().armorHudDisplayStyle) {
            case PERCENT_ICON: {
                if (stack.method_31574(class_1802.field_8833)) {
                    additionalIconHorizontalOffset = -4;
                }
                drawContext.method_51427(stack, itemWidth + additionalIconHorizontalOffset, 0);
                drawContext.method_25303(textRenderer, durability, 0, 4, ModConfig.get().armorDurabilityHudTextColor);
                break;
            }
            case ICON_PERCENT: {
                if (stack.method_31574(class_1802.field_8833)) {
                    additionalIconHorizontalOffset = 4;
                }
                drawContext.method_25303(textRenderer, durability, itemWidth, 4, ModConfig.get().armorDurabilityHudTextColor);
                drawContext.method_51427(stack, percentWidth - itemWidth + 8 + additionalIconHorizontalOffset, 0);
            }
        }
    }

    private List<Integer> calculateRootMatrixPosition() {
        class_327 textRenderer = class_310.method_1551().field_1772;
        Object durability = "100";
        if (ModConfig.get().showArmorDurabilityHudPercentSymbol) {
            durability = (String)durability + "%";
        }
        int textMaxWidth = textRenderer.method_1727((String)durability);
        int iconWidth = 16;
        int width = class_310.method_1551().method_22683().method_4486();
        int height = class_310.method_1551().method_22683().method_4502();
        int x = switch (ModConfig.get().armorHudPositionHorizontal) {
            default -> throw new MatchException(null, null);
            case ModConfig.ArmorPositionHorizontal.LEFT -> this.calculateHorizontalOffset() + iconWidth;
            case ModConfig.ArmorPositionHorizontal.CENTER -> {
                switch (ModConfig.get().armorHudAlignment) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case HORIZONTAL: {
                        yield width / 2 - ArmorHudRender.getArmorItems().size() * (iconWidth + textMaxWidth + ModConfig.get().armorDurabilityHudMirgin - 24) / 2 + this.calculateHorizontalOffset();
                    }
                    case VERTICAL: 
                }
                yield width / 2 + this.calculateHorizontalOffset();
            }
            case ModConfig.ArmorPositionHorizontal.RIGHT -> {
                switch (ModConfig.get().armorHudAlignment) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case HORIZONTAL: {
                        yield width - this.calculateHorizontalOffset() - textMaxWidth * ArmorHudRender.getArmorItems().size() - iconWidth * ArmorHudRender.getArmorItems().size();
                    }
                    case VERTICAL: 
                }
                yield width - this.calculateHorizontalOffset() - textMaxWidth;
            }
        };
        x += (switch (ModConfig.get().armorHudDisplayStyle) {
            default -> throw new MatchException(null, null);
            case ModConfig.ArmorDisplayStyle.ICON_PERCENT -> -22;
            case ModConfig.ArmorDisplayStyle.PERCENT_ICON -> -15;
        });
        int y = switch (ModConfig.get().armorHudPositionVertical) {
            default -> throw new MatchException(null, null);
            case ModConfig.ArmorPositionVertical.TOP -> this.calculateVerticalOffset();
            case ModConfig.ArmorPositionVertical.CENTER -> height / 2 + this.calculateVerticalOffset();
            case ModConfig.ArmorPositionVertical.BOTTOM -> {
                switch (ModConfig.get().armorHudAlignment) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case HORIZONTAL: {
                        yield height + this.calculateVerticalOffset() - 17 - 10;
                    }
                    case VERTICAL: 
                }
                yield height + this.calculateVerticalOffset() - 17 * ArmorHudRender.getArmorItems().size() - 10;
            }
        };
        return List.of(Integer.valueOf(x), Integer.valueOf(y));
    }

    private int calculateHorizontalOffset() {
        return switch (ModConfig.get().armorHudPositionHorizontal) {
            default -> throw new MatchException(null, null);
            case ModConfig.ArmorPositionHorizontal.LEFT, ModConfig.ArmorPositionHorizontal.CENTER -> ModConfig.get().armorDurabilityHudOffsetX;
            case ModConfig.ArmorPositionHorizontal.RIGHT -> -ModConfig.get().armorDurabilityHudOffsetX;
        };
    }

    public static int getHealthRows(class_1657 player) {
        float maxHealth = player.method_6063();
        int absorption = (int)player.method_6067();
        return class_3532.method_15386((float)((maxHealth + (float)absorption) / 20.0f));
    }

    public static boolean isAirBarVisible(class_1657 player) {
        return player.method_5669() < player.method_5748();
    }

    private int calculateVerticalOffset() {
        return switch (ModConfig.get().armorHudPositionVertical) {
            default -> throw new MatchException(null, null);
            case ModConfig.ArmorPositionVertical.TOP, ModConfig.ArmorPositionVertical.CENTER -> ModConfig.get().armorDurabilityHudOffsetY;
            case ModConfig.ArmorPositionVertical.BOTTOM -> {
                if (!$assertionsDisabled && this.client.field_1724 == null) {
                    throw new AssertionError();
                }
                int v1 = switch (ModConfig.get().armorVanillaStatsAdapt) {
                    default -> throw new MatchException(null, null);
                    case ModConfig.ArmorVanillaStatsAdapt.HEARTS -> -(ArmorHudRender.getHealthRows((class_1657)this.client.field_1724) * 10);
                    case ModConfig.ArmorVanillaStatsAdapt.AIR -> -(ArmorHudRender.isAirBarVisible((class_1657)this.client.field_1724) ? 10 : 0);
                    case ModConfig.ArmorVanillaStatsAdapt.NONE -> 0;
                };
                int addY = v1;
                yield -ModConfig.get().armorDurabilityHudOffsetY + addY;
            }
        };
    }
}

