/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.durability_visibility_options.client;

import com.danrus.durability_visibility_options.client.config.DurabilityConfig;
import com.danrus.durability_visibility_options.client.utils.DrawUtils;
import java.awt.Color;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class DurabilityRender {
    public static int interpolateColorHSV(int colorStart, int colorEnd, int t) {
        float h1;
        float ratio = Math.max(0.0f, Math.min(1.0f, (float)t / 100.0f));
        Color start = new Color(colorStart);
        Color end = new Color(colorEnd);
        float[] hsvStart = Color.RGBtoHSB(start.getRed(), start.getGreen(), start.getBlue(), null);
        float[] hsvEnd = Color.RGBtoHSB(end.getRed(), end.getGreen(), end.getBlue(), null);
        float h2 = hsvEnd[0];
        float deltaH = h2 - (h1 = hsvStart[0]);
        if (Math.abs(deltaH) > 0.5f) {
            if (deltaH > 0.0f) {
                h1 += 1.0f;
            } else {
                h2 += 1.0f;
            }
        }
        float h = (h1 + (h2 - h1) * ratio) % 1.0f;
        float s = hsvStart[1] + (hsvEnd[1] - hsvStart[1]) * ratio;
        float v = hsvStart[2] + (hsvEnd[2] - hsvStart[2]) * ratio;
        return Color.HSBtoRGB(h, s, v);
    }

    public static void renderBar(class_332 drawContext, int percents, int itemBarStep, int x, int y) {
        DurabilityRender.renderBar(drawContext, percents, itemBarStep, x, y, DurabilityConfig.fromModConfig());
    }

    public static void renderBar(class_332 drawContext, int percents, int itemBarStep, int x, int y, DurabilityConfig config) {
        if (config.showDurabilityBarFromPercent <= percents || !config.showDurability) {
            return;
        }
        int i = x + 2;
        int j = y + 13;
        if (config.isVertical) {
            i += config.durabilityBarOffsetX - 2;
            j -= config.durabilityBarOffsetY + 11;
            if (config.showDurabilityBarBackground) {
                DrawUtils.fill(drawContext, config, i, j, 2, 13, -16777216);
            }
            if (config.doRgbBar) {
                DrawUtils.drawGradientVerticalBar(drawContext, i + 3, j, 1, 13, itemBarStep);
            } else {
                DrawUtils.fill(drawContext, config, i, j + 13, 1, -itemBarStep, DurabilityRender.interpolateColorHSV(config.durabilityBarColorMin, config.durabilityBarColor, percents));
            }
        } else {
            i += config.durabilityBarOffsetX;
            j -= config.durabilityBarOffsetY;
            if (config.showDurabilityBarBackground) {
                DrawUtils.fill(drawContext, config, i, j, 13, 2, -16777216);
            }
            if (config.doRgbBar) {
                DrawUtils.drawGradientHorizontalBar(drawContext, i, j, 13, 1, itemBarStep);
            } else {
                DrawUtils.fill(drawContext, config, i + 13, j, -itemBarStep, 1, DurabilityRender.interpolateColorHSV(config.durabilityBarColorMin, config.durabilityBarColor, percents));
            }
        }
    }

    public static void renderPercents(class_332 drawContext, int percents, int x, int y) {
        DurabilityRender.renderPercents(drawContext, percents, x, y, DurabilityConfig.fromModConfig());
    }

    public static void renderPercents(class_332 drawContext, int percents, int x, int y, DurabilityConfig config) {
        if (config.showDurabilityPercent && config.showDurabilityPercentsFromPercent >= percents) {
            Object durability = String.valueOf(percents);
            if (config.showPercentSymbol) {
                durability = (String)durability + "%";
            }
            drawContext.method_51448().method_22903();
            float targetX = x + 9 + config.durabilityPercentOffsetX;
            float targetY = y + 11 - config.durabilityPercentOffsetY;
            drawContext.method_51448().method_46416(targetX, targetY, 200.0f);
            float scale = config.durabilityPercentScale;
            drawContext.method_51448().method_22905(scale, scale, 1.0f);
            drawContext.method_25300(class_310.method_1551().field_1772, (String)durability, 0, 0, DurabilityRender.interpolateColorHSV(config.durabilityPercentColorMin, config.durabilityPercentColor, percents));
            drawContext.method_51448().method_22909();
        }
    }
}

