/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.durability_visibility_options.client.config;

import com.danrus.durability_visibility_options.client.config.ModConfig;

public class DurabilityConfig {
    public boolean showDurability = true;
    public boolean isVertical = false;
    public boolean showDurabilityBarUnderItem = false;
    public boolean showDurabilityBarBackground = true;
    public int showDurabilityBarFromPercent = 99;
    public int durabilityBarOffsetX = 0;
    public int durabilityBarOffsetY = 0;
    public int durabilityBarColor = 65280;
    public int durabilityBarColorMin = 0xFF0000;
    public boolean showDurabilityPercent = false;
    public boolean showPercentSymbol = true;
    public int durabilityPercentOffsetX = 0;
    public int durabilityPercentOffsetY = 0;
    public int showDurabilityPercentsFromPercent = 99;
    public float durabilityPercentScale = 0.5f;
    public int durabilityPercentColor = 0xFFFFFF;
    public int durabilityPercentColorMin = 0xFFFFFF;
    public boolean doRgbBar = false;

    public static Builder builder() {
        return new Builder();
    }

    public static DurabilityConfig fromModConfig() {
        return DurabilityConfig.builder().fromModConfig().build();
    }

    public static final class Builder {
        private final DurabilityConfig config = new DurabilityConfig();

        public Builder fromModConfig() {
            ModConfig modConfig = ModConfig.get();
            return this.setShowDurability(modConfig.showDurability).setVertical(modConfig.isVertical).setShowDurabilityBarUnderItem(modConfig.showDurabilityBarUnderItem).setShowDurabilityBarBackground(modConfig.showDurabilityBarBackground).setShowDurabilityBarFromPercent(modConfig.showDurabilityBarFromPercent).setDurabilityBarOffsetX(modConfig.durabilityBarOffsetX).setDurabilityBarOffsetY(modConfig.durabilityBarOffsetY).setDurabilityBarColor(modConfig.durabilityBarColor).setDurabilityBarColorMin(modConfig.durabilityBarColorMin).setShowDurabilityPercent(modConfig.showDurabilityPercent).setShowPercentSymbol(modConfig.showPercentSymbol).setDurabilityPercentOffsetX(modConfig.durabilityPercentOffsetX).setDurabilityPercentOffsetY(modConfig.durabilityPercentOffsetY).setShowDurabilityPercentsFromPercent(modConfig.showDurabilityPercentsFromPercent).setDurabilityPercentScale(modConfig.durabilityPercentScale).setDurabilityPercentColor(modConfig.durabilityPercentColor).setDurabilityPercentColorMin(modConfig.durabilityPercentColorMin).setDoRgbBar(modConfig.doRgbBar);
        }

        public Builder setShowDurability(boolean value) {
            this.config.showDurability = value;
            return this;
        }

        public Builder setVertical(boolean value) {
            this.config.isVertical = value;
            return this;
        }

        public Builder setShowDurabilityBarUnderItem(boolean value) {
            this.config.showDurabilityBarUnderItem = value;
            return this;
        }

        public Builder setShowDurabilityBarBackground(boolean value) {
            this.config.showDurabilityBarBackground = value;
            return this;
        }

        public Builder setShowDurabilityBarFromPercent(int value) {
            this.config.showDurabilityBarFromPercent = value;
            return this;
        }

        public Builder setDurabilityBarOffsetX(int value) {
            this.config.durabilityBarOffsetX = value;
            return this;
        }

        public Builder setDurabilityBarOffsetY(int value) {
            this.config.durabilityBarOffsetY = value;
            return this;
        }

        public Builder setDurabilityBarColor(int value) {
            this.config.durabilityBarColor = value;
            return this;
        }

        public Builder setDurabilityBarColorMin(int value) {
            this.config.durabilityBarColorMin = value;
            return this;
        }

        public Builder setShowDurabilityPercent(boolean value) {
            this.config.showDurabilityPercent = value;
            return this;
        }

        public Builder setShowPercentSymbol(boolean value) {
            this.config.showPercentSymbol = value;
            return this;
        }

        public Builder setDurabilityPercentOffsetX(int value) {
            this.config.durabilityPercentOffsetX = value;
            return this;
        }

        public Builder setDurabilityPercentOffsetY(int value) {
            this.config.durabilityPercentOffsetY = value;
            return this;
        }

        public Builder setShowDurabilityPercentsFromPercent(int value) {
            this.config.showDurabilityPercentsFromPercent = value;
            return this;
        }

        public Builder setDurabilityPercentScale(float value) {
            this.config.durabilityPercentScale = value;
            return this;
        }

        public Builder setDurabilityPercentColor(int value) {
            this.config.durabilityPercentColor = value;
            return this;
        }

        public Builder setDurabilityPercentColorMin(int value) {
            this.config.durabilityPercentColorMin = value;
            return this;
        }

        public Builder setDoRgbBar(boolean value) {
            this.config.doRgbBar = value;
            return this;
        }

        public DurabilityConfig build() {
            return this.config;
        }
    }
}

