/*
 * Decompiled with CFR 0.152.
 */
package com.danrus.durability_visibility_options.client.config.presets;

import com.danrus.durability_visibility_options.client.config.DurabilityConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigPresets {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PRESETS_DIR_NAME = "durability_visibility_options_presets";
    private static Path CONFIG_DIR;
    public static Path PRESETS_DIR;
    public static final List<DurabilityConfig> DEFAULT_CONFIGS;

    public static void initialize() {
        CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
        PRESETS_DIR = CONFIG_DIR.resolve(PRESETS_DIR_NAME);
        try {
            Files.createDirectories(PRESETS_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create config presets directory: " + String.valueOf(PRESETS_DIR) + " - " + e.getMessage());
        }
    }

    private static Path getPresetsDirectory() {
        if (PRESETS_DIR == null) {
            ConfigPresets.initialize();
        }
        return PRESETS_DIR;
    }

    public static boolean saveCustom(DurabilityConfig config) {
        boolean bl;
        if (config.name == null || config.name.trim().isEmpty()) {
            System.err.println("DurabilityConfig name cannot be null or empty for saving.");
            return false;
        }
        String fileName = config.name.trim().replaceAll("[^\\p{L}\\p{N}-_\\.]", "_") + ".json";
        Path filePath = ConfigPresets.getPresetsDirectory().resolve(fileName);
        config.key = fileName.replace(".json", "");
        FileWriter writer = new FileWriter(filePath.toFile());
        try {
            GSON.toJson((Object)config, (Appendable)writer);
            System.out.println("DurabilityConfig saved to: " + String.valueOf(filePath));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)writer).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Failed to save DurabilityConfig to " + String.valueOf(filePath) + ": " + e.getMessage());
                e.printStackTrace();
                return false;
            }
        }
        ((Writer)writer).close();
        return bl;
    }

    public static DurabilityConfig loadCustom(String key) {
        DurabilityConfig durabilityConfig;
        if (key == null || key.trim().isEmpty()) {
            System.err.println("Config key cannot be null or empty for loading.");
            return null;
        }
        String fileName = key.trim() + ".json";
        Path filePath = ConfigPresets.getPresetsDirectory().resolve(fileName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            System.out.println("DurabilityConfig file not found: " + String.valueOf(filePath));
            return null;
        }
        FileReader reader = new FileReader(filePath.toFile());
        try {
            DurabilityConfig config = (DurabilityConfig)GSON.fromJson((Reader)reader, DurabilityConfig.class);
            if (config != null) {
                config.key = key;
            }
            System.out.println("DurabilityConfig loaded from: " + String.valueOf(filePath));
            durabilityConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println("Failed to load DurabilityConfig from " + String.valueOf(filePath) + ": " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            catch (JsonSyntaxException e) {
                System.err.println("Failed to parse DurabilityConfig JSON from " + String.valueOf(filePath) + ": " + e.getMessage());
                e.printStackTrace();
                return null;
            }
        }
        ((Reader)reader).close();
        return durabilityConfig;
    }

    public static List<String> getAllPresetKeys() {
        List<String> list;
        block9: {
            Path presetsDir = ConfigPresets.getPresetsDirectory();
            if (!Files.exists(presetsDir, new LinkOption[0]) || !Files.isDirectory(presetsDir, new LinkOption[0])) {
                System.out.println("Presets directory does not exist or is not a directory: " + String.valueOf(presetsDir));
                return List.of();
            }
            Stream<Path> paths = Files.list(presetsDir);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".json")).map(path -> {
                    String fileName = path.getFileName().toString();
                    return fileName.substring(0, fileName.length() - ".json".length());
                }).collect(Collectors.toList());
                if (paths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    System.err.println("Failed to list preset files in " + String.valueOf(presetsDir) + ": " + e.getMessage());
                    e.printStackTrace();
                    return List.of();
                }
            }
            paths.close();
        }
        return list;
    }

    public static void openPresetsFolderInExplorer() {
        Path presetsDir = ConfigPresets.getPresetsDirectory();
    }

    static {
        DEFAULT_CONFIGS = List.of(DurabilityConfig.builder().setKey("only_percents").setShowDurability(false).setShowDurabilityPercent(true).build(), DurabilityConfig.builder().setKey("vertical_bar_plus_percents").setVertical(true).setShowDurabilityPercent(true).setDurabilityPercentOffsetX(4).build(), DurabilityConfig.builder().setKey("low_durability_alert").setShowDurability(false).setShowDurabilityPercent(true).setShowDurabilityPercentsFromPercent(25).setDurabilityPercentOffsetY(4).setDurabilityPercentColor(0xFF0000).setDurabilityPercentColorMin(0xFF0000).build(), DurabilityConfig.builder().setKey("uwu").setDurabilityBarColor(14838015).setDurabilityBarColorMin(0xFF9D9D).build(), DurabilityConfig.builder().setKey("duraview").setShowDurability(false).setShowDurabilityPercent(true).setDurabilityPercentOffsetX(3).setDurabilityPercentColor(65280).setDurabilityPercentColorMin(0xFF0000).build());
    }
}

