/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.api.client;

import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.api.Event;
import dev.tr7zw.itemswapper.api.EventFactory;
import dev.tr7zw.itemswapper.api.client.ContainerProvider;
import dev.tr7zw.itemswapper.api.client.ItemProvider;
import dev.tr7zw.itemswapper.api.client.NameProvider;
import java.util.concurrent.atomic.AtomicBoolean;

public class ItemSwapperClientAPI {
    private static final ItemSwapperClientAPI INSTANCE = new ItemSwapperClientAPI();
    private final ItemSwapperSharedMod modInstance = ItemSwapperSharedMod.instance;
    public final Event<OnSwap> prepareItemSwapEvent = EventFactory.createEvent();
    public final Event<SwapSent> itemSwapSentEvent = EventFactory.createEvent();

    private ItemSwapperClientAPI() {
    }

    public static ItemSwapperClientAPI getInstance() {
        return INSTANCE;
    }

    public void registerEarlyItemProvider(ItemProvider provider) {
        this.modInstance.getClientProviderManager().registerEarlyItemProvider(provider);
    }

    public void registerLateItemProvider(ItemProvider provider) {
        this.modInstance.getClientProviderManager().registerLateItemProvider(provider);
    }

    public void registerContainerProvider(ContainerProvider provider) {
        this.modInstance.getClientProviderManager().registerContainerProvider(provider);
    }

    public void registerNameProvider(NameProvider provider) {
        this.modInstance.getClientProviderManager().registerNameProvider(provider);
    }

    public record SwapSent(AvailableSlot slot) {
    }

    public record OnSwap(AvailableSlot slot, AtomicBoolean canceled) {
    }
}

