/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.compat;

import dev.tr7zw.itemswapper.ItemSwapperBase;
import dev.tr7zw.itemswapper.config.Config;
import dev.tr7zw.itemswapper.config.ConfigManager;

public class ViveCraftSupport {
    private static final ViveCraftSupport INSTANCE = new ViveCraftSupport();
    private final ConfigManager configManager = ConfigManager.getInstance();
    private boolean isAvailable = false;

    private ViveCraftSupport() {
    }

    public void init() {
        Config config = this.configManager.getConfig();
        this.isAvailable = true;
        if (!config.vivecraftCompat) {
            ItemSwapperBase.LOGGER.info("ViveCraft support is explicitly disabled!");
            return;
        }
        ItemSwapperBase.LOGGER.info("ViveCraft support enabled!");
    }

    public static ViveCraftSupport getInstance() {
        return INSTANCE;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isActive() {
        return this.isAvailable() && ConfigManager.getInstance().getConfig().vivecraftCompat;
    }
}

