/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import dev.tr7zw.itemswapper.ItemSwapperMod;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.api.client.ItemSwapperClientAPI;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.overlay.SwitchItemOverlay;
import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.ItemGridWidget;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.itemswapper.util.RenderHelper;
import dev.tr7zw.transition.mc.InventoryUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;

public abstract class InventoryAbstractWidget
extends ItemGridWidget {
    protected InventoryAbstractWidget(int x, int y) {
        super(x, y);
    }

    protected abstract List<AvailableSlot> getItem(int var1);

    @Override
    protected void renderSlot(RenderContext graphics, int x, int y, List<Runnable> itemRenderList, GuiSlot guiSlot, boolean overwrideAvailable) {
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty()) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, ((AvailableSlot)slots.get(0)).item(), 1, RenderHelper.SlotEffect.NONE, ((AvailableSlot)slots.get(0)).amount().get()));
        }
    }

    @Override
    public void onSecondaryClick(SwitchItemOverlay overlay, GuiSlot guiSlot, int xOffset, int yOffset) {
        AvailableSlot slot;
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty() && !(slot = slots.get(0)).item().method_7960()) {
            overlay.openPage(ItemSwapperMod.instance.getItemGroupManager().getNextPage(null, new ItemEntry(slot.item().method_7909(), null), guiSlot.id() + 9));
        }
    }

    @Override
    public boolean onPrimaryClick(SwitchItemOverlay overlay, GuiSlot guiSlot, int xOffset, int yOffset) {
        AvailableSlot slot;
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty() && (slot = slots.get(0)).inventory() == -1) {
            ItemSwapperClientAPI.OnSwap event = this.clientAPI.prepareItemSwapEvent.callEvent(new ItemSwapperClientAPI.OnSwap(slot, new AtomicBoolean()));
            if (event.canceled().get()) {
                return true;
            }
            int hudSlot = ItemUtil.inventorySlotToHudSlot(slot.slot());
            this.minecraft.field_1761.method_2906(this.minecraft.field_1724.field_7498.field_7763, hudSlot, InventoryUtil.getSelectedId((class_1661)this.minecraft.field_1724.method_31548()), class_1713.field_7791, (class_1657)this.minecraft.field_1724);
            this.clientAPI.itemSwapSentEvent.callEvent(new ItemSwapperClientAPI.SwapSent(slot));
            ItemSwapperSharedMod.instance.setLastItem(slot.item().method_7909());
            ItemSwapperSharedMod.instance.setLastPage(overlay.getLastPages().get(overlay.getLastPages().size() - 1));
            return false;
        }
        return true;
    }

    @Override
    public void renderSelectedSlotName(GuiSlot selected, int yOffset, int maxWidth, boolean overwrideAvailable, RenderContext graphics) {
        List<AvailableSlot> availableSlots = this.getItem(selected.id());
        if (!availableSlots.isEmpty() && !overwrideAvailable) {
            RenderHelper.renderSelectedItemName(ItemUtil.getDisplayname(availableSlots.get(0).item()), availableSlots.get(0).item(), false, yOffset, maxWidth, graphics);
        }
    }
}

