/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.server;

import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.packets.RefillItemPayload;
import dev.tr7zw.itemswapper.packets.SwapItemPayload;
import dev.tr7zw.itemswapper.util.ServerUtil;
import dev.tr7zw.itemswapper.util.ShulkerHelper;
import dev.tr7zw.transition.mc.InventoryUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerItemHandler {
    private static final Logger network_logger = LogManager.getLogger((String)"ItemSwapper-Network");
    private static final ConfigManager configManager = ConfigManager.getInstance();

    public void swapItem(class_3222 player, SwapItemPayload payload) {
        if (ServerItemHandler.configManager.getConfig().disableShulkers) {
            return;
        }
        try {
            if (ShulkerHelper.isShulker(InventoryUtil.getSelected((class_1661)player.method_31548()).method_7909())) {
                return;
            }
            class_1799 shulker = player.method_31548().method_5438(payload.inventorySlot());
            class_2371<class_1799> content = ShulkerHelper.getItems(shulker);
            if (content != null) {
                class_1799 tmp = (class_1799)content.get(payload.slot());
                content.set(payload.slot(), (Object)InventoryUtil.getSelected((class_1661)player.method_31548()));
                player.method_31548().method_5447(InventoryUtil.getSelectedId((class_1661)player.method_31548()), tmp);
                ShulkerHelper.setItem(shulker, content);
            }
        }
        catch (Throwable th) {
            network_logger.error("Error handeling network packet!", th);
        }
    }

    public void refillSlot(class_3222 player, RefillItemPayload payload) {
        if (ServerItemHandler.configManager.getConfig().disableShulkers) {
            return;
        }
        try {
            class_1799 target = player.method_31548().method_5438(payload.slot());
            if (target == null || target.method_7960()) {
                return;
            }
            int space = target.method_7914() - target.method_7947();
            if (space <= 0) {
                return;
            }
            for (int i = 0; i < InventoryUtil.getNonEquipmentItems((class_1661)player.method_31548()).size(); ++i) {
                class_1799 shulker = (class_1799)InventoryUtil.getNonEquipmentItems((class_1661)player.method_31548()).get(i);
                class_2371<class_1799> content = ShulkerHelper.getItems(shulker);
                if (content == null) continue;
                boolean boxChanged = false;
                for (int entry = 0; entry < content.size(); ++entry) {
                    class_1799 boxItem = (class_1799)content.get(entry);
                    if (!ServerUtil.isSame(boxItem, target)) continue;
                    int amount = Math.min(space, boxItem.method_7947());
                    target.method_7939(target.method_7947() + amount);
                    boxItem.method_7939(boxItem.method_7947() - amount);
                    boxChanged = true;
                    if ((space -= amount) <= 0) break;
                }
                if (!boxChanged) continue;
                ShulkerHelper.setItem(shulker, content);
            }
        }
        catch (Throwable th) {
            network_logger.error("Error handeling network packet!", th);
        }
    }
}

