/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.itemswapper.manager.itemgroups.Icon;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public final class RenderHelper {
    private static final class_310 minecraft = class_310.method_1551();
    public static final int LAYERS_BACKGROUND = 0;
    public static final int LAYERS_SELECTION = 300;
    public static final int LAYERS_ITEM = 2000;
    public static final int LAYERS_TOOLTIP = 3000;
    public static final int LAYERS_CURSOR = 4000;

    private RenderHelper() {
    }

    public static void renderUnavailableItem(RenderContext graphics, class_1309 livingEntity, class_1799 itemStack, int i, int j, int k, SlotEffect effect) {
        if (itemStack.method_7960()) {
            return;
        }
        int l = i;
        int m = j;
        int color = 0;
        if (effect == SlotEffect.RED) {
            color = 0x30FF0000;
        } else if (effect == SlotEffect.GRAY) {
            color = -1879048192;
        }
        graphics.fill(l - 1, m - 1, l + 17, m + 17, color);
        graphics.renderFakeItem(itemStack, l, m);
        if (k == 0) {
            graphics.renderItemDecorations(RenderHelper.minecraft.field_1772, itemStack, l, m);
        }
    }

    public static void renderGuiItemCount(class_327 font, String text, int i, int j, int color, RenderContext graphics) {
        RenderHelper.renderGuiItemText(font, text, i + 19 - 2 - font.method_1727(text), j + 6 + 3, color, graphics);
    }

    public static void renderGuiItemName(class_327 font, String text, int i, int j, int color, RenderContext graphics) {
        RenderHelper.renderGuiItemText(font, text, i - font.method_1727(text) / 2, j, color, graphics);
    }

    public static void renderGuiItemName(class_327 font, List<class_5481> text, int x, int y, int color, RenderContext graphics) {
        RenderHelper.renderGuiItemText(font, text, x, y, color, graphics);
    }

    public static void renderGuiItemText(class_327 font, List<class_5481> text, int x, int y, int color, RenderContext graphics) {
        class_4587 poseStack = new class_4587();
        int line = 0;
        while (line < text.size()) {
            poseStack.method_22904(0.0, 0.0, 3000.0);
            int fline = line++;
            graphics.drawSpecial(bufferSource -> {
                class_5481 class_54812 = (class_5481)text.get(fline);
                float f = x - font.method_30880((class_5481)text.get(fline)) / 2;
                Objects.requireNonNull(font);
                font.method_22942(class_54812, f, (float)(y - 9 * (text.size() - fline)), color, true, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            });
        }
    }

    public static void renderGuiItemText(class_327 font, String text, int i, int j, int color, RenderContext graphics) {
        class_4587 poseStack = new class_4587();
        String string2 = text;
        poseStack.method_22904(0.0, 0.0, 3000.0);
        graphics.drawSpecial(bufferSource -> font.method_27521(string2, (float)i, (float)j, color, true, poseStack.method_23760().method_23761(), bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0));
    }

    public static void renderSlot(RenderContext graphics, int x, int y, class_1657 arg, class_1799 arg2, int k, SlotEffect effect, int count) {
        if (!arg2.method_7960()) {
            int color;
            graphics.getPose().method_22903();
            graphics.getPose().method_46416(0.0f, 0.0f, 200.0f);
            class_1799 copy = arg2.method_7972();
            copy.method_7939(1);
            if (effect != SlotEffect.NONE) {
                RenderHelper.renderUnavailableItem(graphics, (class_1309)arg, copy, x, y, k, effect);
                graphics.getPose().method_22909();
                return;
            }
            graphics.renderItem(arg, copy, x, y, k);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            graphics.renderItemDecorations(RenderHelper.minecraft.field_1772, copy, x, y);
            int n = color = count > 64 ? 0xFFFF00 : 0xFFFFFF;
            if (count > 1) {
                RenderHelper.renderGuiItemCount(RenderHelper.minecraft.field_1772, "" + Math.min(64, count), x, y, color, graphics);
            }
            graphics.getPose().method_22909();
        }
    }

    public static class_2561 getName(ItemEntry entry) {
        if (entry == null) {
            return null;
        }
        if (entry.getNameOverwride() != null) {
            return entry.getNameOverwride();
        }
        return ItemUtil.getDisplayname(entry.getItem().method_7854());
    }

    public static class_2561 getName(Icon.ItemIcon entry) {
        if (entry == null) {
            return null;
        }
        if (entry.nameOverwrite() != null) {
            return entry.nameOverwrite();
        }
        return entry.item().method_7964();
    }

    public static class_2561 getName(Icon.LinkIcon entry) {
        if (entry == null) {
            return null;
        }
        if (entry.nameOverwrite() != null) {
            return entry.nameOverwrite();
        }
        return entry.item().method_7964();
    }

    public static void renderSelectedItemName(class_2561 comp, class_1799 arg2, boolean grayOut, int offsetY, int maxWidth, RenderContext graphics) {
        int originX = minecraft.method_22683().method_4486() / 2;
        int originY = minecraft.method_22683().method_4502() / 2;
        class_5251 textColor = arg2.method_7964().method_10866().method_10973();
        class_124 rarityColor = arg2.method_7932().method_58413();
        int color = 0xFFFFFF;
        if (grayOut) {
            color = 0xAAAAAA;
        } else if (textColor != null) {
            color = textColor.method_27716();
        } else if (rarityColor != null && rarityColor.method_532() != null) {
            color = rarityColor.method_532();
        }
        RenderHelper.renderGuiItemName(RenderHelper.minecraft.field_1772, RenderHelper.minecraft.field_1772.method_1728((class_5348)comp, maxWidth), originX, originY - offsetY / 2 - 12, color, graphics);
    }

    public static void renderSelectedEntryName(class_2561 comp, boolean grayOut, int offsetY, int maxWidth, RenderContext graphics) {
        int originX = minecraft.method_22683().method_4486() / 2;
        int originY = minecraft.method_22683().method_4502() / 2;
        int color = 0xFFFFFF;
        if (grayOut) {
            color = 0xAAAAAA;
        }
        RenderHelper.renderGuiItemName(RenderHelper.minecraft.field_1772, RenderHelper.minecraft.field_1772.method_1728((class_5348)comp, maxWidth), originX, originY - offsetY / 2 - 12, color, graphics);
    }

    public static enum SlotEffect {
        NONE,
        RED,
        GRAY;

    }
}

