/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.manager;

import dev.tr7zw.itemswapper.accessor.SpriteContentsAccess;
import dev.tr7zw.itemswapper.util.ColorUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class BlockTextureManager {
    private final Map<class_2248, ColorUtil.UnpackedColor[]> colorMap = new HashMap<class_2248, ColorUtil.UnpackedColor[]>();
    private final Set<String> bannedKeywords = new HashSet<String>(Arrays.asList("_slab", "_stairs", "_fence", "_gate", "_carpet", "_wall", "piston", "cake", "repeater", "comparator", "waxed_", "infested_"));

    public void init() {
        this.colorMap.clear();
        class_7923.field_41175.method_29722().forEach(e -> {
            class_2680 state = (class_2680)((class_2248)e.getValue()).method_9595().method_11664();
            class_1058 sprite = class_310.method_1551().method_1541().method_3349(state).method_4711();
            if (state.method_26225() && !state.method_31709()) {
                for (String key : this.bannedKeywords) {
                    if (!((class_5321)e.getKey()).method_29177().toString().contains(key)) continue;
                    return;
                }
                class_1011 img = ((SpriteContentsAccess)sprite.method_45851()).getOriginalImage();
                this.colorMap.put((class_2248)e.getValue(), ColorUtil.primaryColorDetection(img.method_48463(), ColorUtil.ColorFormat.RGBA, 0.3f));
            }
        });
    }

    public ColorUtil.UnpackedColor[] getColor(class_2248 block) {
        if (this.colorMap.isEmpty()) {
            this.init();
        }
        return this.colorMap.get(block);
    }

    public List<class_2248> getBlocksByAverageColor(ColorUtil.UnpackedColor[] targetAverageColor) {
        if (this.colorMap.isEmpty()) {
            this.init();
        }
        ArrayList<Map.Entry> blockDistances = new ArrayList<Map.Entry>();
        for (class_2248 block : this.colorMap.keySet()) {
            ColorUtil.UnpackedColor[] blockColor = this.colorMap.get(block);
            double dist = Double.MAX_VALUE;
            for (ColorUtil.UnpackedColor target : targetAverageColor) {
                for (ColorUtil.UnpackedColor check : blockColor) {
                    dist = Math.min(dist, ColorUtil.colorDistance(target, check));
                }
            }
            blockDistances.add(new AbstractMap.SimpleEntry<class_2248, Double>(block, dist));
        }
        blockDistances.sort(Comparator.comparingDouble(Map.Entry::getValue));
        ArrayList<class_2248> sortedBlocks = new ArrayList<class_2248>();
        for (Map.Entry entry : blockDistances) {
            sortedBlocks.add((class_2248)entry.getKey());
        }
        return sortedBlocks;
    }
}

