/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.client.ItemSwapperClientAPI;
import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.manager.ClientProviderManager;
import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.GuiWidget;
import dev.tr7zw.itemswapper.overlay.logic.WidgetArea;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_918;

public abstract class ItemGridWidget
implements GuiWidget {
    protected final class_310 minecraft = class_310.method_1551();
    protected final ClientProviderManager providerManager = ItemSwapperSharedMod.instance.getClientProviderManager();
    protected final class_918 itemRenderer = class_310.method_1551().method_1480();
    protected final ConfigManager configManager = ConfigManager.getInstance();
    protected final ItemSwapperClientAPI clientAPI = ItemSwapperClientAPI.getInstance();
    protected final List<GuiSlot> slots = new ArrayList<GuiSlot>();
    protected WidgetArea widgetArea = new WidgetArea(0, 0, 128, 128, null, 0, 0);

    protected ItemGridWidget(int x, int y) {
        this.widgetArea.setX(x);
        this.widgetArea.setY(y);
    }

    @Override
    public void render(class_437 parent, RenderContext graphics, int originX, int originY, boolean overwrideAvailable) {
        WidgetUtil.renderBackground(this.getWidgetArea(), graphics, originX += this.getWidgetArea().getX(), originY += this.getWidgetArea().getY());
        ArrayList<Runnable> itemRenderList = new ArrayList<Runnable>();
        ArrayList<Runnable> lateRenderList = new ArrayList<Runnable>();
        for (int i = 0; i < this.getSlots().size(); ++i) {
            this.renderSelection(parent, graphics, i, originX + this.getSlots().get(i).x(), originY + this.getSlots().get(i).y(), itemRenderList, lateRenderList, overwrideAvailable);
        }
        RenderSystem.enableBlend();
        itemRenderList.forEach(Runnable::run);
        RenderSystem.enableBlend();
        lateRenderList.forEach(Runnable::run);
    }

    private void renderSelection(class_437 parent, RenderContext graphics, int listId, int x, int y, List<Runnable> itemRenderList, List<Runnable> lateRenderList, boolean overwrideAvailable) {
        GuiSlot guiSlot;
        if (this.getWidgetArea().getBackgroundTexture() == null) {
            graphics.blit(WidgetUtil.WIDGETS_LOCATION, x, y, 24.0f, 22.0f, 29, 24, 256, 256);
        }
        if ((guiSlot = this.getSlots().get(listId)).selected().get()) {
            itemRenderList = lateRenderList;
            graphics.getPose().method_46416(0.0f, 0.0f, 1.0f);
            graphics.blit(WidgetUtil.SELECTION_LOCATION, x - 1, y, 0.0f, 0.0f, 24, 24, 24, 24);
        }
        this.renderSlot(graphics, x, y, itemRenderList, guiSlot, overwrideAvailable);
    }

    protected abstract void renderSlot(RenderContext var1, int var2, int var3, List<Runnable> var4, GuiSlot var5, boolean var6);

    @Override
    public List<GuiSlot> getSlots() {
        return this.slots;
    }

    @Override
    public WidgetArea getWidgetArea() {
        return this.widgetArea;
    }

    @Override
    public int titleYOffset() {
        return this.widgetArea.getBackgroundSizeY();
    }
}

