/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay;

import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.client.ContainerProvider;
import dev.tr7zw.itemswapper.compat.ControlifySupport;
import dev.tr7zw.itemswapper.compat.ViveCraftSupport;
import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.manager.ClientProviderManager;
import dev.tr7zw.itemswapper.manager.ItemGroupManager;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroup;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.manager.itemgroups.Shortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.BackShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.BlockColorShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.ClearCurrentSlotShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.LastItemShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.LinkShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.OpenInventoryShortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.RestockShortcut;
import dev.tr7zw.itemswapper.overlay.ItemSwapperUIAbstractInput;
import dev.tr7zw.itemswapper.overlay.logic.BlockListWidget;
import dev.tr7zw.itemswapper.overlay.logic.ContainerWidget;
import dev.tr7zw.itemswapper.overlay.logic.GuiSelectionHandler;
import dev.tr7zw.itemswapper.overlay.logic.GuiWidget;
import dev.tr7zw.itemswapper.overlay.logic.HotbarWidget;
import dev.tr7zw.itemswapper.overlay.logic.InventoryWidget;
import dev.tr7zw.itemswapper.overlay.logic.ListContentWidget;
import dev.tr7zw.itemswapper.overlay.logic.PaletteWidget;
import dev.tr7zw.itemswapper.overlay.logic.ShortcutListWidget;
import dev.tr7zw.itemswapper.util.ColorUtil;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.transition.mc.GeneralUtil;
import dev.tr7zw.transition.mc.InventoryUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class SwitchItemOverlay
extends ItemSwapperUIAbstractInput {
    private final class_310 minecraft = class_310.method_1551();
    private final ClientProviderManager providerManager = ItemSwapperSharedMod.instance.getClientProviderManager();
    private final GuiSelectionHandler selectionHandler = new GuiSelectionHandler();
    private int globalXOffset = 0;
    private int globalYOffset = 0;
    private boolean forceAvailable = false;
    private boolean hideCursor = false;
    private boolean hideShortcuts = false;
    private List<Shortcut> shortcutList = Collections.emptyList();
    private List<ItemGroupManager.Page> lastPages = new ArrayList<ItemGroupManager.Page>();
    private boolean hideClearSlotShortcut = false;
    private final ConfigManager configManager = ConfigManager.getInstance();

    private SwitchItemOverlay() {
        super((class_2561)ComponentProvider.empty());
        if (this.minecraft.field_1724.method_68878() && this.configManager.getConfig().creativeCheatMode) {
            this.setForceAvailable(true);
        }
    }

    private void initShortcuts() {
        this.shortcutList = new ArrayList<Shortcut>();
        if (this.hideShortcuts) {
            return;
        }
        if (!this.hideClearSlotShortcut) {
            this.shortcutList.add(new ClearCurrentSlotShortcut());
        }
        this.shortcutList.add(new LastItemShortcut(ItemSwapperSharedMod.instance.getLastItem(), ItemSwapperSharedMod.instance.getLastPage()));
        if (this.configManager.getConfig().experimentalAutoPalette) {
            this.shortcutList.add(new BlockColorShortcut(null, 0));
        }
        if (ItemSwapperSharedMod.instance.isEnableRefill()) {
            this.shortcutList.add(new RestockShortcut());
        }
        if (this.configManager.getConfig().showOpenInventoryButton) {
            this.shortcutList.add(new OpenInventoryShortcut(this));
        }
        this.shortcutList.add(new BackShortcut(this));
        this.shortcutList.add(new LinkShortcut(GeneralUtil.getResourceLocation((String)"itemswapper", (String)"v2/main"), (class_2561)ComponentProvider.translatable((String)"text.itemswapper.overview"), null));
    }

    public static SwitchItemOverlay createPageOverlay(ItemGroupManager.Page page) {
        SwitchItemOverlay overlay = new SwitchItemOverlay();
        overlay.openPage(page);
        return overlay;
    }

    public static SwitchItemOverlay createPaletteOverlay(ItemGroup itemGroup) {
        SwitchItemOverlay overlay = new SwitchItemOverlay();
        overlay.openItemGroup(itemGroup);
        return overlay;
    }

    public static SwitchItemOverlay createInventoryOverlay() {
        SwitchItemOverlay overlay = new SwitchItemOverlay();
        overlay.openInventory();
        return overlay;
    }

    public void openItemGroup(ItemGroup itemGroup) {
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.ItemGroupPage(itemGroup));
        this.initShortcuts();
        PaletteWidget mainWidget = new PaletteWidget(itemGroup, 0, 0);
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(itemGroup.getId(), this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 1));
        this.selectionHandler.addWidget(new ShortcutListWidget(itemGroup.getId(), itemGroup.getShortcuts(), -mainWidget.getWidgetArea().getMouseBoundsX() - 22, 1));
    }

    public void openItemList(ItemList items) {
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.ListPage(items));
        this.initShortcuts();
        ListContentWidget mainWidget = new ListContentWidget(items, 0, 0);
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(items.getId(), this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 1));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openPage(ItemGroupManager.Page page) {
        if (page instanceof ItemGroupManager.NoPage) return false;
        if (!this.lastPages.isEmpty() && page.equals(this.lastPages.get(this.lastPages.size() - 1))) {
            return false;
        }
        ItemGroupManager.Page page2 = page;
        Objects.requireNonNull(page2);
        ItemGroupManager.Page page3 = page2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemGroupManager.ItemGroupPage.class, ItemGroupManager.ListPage.class, ItemGroupManager.InventoryPage.class, ItemGroupManager.ContainerPage.class, ItemGroupManager.TexturePage.class, ItemGroupManager.NoPage.class}, (Object)page3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ItemGroupManager.ItemGroupPage itemGroupPage = (ItemGroupManager.ItemGroupPage)page3;
                try {
                    ItemGroup itemGroup;
                    ItemGroup gr = itemGroup = itemGroupPage.group();
                    this.openItemGroup(gr);
                    return true;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                ItemGroupManager.ListPage list = (ItemGroupManager.ListPage)page3;
                this.openItemList(list.items());
                return true;
            }
            case 2: {
                ItemGroupManager.InventoryPage inv = (ItemGroupManager.InventoryPage)page3;
                this.openInventory();
                return true;
            }
            case 3: {
                ItemGroupManager.ContainerPage containerPage = (ItemGroupManager.ContainerPage)page3;
                {
                    int n2;
                    int id = n2 = containerPage.containerSlotId();
                    this.openContainer(id);
                    return true;
                }
            }
            case 4: {
                ItemGroupManager.TexturePage texturePage = (ItemGroupManager.TexturePage)page3;
                {
                    Object object;
                    ColorUtil.UnpackedColor[] color = object = texturePage.color();
                    Object sideBase = object = texturePage.sideBase();
                    this.openTexturePallete(color, (ColorUtil.UnpackedColor)sideBase);
                    return true;
                }
            }
            case 5: 
        }
        ItemGroupManager.NoPage noPage = (ItemGroupManager.NoPage)page3;
        throw new RuntimeException("Unexpected value: " + String.valueOf(page));
    }

    public boolean selectIcon(String selector, int xOffset, int yOffset) {
        return this.selectionHandler.select(selector, xOffset, yOffset, this);
    }

    public void openInventory() {
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.InventoryPage());
        this.initShortcuts();
        InventoryWidget mainWidget = new InventoryWidget(0, 0);
        this.selectionHandler.addWidget(mainWidget);
        if (this.configManager.getConfig().showHotbar) {
            HotbarWidget hotbarWidget = new HotbarWidget(0, mainWidget.getWidgetArea().getMouseBoundsY() + 22);
            this.selectionHandler.addWidget(hotbarWidget);
        }
        this.selectionHandler.addWidget(new ShortcutListWidget(null, this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 0));
    }

    public void openContainer(int slotId) {
        class_1799 item = (class_1799)InventoryUtil.getNonEquipmentItems((class_1661)this.minecraft.field_1724.method_31548()).get(slotId);
        ContainerProvider provider = this.providerManager.getContainerProvider(item.method_7909());
        if (provider == null) {
            this.lastPages.clear();
            this.openInventory();
            return;
        }
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.ContainerPage(slotId));
        this.initShortcuts();
        ContainerWidget mainWidget = new ContainerWidget(0, 0, slotId);
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(null, this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 0));
    }

    public void openTexturePallete(ColorUtil.UnpackedColor[] color, ColorUtil.UnpackedColor sideBase) {
        this.selectionHandler.reset();
        this.lastPages.add(new ItemGroupManager.TexturePage(color, sideBase));
        this.initShortcuts();
        ArrayList<Shortcut> leftList = new ArrayList<Shortcut>();
        leftList.add(new BlockColorShortcut(sideBase, 0));
        leftList.add(new BlockColorShortcut(sideBase, 1));
        leftList.add(new BlockColorShortcut(sideBase, 2));
        leftList.add(new BlockColorShortcut(sideBase, 3));
        BlockListWidget mainWidget = new BlockListWidget(0, 0, ItemSwapperSharedMod.instance.getBlockTextureManager().getBlocksByAverageColor(color));
        this.selectionHandler.addWidget(mainWidget);
        this.selectionHandler.addWidget(new ShortcutListWidget(null, this.shortcutList, mainWidget.getWidgetArea().getMouseBoundsX() + 22, 0));
        this.selectionHandler.addWidget(new ShortcutListWidget(null, leftList, -mainWidget.getWidgetArea().getMouseBoundsX() - 22, 1));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float f) {
        RenderContext renderContext = new RenderContext(graphics);
        int originX = this.minecraft.method_22683().method_4486() / 2 + this.globalXOffset;
        int originY = this.minecraft.method_22683().method_4502() / 2 + this.globalYOffset;
        this.selectionHandler.updateMousePosition(mouseX - originX, mouseY - originY);
        for (GuiWidget widget : this.selectionHandler.getWidgets()) {
            widget.render(this, renderContext, originX, originY, this.forceAvailable);
        }
        if (this.selectionHandler.getSelectedSlot() != null) {
            this.selectionHandler.getSelectedWidget().renderSelectedSlotName(this.selectionHandler.getSelectedSlot(), this.selectionHandler.getWidgets().get(0).titleYOffset(), this.selectionHandler.getWidgets().get(0).getWidgetArea().getBackgroundTextureSizeX() - 40, this.forceAvailable, renderContext);
            if (this.configManager.getConfig().showTooltips) {
                this.selectionHandler.getSelectedWidget().renderSelectedTooltip(this, renderContext, this.selectionHandler.getSelectedSlot(), this.selectionHandler.getCursorX() + (double)originX, this.selectionHandler.getCursorY() + (double)originY);
            }
        }
        if (this.configManager.getConfig().showCursor && !this.hideCursor && !ViveCraftSupport.getInstance().isActive() && !ControlifySupport.getInstance().isActive(this)) {
            renderContext.blit(WidgetUtil.CURSOR_LOCATION, originX + (int)this.selectionHandler.getCursorX() - 12, originY + (int)this.selectionHandler.getCursorY() - 12, 0.0f, 0.0f, 24, 24, 24, 24);
        }
    }

    @Override
    public void handleInput(double x, double y) {
        this.selectionHandler.updateSelection(x, y, this);
    }

    @Override
    public void onSecondaryClick() {
        if (this.selectionHandler.getSelectedSlot() != null) {
            this.selectionHandler.getSelectedWidget().onSecondaryClick(this, this.selectionHandler.getSelectedSlot(), (int)this.selectionHandler.getOffsetX(), (int)this.selectionHandler.getOffsetY());
        }
    }

    @Override
    public boolean onPrimaryClick() {
        if (this.selectionHandler.getSelectedSlot() != null) {
            return this.selectionHandler.getSelectedWidget().onPrimaryClick(this, this.selectionHandler.getSelectedSlot(), (int)this.selectionHandler.getOffsetX(), (int)this.selectionHandler.getOffsetY());
        }
        return true;
    }

    @Generated
    public void setGlobalXOffset(int globalXOffset) {
        this.globalXOffset = globalXOffset;
    }

    @Generated
    public void setForceAvailable(boolean forceAvailable) {
        this.forceAvailable = forceAvailable;
    }

    @Generated
    public void setHideCursor(boolean hideCursor) {
        this.hideCursor = hideCursor;
    }

    @Generated
    public void setHideShortcuts(boolean hideShortcuts) {
        this.hideShortcuts = hideShortcuts;
    }

    @Generated
    public List<ItemGroupManager.Page> getLastPages() {
        return this.lastPages;
    }

    @Generated
    public void setHideClearSlotShortcut(boolean hideClearSlotShortcut) {
        this.hideClearSlotShortcut = hideClearSlotShortcut;
    }
}

