/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.manager;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.tr7zw.itemswapper.ItemSwapperBase;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroup;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroupModifier;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemListModifier;
import dev.tr7zw.itemswapper.manager.itemgroups.Shortcut;
import dev.tr7zw.itemswapper.manager.shortcuts.LinkShortcut;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.transition.mc.ComponentProvider;
import dev.tr7zw.transition.mc.GeneralUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_4013;

public class SwapperResourceLoader
implements SimpleSynchronousResourceReloadListener,
class_4013 {
    public List<ItemGroup.Builder> itemGroups = new ArrayList<ItemGroup.Builder>();
    public List<ItemList.Builder> itemLists = new ArrayList<ItemList.Builder>();
    public List<ItemGroupModifier> itemGroupModifiers = new ArrayList<ItemGroupModifier>();
    public List<ItemListModifier> itemListModifiers = new ArrayList<ItemListModifier>();

    public class_2960 getFabricId() {
        return GeneralUtil.getResourceLocation((String)"itemswapper", (String)"itemgroups");
    }

    public void method_14491(class_3300 resourceManager) {
        ItemSwapperBase.LOGGER.info("Reloading ItemSwapper item groups and lists...");
        this.itemGroups.clear();
        this.itemGroupModifiers.clear();
        this.itemListModifiers.clear();
        this.itemLists.clear();
        resourceManager.method_14488("itemgroups", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try {
                InputStream stream = resourceRef.method_14482();
                JsonElement data = JsonParser.parseReader((Reader)new InputStreamReader(stream));
                String ids = id.toString().replaceFirst("itemgroups/", "").replaceFirst(".json", "");
                AbstractMap.SimpleEntry<class_2960, JsonElement> entry = new AbstractMap.SimpleEntry<class_2960, JsonElement>(GeneralUtil.getResourceLocation((String)ids), data);
                this.processEntry(entry);
            }
            catch (Exception e) {
                ItemSwapperBase.LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        });
        this.applyModifications();
        this.registerItemGroups();
        this.itemGroups.clear();
        this.itemGroupModifiers.clear();
        this.itemListModifiers.clear();
        this.itemLists.clear();
    }

    private void processEntry(Map.Entry<class_2960, JsonElement> entry) {
        try {
            if (!entry.getKey().method_12836().equals("itemswapper")) {
                return;
            }
            if (entry.getKey().method_12832().startsWith("wheel_combined/")) {
                this.processCombined(entry.getKey(), entry.getValue());
                return;
            }
            if (entry.getKey().method_12832().startsWith("v2/")) {
                this.processV2(entry.getKey(), entry.getValue());
                return;
            }
            class_1792[] items = this.getItemArray(entry.getKey(), entry.getValue(), entry.getKey().method_12832().startsWith("wheel"));
            if (items != null) {
                ItemGroup.Builder group = ItemGroup.builder().withId(entry.getKey()).withItems(ItemUtil.toDefault(items));
                if (entry.getKey().method_12832().startsWith("wheel_primary/")) {
                    this.itemGroups.add(group.withPriority(100));
                }
                if (entry.getKey().method_12832().startsWith("wheel_secondary/")) {
                    this.itemGroups.add(group.withPriority(200));
                }
                if (entry.getKey().method_12832().startsWith("list/")) {
                    this.itemLists.add(ItemList.builder().withId(entry.getKey()).withItems(items));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void registerItemGroups() {
        for (ItemGroup.Builder itemGroup : this.itemGroups) {
            ItemSwapperSharedMod.instance.getItemGroupManager().registerItemGroup(itemGroup.withItems(this.filterAir(itemGroup.getItems())).build());
        }
        for (ItemList.Builder itemList : this.itemLists) {
            ItemSwapperSharedMod.instance.getItemGroupManager().registerListCollection(itemList.build());
        }
    }

    private ItemEntry[] filterAir(ItemEntry[] items) {
        ArrayList<ItemEntry> filteredEntries = new ArrayList<ItemEntry>();
        for (ItemEntry entry : items) {
            if (entry.getItem() == class_1802.field_8162) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries.toArray(new ItemEntry[0]);
    }

    private void applyModifications() {
        ArrayList<ItemEntry> entries;
        block0: for (ItemGroupModifier itemGroupModifier : this.itemGroupModifiers) {
            for (ItemGroup.Builder group : this.itemGroups) {
                if (!itemGroupModifier.getTarget().equals((Object)group.getId())) continue;
                entries = new ArrayList<ItemEntry>(Arrays.asList(group.getItems()));
                if (itemGroupModifier.getRemoveItems() != null) {
                    for (ItemEntry itemEntry : itemGroupModifier.getRemoveItems()) {
                        entries.removeIf(entry -> entry.getItem().equals(remove.getItem()));
                    }
                }
                if (itemGroupModifier.getAddItems() != null) {
                    entries.addAll(Arrays.asList(itemGroupModifier.getAddItems()));
                }
                group.withItems(entries.toArray(new ItemEntry[0]));
                continue block0;
            }
        }
        block3: for (ItemListModifier itemListModifier : this.itemListModifiers) {
            for (ItemList.Builder list : this.itemLists) {
                if (!itemListModifier.getTarget().equals((Object)list.getId())) continue;
                entries = new ArrayList<class_1792>(Arrays.asList(list.getItems()));
                if (itemListModifier.getRemoveItems() != null) {
                    for (ItemEntry itemEntry : itemListModifier.getRemoveItems()) {
                        entries.removeIf(arg_0 -> SwapperResourceLoader.lambda$applyModifications$3((class_1792)itemEntry, arg_0));
                    }
                }
                if (itemListModifier.getAddItems() != null) {
                    entries.addAll(Arrays.asList(itemListModifier.getAddItems()));
                }
                list.withItems(entries.toArray(new class_1792[0]));
                continue block3;
            }
        }
    }

    private void processV2(class_2960 jsonLocation, JsonElement json) {
        String type;
        if (!json.isJsonObject()) {
            ItemSwapperBase.LOGGER.error("Invalid data in {}", (Object)jsonLocation);
            return;
        }
        JsonObject obj = json.getAsJsonObject();
        switch (type = obj.get("type").getAsString()) {
            case "palette": {
                this.processPalette(jsonLocation, obj);
                return;
            }
            case "paletteModification": {
                this.processPaletteModification(jsonLocation, obj);
                return;
            }
            case "listModification": {
                this.processListModification(jsonLocation, obj);
                return;
            }
            case "list": {
                this.processList(jsonLocation, obj);
                return;
            }
        }
    }

    private void processList(class_2960 jsonLocation, JsonObject json) {
        class_1792[] ignoreItems;
        ItemList.Builder group = ItemList.builder().withId(jsonLocation);
        if (json.has("disableAutoLink") && json.get("disableAutoLink").isJsonPrimitive()) {
            group.withDisableAutoLink(json.get("disableAutoLink").getAsBoolean());
        }
        if (json.has("displayName") && json.get("displayName").isJsonPrimitive()) {
            group.withDisplayName((class_2561)ComponentProvider.translatable((String)json.get("displayName").getAsString()));
        }
        if (json.has("link") && json.get("link").isJsonPrimitive()) {
            try {
                group.withLink(GeneralUtil.getResourceLocation((String)json.getAsJsonPrimitive("link").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperBase.LOGGER.warn("Invalid link in " + String.valueOf(jsonLocation));
            }
        }
        group.withItems(this.getItemArray(jsonLocation, json.get("items"), false));
        if (group.getItems() == null || group.getItems().length == 0) {
            ItemSwapperBase.LOGGER.warn("Item list " + String.valueOf(jsonLocation) + " has no items, skipping.");
            return;
        }
        class_1792[] openOnly = this.getItemArray(jsonLocation, json.get("openOnlyItems"), false);
        if (openOnly != null && openOnly.length > 0) {
            group.withOpenOnlyItems(new HashSet<class_1792>(Arrays.asList(openOnly)));
        }
        if ((ignoreItems = this.getItemArray(jsonLocation, json.get("ignoreItems"), false)) != null && ignoreItems.length > 0) {
            group.withIgnoreItems(new HashSet<class_1792>(Arrays.asList(ignoreItems)));
        }
        if (json.has("icon") && json.get("icon").isJsonPrimitive()) {
            group.withIcon(dev.tr7zw.transition.mc.ItemUtil.getItem((class_2960)GeneralUtil.getResourceLocation((String)json.get("icon").getAsString())));
        }
        this.itemLists.add(group);
    }

    private void processPalette(class_2960 jsonLocation, JsonObject json) {
        class_1792[] ignoreItems;
        ItemGroup.Builder group = ItemGroup.builder().withId(jsonLocation);
        if (json.has("priority") && json.get("priority").isJsonPrimitive()) {
            group.withPriority(json.getAsJsonPrimitive("priority").getAsInt());
        } else {
            group.withPriority(100);
        }
        if (json.has("fallbackLink") && json.get("fallbackLink").isJsonPrimitive()) {
            try {
                group.withFallbackLink(GeneralUtil.getResourceLocation((String)json.getAsJsonPrimitive("fallbackLink").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperBase.LOGGER.warn("Invalid fallbackLink in " + String.valueOf(jsonLocation));
            }
        }
        if (json.has("forceLink") && json.get("forceLink").isJsonPrimitive()) {
            try {
                group.withForcedLink(GeneralUtil.getResourceLocation((String)json.getAsJsonPrimitive("forceLink").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperBase.LOGGER.warn("Invalid forceLink in " + String.valueOf(jsonLocation));
            }
        }
        if (json.has("disableAutoLink") && json.get("disableAutoLink").isJsonPrimitive()) {
            group.withDisableAutoLink(json.get("disableAutoLink").getAsBoolean());
        }
        if (json.has("displayName") && json.get("displayName").isJsonPrimitive()) {
            group.withDisplayName((class_2561)ComponentProvider.translatable((String)json.get("displayName").getAsString()));
        }
        group.withItems(this.processItems(jsonLocation, json.get("items")));
        class_1792[] openOnly = this.getItemArray(jsonLocation, json.get("openOnlyItems"), false);
        if (openOnly != null && openOnly.length > 0) {
            group.withOpenOnlyItems(new HashSet<class_1792>(Arrays.asList(openOnly)));
        }
        if ((ignoreItems = this.getItemArray(jsonLocation, json.get("ignoreItems"), false)) != null && ignoreItems.length > 0) {
            group.withIgnoreItems(new HashSet<class_1792>(Arrays.asList(ignoreItems)));
        }
        group.withShortcuts(this.processShortcuts(jsonLocation, json.get("shortcuts")));
        if (json.has("icon") && json.get("icon").isJsonPrimitive()) {
            group.withIcon(dev.tr7zw.transition.mc.ItemUtil.getItem((class_2960)GeneralUtil.getResourceLocation((String)json.get("icon").getAsString())));
        }
        this.itemGroups.add(group);
    }

    private void processListModification(class_2960 jsonLocation, JsonObject json) {
        ItemListModifier.Builder changes = ItemListModifier.builder();
        if (json.has("target") && json.get("target").isJsonPrimitive()) {
            try {
                changes.withTarget(GeneralUtil.getResourceLocation((String)json.getAsJsonPrimitive("target").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperBase.LOGGER.warn("Invalid target in " + String.valueOf(jsonLocation));
                return;
            }
        }
        changes.withAddItems(this.getItemArray(jsonLocation, json.get("addItems"), false));
        changes.withRemoveItems(this.getItemArray(jsonLocation, json.get("removeItems"), false));
        this.itemListModifiers.add(changes.build());
    }

    private void processPaletteModification(class_2960 jsonLocation, JsonObject json) {
        ItemGroupModifier.Builder changes = ItemGroupModifier.builder();
        if (json.has("target") && json.get("target").isJsonPrimitive()) {
            try {
                changes.withTarget(GeneralUtil.getResourceLocation((String)json.getAsJsonPrimitive("target").getAsString()));
            }
            catch (Exception ex) {
                ItemSwapperBase.LOGGER.warn("Invalid target in " + String.valueOf(jsonLocation));
                return;
            }
        }
        changes.withAddItems(this.processItems(jsonLocation, json.get("addItems")));
        changes.withRemoveItems(this.processItems(jsonLocation, json.get("removeItems")));
        this.itemGroupModifiers.add(changes.build());
    }

    private List<Shortcut> processShortcuts(class_2960 jsonLocation, JsonElement object) {
        if (object == null) {
            return Collections.emptyList();
        }
        if (!object.isJsonArray()) {
            try {
                object = ((JsonObject)object).get("items");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return Collections.emptyList();
            }
        }
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        object.getAsJsonArray().forEach(el -> {
            if (!el.isJsonObject()) {
                return;
            }
            JsonObject entry = el.getAsJsonObject();
            if (entry.has("type") && entry.get("type").isJsonPrimitive() && "link".equals(entry.get("type").getAsString())) {
                String displayname = entry.has("displayName") && entry.get("displayName").isJsonPrimitive() ? entry.get("displayName").getAsString() : null;
                class_1792 icon = null;
                if (entry.has("icon") && entry.get("icon").isJsonPrimitive()) {
                    icon = dev.tr7zw.transition.mc.ItemUtil.getItem((class_2960)GeneralUtil.getResourceLocation((String)entry.get("icon").getAsString()));
                }
                try {
                    shortcuts.add(new LinkShortcut(GeneralUtil.getResourceLocation((String)entry.getAsJsonPrimitive("target").getAsString()), (class_2561)(displayname != null ? ComponentProvider.translatable((String)displayname) : null), icon));
                }
                catch (Exception ex) {
                    ItemSwapperBase.LOGGER.warn("Invalid link target shortcut in " + String.valueOf(jsonLocation));
                }
            }
        });
        return shortcuts;
    }

    private ItemEntry[] processItems(class_2960 jsonLocation, JsonElement object) {
        if (object == null) {
            return null;
        }
        if (!object.isJsonArray()) {
            try {
                object = ((JsonObject)object).get("items");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        ArrayList itemList = new ArrayList();
        object.getAsJsonArray().forEach(el -> {
            if (el.isJsonPrimitive()) {
                ItemEntry entry;
                class_2960 resourceLocation = GeneralUtil.getResourceLocation((String)el.getAsString());
                class_1792 item = dev.tr7zw.transition.mc.ItemUtil.getItem((class_2960)resourceLocation);
                if (item == class_1802.field_8162) {
                    ItemSwapperBase.LOGGER.info("Unable to find " + String.valueOf(resourceLocation) + ", ignoring.");
                }
                if (!itemList.contains(entry = new ItemEntry(item, null))) {
                    itemList.add(entry);
                }
            }
            if (el.isJsonObject()) {
                ItemEntry entry;
                JsonObject obj = el.getAsJsonObject();
                class_2960 resourceLocation = GeneralUtil.getResourceLocation((String)obj.get("id").getAsString());
                class_1792 item = dev.tr7zw.transition.mc.ItemUtil.getItem((class_2960)resourceLocation);
                if (item == class_1802.field_8162) {
                    ItemSwapperBase.LOGGER.info("Unable to find " + String.valueOf(resourceLocation) + ", ignoring.");
                }
                class_2960 link = null;
                if (obj.has("link") && obj.get("link").isJsonPrimitive()) {
                    try {
                        link = GeneralUtil.getResourceLocation((String)obj.get("link").getAsString());
                    }
                    catch (Exception ex) {
                        ItemSwapperBase.LOGGER.warn("Invalid item link in " + String.valueOf(jsonLocation));
                    }
                }
                String displayName = null;
                if (obj.has("name") && obj.get("name").isJsonPrimitive()) {
                    displayName = obj.getAsJsonPrimitive("name").getAsString();
                }
                boolean actAsLink = false;
                if (obj.has("actAsLink") && obj.get("actAsLink").isJsonPrimitive()) {
                    actAsLink = obj.getAsJsonPrimitive("actAsLink").getAsBoolean();
                }
                if (!itemList.contains(entry = new ItemEntry(item, link, (class_2561)(displayName != null ? ComponentProvider.translatable((String)displayName) : null), actAsLink))) {
                    itemList.add(entry);
                }
            }
        });
        if (!itemList.isEmpty()) {
            return itemList.toArray(new ItemEntry[0]);
        }
        return null;
    }

    private void processCombined(class_2960 jsonLocation, JsonElement json) {
        int i;
        if (json == null) {
            return;
        }
        if (!json.isJsonArray()) {
            try {
                json = ((JsonObject)json).get("items");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        JsonArray ar = json.getAsJsonArray();
        ArrayList<class_1792[]> lists = new ArrayList<class_1792[]>();
        for (i = 0; i < ar.size(); ++i) {
            class_1792[] list = this.getItemArray(jsonLocation, ar.get(i), true);
            if (list == null || list.length <= 0) continue;
            lists.add(list);
        }
        if (lists.isEmpty()) {
            return;
        }
        for (i = 0; i < lists.size(); ++i) {
            class_2960 ownId = GeneralUtil.getResourceLocation((String)jsonLocation.method_12836(), (String)(jsonLocation.method_12832() + i));
            int next = i + 1 == lists.size() ? 0 : i + 1;
            class_2960 nextId = GeneralUtil.getResourceLocation((String)jsonLocation.method_12836(), (String)(jsonLocation.method_12832() + next));
            this.itemGroups.add(ItemGroup.builder().withId(ownId).withForcedLink(nextId).withItems(ItemUtil.toDefault((class_1792[])lists.get(i))).withShortcuts(Arrays.asList(new LinkShortcut(nextId))));
        }
    }

    private class_1792[] getItemArray(class_2960 jsonLocation, JsonElement json, boolean pallet) {
        if (json == null) {
            return null;
        }
        if (!json.isJsonArray()) {
            try {
                json = ((JsonObject)json).get("items");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        ArrayList itemList = new ArrayList();
        json.getAsJsonArray().forEach(el -> {
            if (el.isJsonPrimitive()) {
                class_2960 resourceLocation = GeneralUtil.getResourceLocation((String)el.getAsString());
                class_1792 item = dev.tr7zw.transition.mc.ItemUtil.getItem((class_2960)resourceLocation);
                if (item.equals(class_1802.field_8162)) {
                    ItemSwapperBase.LOGGER.warn("Unknown item: " + el.getAsString() + " in " + String.valueOf(jsonLocation));
                    if (pallet) {
                        itemList.add(class_1802.field_8162);
                    }
                    return;
                }
                if (!itemList.contains(item)) {
                    itemList.add(item);
                }
            }
        });
        if (!itemList.isEmpty()) {
            return itemList.toArray(new class_1792[0]);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$applyModifications$3(class_1792 remove, class_1792 entry) {
        return entry.equals(remove);
    }

    public static class ResourceLoaderInit {
        public static void init() {
            ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(GeneralUtil.getResourceLocation((String)"itemswapper:reloader"), (class_3302)new SwapperResourceLoader());
        }
    }
}

