/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.manager.ClientProviderManager;
import dev.tr7zw.itemswapper.manager.ItemGroupManager;
import dev.tr7zw.itemswapper.overlay.SwitchItemOverlay;
import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.ItemGridWidget;
import dev.tr7zw.itemswapper.util.ColorUtil;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.itemswapper.util.RenderHelper;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import dev.tr7zw.transition.mc.GeneralUtil;
import dev.tr7zw.transition.mc.InventoryUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public class BlockListWidget
extends ItemGridWidget {
    private static final class_2960 BACKGROUND_LOCATION = GeneralUtil.getResourceLocation((String)"itemswapper", (String)"textures/gui/inventory.png");
    private static final ClientProviderManager providerManager = ItemSwapperSharedMod.instance.getClientProviderManager();
    private List<class_2248> blocks;

    public BlockListWidget(int x, int y, List<class_2248> blocks) {
        super(x, y);
        this.blocks = blocks;
        WidgetUtil.setupSlots(this.widgetArea, this.slots, 9, 3, false, BACKGROUND_LOCATION);
        this.widgetArea.setBackgroundTextureSizeX(168);
        this.widgetArea.setBackgroundTextureSizeY(60);
    }

    @Override
    protected void renderSlot(RenderContext graphics, int x, int y, List<Runnable> itemRenderList, GuiSlot guiSlot, boolean overwrideAvailable) {
        if (guiSlot.id() >= this.blocks.size()) {
            return;
        }
        class_1792 item = this.blocks.get(guiSlot.id()).method_8389();
        List<AvailableSlot> slots = providerManager.findSlotsMatchingItem(item, true, false);
        if (!slots.isEmpty() && !overwrideAvailable) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, ((AvailableSlot)slots.get(0)).item(), 1, RenderHelper.SlotEffect.NONE, ((AvailableSlot)slots.get(0)).amount().get()));
        } else if (guiSlot.id() <= this.blocks.size()) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, this.blocks.get(guiSlot.id()).method_8389().method_7854(), 1, !overwrideAvailable ? RenderHelper.SlotEffect.RED : RenderHelper.SlotEffect.NONE, 1));
        }
    }

    @Override
    public boolean onPrimaryClick(SwitchItemOverlay overlay, GuiSlot guiSlot, int xOffset, int yOffset) {
        class_1792 item = this.blocks.get(guiSlot.id()).method_8389();
        if (item != null && item != class_1802.field_8162) {
            if (this.minecraft.field_1724.method_7337() && this.configManager.getConfig().creativeCheatMode) {
                this.minecraft.field_1761.method_2909(item.method_7854().method_7972(), 36 + InventoryUtil.getSelectedId((class_1661)this.minecraft.field_1724.method_31548()));
                this.minecraft.field_1724.method_31548().method_5447(InventoryUtil.getSelectedId((class_1661)this.minecraft.field_1724.method_31548()), item.method_7854().method_7972());
                ItemSwapperSharedMod.instance.setLastItem(item);
                ItemSwapperSharedMod.instance.setLastPage(overlay.getLastPages().get(overlay.getLastPages().size() - 1));
                return false;
            }
            boolean changed = ItemUtil.grabItem(item, false);
            if (changed) {
                ItemSwapperSharedMod.instance.setLastItem(item);
                ItemSwapperSharedMod.instance.setLastPage(overlay.getLastPages().get(overlay.getLastPages().size() - 1));
                return false;
            }
        }
        return true;
    }

    @Override
    public void onSecondaryClick(SwitchItemOverlay overlay, GuiSlot slot, int xOffset, int yOffset) {
        ColorUtil.UnpackedColor[] color = ItemSwapperSharedMod.instance.getBlockTextureManager().getColor(this.blocks.get(slot.id()));
        ItemSwapperSharedMod.instance.openPage(new ItemGroupManager.TexturePage(color, color[0]));
    }

    @Override
    public void renderSelectedSlotName(GuiSlot selected, int yOffset, int maxWidth, boolean overwrideAvailable, RenderContext graphics) {
        if (selected.id() >= this.blocks.size()) {
            return;
        }
        class_1792 item = this.blocks.get(selected.id()).method_8389();
        List<AvailableSlot> availableSlots = providerManager.findSlotsMatchingItem(item, true, false);
        if (!availableSlots.isEmpty() && !overwrideAvailable) {
            RenderHelper.renderSelectedItemName(availableSlots.get(0).item().method_7954(), availableSlots.get(0).item(), false, yOffset, maxWidth, graphics);
        } else {
            RenderHelper.renderSelectedItemName(ItemUtil.getDisplayname(this.blocks.get(selected.id()).method_8389().method_7854()), this.blocks.get(selected.id()).method_8389().method_7854(), !overwrideAvailable, yOffset, maxWidth, graphics);
        }
    }
}

