/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import dev.tr7zw.itemswapper.ItemSwapperMod;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroup;
import dev.tr7zw.itemswapper.overlay.SwitchItemOverlay;
import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.ItemGridWidget;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.itemswapper.util.RenderHelper;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import dev.tr7zw.transition.mc.InventoryUtil;
import dev.tr7zw.trender.gui.client.RenderContext;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public class PaletteWidget
extends ItemGridWidget {
    private final ItemGroup itemGroup;

    public PaletteWidget(ItemGroup itemGroup, int x, int y) {
        super(x, y);
        this.itemGroup = itemGroup;
        WidgetUtil.setupDynamicSlots(this.widgetArea, this.slots, itemGroup.getItems().length);
    }

    private List<AvailableSlot> getItem(int id) {
        return id > this.itemGroup.getItems().length - 1 ? Collections.emptyList() : this.providerManager.findSlotsMatchingItem(this.itemGroup.getItems()[id].getItem(), false, false);
    }

    @Override
    protected void renderSlot(RenderContext graphics, int x, int y, List<Runnable> itemRenderList, GuiSlot guiSlot, boolean overwrideAvailable) {
        ItemEntry entry = this.itemGroup.getItem(guiSlot.id());
        if (entry != null && entry.isActAsLink()) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, entry.getItem().method_7854(), 1, RenderHelper.SlotEffect.NONE, 1));
            return;
        }
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty() && !overwrideAvailable) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, ((AvailableSlot)slots.get(0)).item(), 1, RenderHelper.SlotEffect.NONE, ((AvailableSlot)slots.get(0)).amount().get()));
        } else if (guiSlot.id() <= this.itemGroup.getItems().length - 1) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, this.itemGroup.getItems()[guiSlot.id()].getItem().method_7854(), 1, !overwrideAvailable ? RenderHelper.SlotEffect.RED : RenderHelper.SlotEffect.NONE, 1));
        }
    }

    @Override
    public void onSecondaryClick(SwitchItemOverlay overlay, GuiSlot slot, int xOffset, int yOffset) {
        ItemEntry entry = this.itemGroup.getItem(slot.id());
        if (entry != null && entry.getItem() != class_1802.field_8162 && overlay.openPage(ItemSwapperMod.instance.getItemGroupManager().getNextPage(this.itemGroup, entry, -1))) {
            overlay.selectIcon("item|" + class_1792.method_7880((class_1792)entry.getItem()), xOffset, yOffset);
        }
    }

    @Override
    public boolean onPrimaryClick(SwitchItemOverlay overlay, GuiSlot guiSlot, int xOffset, int yOffset) {
        ItemEntry entry = this.itemGroup.getItem(guiSlot.id());
        if (entry != null && entry.isActAsLink()) {
            this.onSecondaryClick(overlay, guiSlot, xOffset, yOffset);
            return true;
        }
        if (entry != null && entry.getItem() != class_1802.field_8162) {
            if (this.minecraft.field_1724.method_7337() && this.configManager.getConfig().creativeCheatMode) {
                this.minecraft.field_1761.method_2909(entry.getItem().method_7854().method_7972(), 36 + InventoryUtil.getSelectedId((class_1661)this.minecraft.field_1724.method_31548()));
                this.minecraft.field_1724.method_31548().method_5447(InventoryUtil.getSelectedId((class_1661)this.minecraft.field_1724.method_31548()), entry.getItem().method_7854().method_7972());
                ItemSwapperSharedMod.instance.setLastItem(entry.getItem());
                ItemSwapperSharedMod.instance.setLastPage(overlay.getLastPages().get(overlay.getLastPages().size() - 1));
                ItemSwapperMod.instance.getItemGroupManager().setLastPickedItem(entry.getItem(), this.itemGroup);
                return false;
            }
            boolean changed = ItemUtil.grabItem(entry.getItem(), false);
            if (changed) {
                ItemSwapperSharedMod.instance.setLastItem(entry.getItem());
                ItemSwapperSharedMod.instance.setLastPage(overlay.getLastPages().get(overlay.getLastPages().size() - 1));
                ItemSwapperMod.instance.getItemGroupManager().setLastPickedItem(entry.getItem(), this.itemGroup);
                return false;
            }
        }
        return true;
    }

    @Override
    public void renderSelectedSlotName(GuiSlot selected, int yOffset, int maxWidth, boolean overwrideAvailable, RenderContext graphics) {
        ItemEntry slot = this.itemGroup.getItem(selected.id());
        if (slot == null) {
            return;
        }
        if (slot.isActAsLink()) {
            RenderHelper.renderSelectedItemName(RenderHelper.getName(this.itemGroup.getItem(selected.id())), slot.getItem().method_7854(), false, yOffset, maxWidth, graphics);
            return;
        }
        List<AvailableSlot> availableSlots = this.getItem(selected.id());
        if (!availableSlots.isEmpty() && !overwrideAvailable) {
            RenderHelper.renderSelectedItemName(RenderHelper.getName(this.itemGroup.getItem(selected.id())), availableSlots.get(0).item(), false, yOffset, maxWidth, graphics);
        } else {
            RenderHelper.renderSelectedItemName(RenderHelper.getName(this.itemGroup.getItem(selected.id())), slot.getItem().method_7854(), !overwrideAvailable, yOffset, maxWidth, graphics);
        }
    }

    @Override
    public String getSelector(GuiSlot slot) {
        ItemEntry entry = this.itemGroup.getItem(slot.id());
        if (entry != null) {
            return "item|" + class_1792.method_7880((class_1792)entry.getItem());
        }
        return null;
    }
}

