/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;

public class CleanroomRelease {
    private static final Path CACHE_FILE = CleanroomRelauncher.CACHE_DIR.resolve("releases.json");
    public String name;
    @SerializedName(value="tag_name")
    public String tagName;
    public List<Asset> assets;

    public static List<CleanroomRelease> queryAll() throws IOException {
        long ttlM = Duration.ofHours(1L).toMillis();
        if (Files.exists(CACHE_FILE, new LinkOption[0])) {
            CleanroomRelauncher.LOGGER.info("Loading releases from cached json.");
            try {
                long fileModifiedM = Files.getLastModifiedTime(CACHE_FILE, new LinkOption[0]).toMillis();
                long nowM = System.currentTimeMillis();
                long diffM = nowM - fileModifiedM;
                if (diffM < ttlM) {
                    return CleanroomRelease.fetchReleasesFromCache(CACHE_FILE);
                }
            }
            catch (Throwable t) {
                Files.delete(CACHE_FILE);
                CleanroomRelauncher.LOGGER.error("Unable to read cached releases.json, attempting to connect to GitHub and rebuild.", t);
            }
        } else {
            CleanroomRelauncher.LOGGER.info("No cache found, fetching releases...");
        }
        List<CleanroomRelease> releases = CleanroomRelease.fetchReleasesFromGithub();
        CleanroomRelease.saveReleasesToCache(CACHE_FILE, releases);
        return releases;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<CleanroomRelease> fetchReleasesFromGithub() throws IOException {
        try {
            URL url = new URL("https://api.github.com/repos/CleanroomMC/Cleanroom/releases");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
            if (connection.getResponseCode() != 200) {
                throw new IOException("Failed to fetch releases: HTTP error code " + connection.getResponseCode());
            }
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                List<Object> list = Arrays.asList((Object[])CleanroomRelauncher.GSON.fromJson((Reader)reader, CleanroomRelease[].class));
                return list;
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to fetch or parse releases", e);
        }
    }

    private static List<CleanroomRelease> fetchReleasesFromCache(Path releaseFile) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(releaseFile);){
            List<Object> list = Arrays.asList((Object[])CleanroomRelauncher.GSON.fromJson((Reader)reader, CleanroomRelease[].class));
            return list;
        }
    }

    private static void saveReleasesToCache(Path releaseFile, List<CleanroomRelease> releases) {
        releaseFile.toFile().getParentFile().mkdirs();
        try (BufferedWriter writer = Files.newBufferedWriter(releaseFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            CleanroomRelauncher.GSON.toJson(releases, (Appendable)writer);
            CleanroomRelauncher.LOGGER.info("Saved {} releases to cache.", (Object)releases.size());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save releases to cache.", e);
        }
    }

    public Asset getInstallerArtifact() {
        for (Asset asset : this.assets) {
            if (!asset.name.endsWith("-installer.jar")) continue;
            return asset;
        }
        return null;
    }

    @Deprecated
    public Asset getMultiMcPackArtifact() {
        for (Asset asset : this.assets) {
            if (!asset.name.endsWith(".zip") || !asset.name.contains("MMC")) continue;
            return asset;
        }
        return null;
    }

    public static class Asset {
        public String name;
        @SerializedName(value="browser_download_url")
        public String downloadUrl;
        public long size;
    }
}

