/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.javautils.locators;

import com.cleanroommc.relauncher.shade.javautils.api.JavaInstall;
import com.cleanroommc.relauncher.shade.javautils.locators.AbstractJavaLocator;
import com.cleanroommc.relauncher.shade.platformutils.Platform;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HomebrewProvisionedJavaLocator
extends AbstractJavaLocator {
    @Override
    protected List<JavaInstall> initialize() {
        Path homebrew;
        File[] directories;
        File cellar;
        if (Platform.current().isWindows()) {
            return Collections.emptyList();
        }
        ArrayList<JavaInstall> javaInstalls = new ArrayList<JavaInstall>();
        File homebrewMain = new File("/opt/homebrew/opt/java/bin/java");
        if (homebrewMain.exists()) {
            HomebrewProvisionedJavaLocator.parseOrLog(javaInstalls, homebrewMain);
        }
        if ((cellar = new File("/opt/homebrew/Cellar/openjdk")).exists() && (directories = cellar.listFiles()) != null) {
            for (File directory : directories) {
                HomebrewProvisionedJavaLocator.parseOrLog(javaInstalls, directory);
            }
        }
        if (Files.isDirectory(homebrew = Paths.get("/opt/homebrew/Cellar", new String[0]), new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(homebrew, "openjdk@*");){
                for (Path path : stream) {
                    File directory = path.toFile();
                    HomebrewProvisionedJavaLocator.parseOrLog(javaInstalls, directory);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Error encountered while searching for Java installs.", e);
            }
        }
        return javaInstalls;
    }
}

