/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.javautils.spi;

import com.cleanroommc.relauncher.shade.javautils.api.JavaInstall;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;

public interface JavaLocator {
    public static List<JavaLocator> locators() {
        ArrayList<JavaLocator> locators = new ArrayList<JavaLocator>();
        ServiceLoader.load(JavaLocator.class).iterator().forEachRemaining(locators::add);
        return locators;
    }

    public static <T extends JavaLocator> Optional<T> provider(Class<T> clazz) {
        return JavaLocator.locators().stream().filter(clazz::isInstance).findFirst();
    }

    public Set<JavaInstall> get(Predicate<JavaInstall> var1);

    public Set<JavaInstall> all();

    default public Set<JavaInstall> get(int featureVersion) {
        return this.get(javaInstall -> javaInstall.version().major() == featureVersion);
    }

    default public boolean has(int featureVersion) {
        return this.get(featureVersion) != null;
    }

    default public boolean has(Predicate<JavaInstall> predicate) {
        return this.get(predicate) != null;
    }
}

