/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher;

import com.cleanroommc.relauncher.config.RelauncherConfiguration;
import com.cleanroommc.relauncher.download.CalculationUtilities;
import com.cleanroommc.relauncher.download.CleanroomRelease;
import com.cleanroommc.relauncher.download.GlobalDownloader;
import com.cleanroommc.relauncher.download.cache.CleanroomCache;
import com.cleanroommc.relauncher.download.java.JavaDownloader;
import com.cleanroommc.relauncher.download.schema.Version;
import com.cleanroommc.relauncher.gui.RelauncherGUI;
import com.cleanroommc.relauncher.gui.SetupProgressDialog;
import com.cleanroommc.relauncher.shade.javautils.JavaUtils;
import com.cleanroommc.relauncher.shade.javautils.api.JavaVersion;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.cleanroomrelauncher.ExitVMBypass;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.ProcessIdUtil;

public class CleanroomRelauncher {
    public static final Logger LOGGER = LogManager.getLogger((String)"CleanroomRelauncher");
    public static final Gson GSON = new Gson();
    public static final Path CACHE_DIR = Paths.get(System.getProperty("user.home"), ".cleanroom", "relauncher");
    public static RelauncherConfiguration CONFIG = RelauncherConfiguration.read();

    private static Integer extractTemurinMajorFromPath(String javaPath) {
        if (javaPath == null || javaPath.isEmpty()) {
            return null;
        }
        String normalized = javaPath.replace('\\', '/');
        try {
            Pattern pat = Pattern.compile("(temurin|graalvm)-(\\d+)-(windows|linux|mac)-(x64|aarch64)", 2);
            Matcher m = pat.matcher(normalized);
            if (m.find()) {
                return Integer.parseInt(m.group(2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String extractVendorFromPath(String javaPath) {
        if (javaPath == null || javaPath.isEmpty()) {
            return null;
        }
        String normalized = javaPath.replace('\\', '/');
        try {
            Pattern pat = Pattern.compile("(temurin|graalvm)-(\\d+)-(windows|linux|mac)-(x64|aarch64)", 2);
            Matcher m = pat.matcher(normalized);
            if (m.find()) {
                return CleanroomRelauncher.normalizeVendorName(m.group(1).toLowerCase(Locale.ROOT));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String extractArchFromPath(String javaPath) {
        if (javaPath == null || javaPath.isEmpty()) {
            return null;
        }
        String normalized = javaPath.replace('\\', '/');
        try {
            Pattern pat = Pattern.compile("(temurin|graalvm)-(\\d+)-(windows|linux|mac)-(x64|aarch64)", 2);
            Matcher m = pat.matcher(normalized);
            if (m.find()) {
                return m.group(4).toLowerCase(Locale.ROOT);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String detectCurrentArch() {
        String osName = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        if (osName.contains("mac")) {
            Throwable throwable;
            BufferedReader reader;
            try {
                Process cpuProcess = Runtime.getRuntime().exec(new String[]{"sysctl", "-n", "machdep.cpu.brand_string"});
                cpuProcess.waitFor();
                reader = new BufferedReader(new InputStreamReader(cpuProcess.getInputStream()));
                throwable = null;
                try {
                    String cpuBrand = reader.readLine();
                    if (cpuBrand != null) {
                        cpuBrand = cpuBrand.trim();
                        LOGGER.info("macOS CPU: {}", (Object)cpuBrand);
                        if (cpuBrand.toLowerCase(Locale.ROOT).contains("apple")) {
                            LOGGER.info("Detected Apple Silicon (ARM64) via CPU branding");
                            String string2 = "aarch64";
                            return string2;
                        }
                    }
                }
                catch (Throwable cpuBrand) {
                    throwable = cpuBrand;
                    throw cpuBrand;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to detect CPU brand via sysctl: {}", (Object)e.toString());
            }
            try {
                Process rosettaProcess = Runtime.getRuntime().exec(new String[]{"sysctl", "-n", "sysctl.proc_translated"});
                rosettaProcess.waitFor();
                reader = new BufferedReader(new InputStreamReader(rosettaProcess.getInputStream()));
                throwable = null;
                try {
                    String translated = reader.readLine();
                    if (translated != null && translated.trim().equals("1")) {
                        LOGGER.info("Detected process running under Rosetta 2 - hardware is Apple Silicon (ARM64)");
                        String string = "aarch64";
                        return string;
                    }
                }
                catch (Throwable throwable7) {
                    throwable = throwable7;
                    throw throwable7;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("sysctl.proc_translated check failed (normal for Intel Mac or native ARM process): {}", (Object)e.toString());
            }
            String osArch = System.getProperty("os.arch", "").toLowerCase(Locale.ROOT);
            if (!osArch.contains("aarch64") && !osArch.contains("arm64")) {
                LOGGER.info("Detected Intel Mac (x64)");
                return "x64";
            }
            LOGGER.info("Detected native ARM64 JVM via os.arch: {}", (Object)osArch);
            return "aarch64";
        }
        String arch = System.getProperty("os.arch", "").toLowerCase(Locale.ROOT);
        if (arch.contains("aarch64")) return "aarch64";
        if (arch.contains("arm64")) return "aarch64";
        return "x64";
    }

    private static String normalizeVendorName(String vendor) {
        if (vendor == null || vendor.isEmpty()) {
            return "adoptium";
        }
        String lower = vendor.toLowerCase(Locale.ROOT);
        if (lower.equals("temurin") || lower.equals("adoptium")) {
            return "adoptium";
        }
        return lower;
    }

    private static boolean isCleanroom() {
        try {
            Class.forName("com.cleanroommc.boot.Main");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void replaceCerts() {
        if (JavaVersion.parseOrThrow(System.getProperty("java.version")).build() <= 101) {
            try (InputStream is = CleanroomRelauncher.class.getResource("/cacerts").openStream();){
                File cacertsCopy = File.createTempFile("cacerts", "");
                cacertsCopy.deleteOnExit();
                FileUtils.copyInputStreamToFile((InputStream)is, (File)cacertsCopy);
                System.setProperty("javax.net.ssl.trustStore", cacertsCopy.getAbsolutePath());
                LOGGER.info("Successfully replaced CA Certs.");
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to replace CA Certs!", e);
            }
        }
    }

    private static List<CleanroomRelease> releases() {
        try {
            return CleanroomRelease.queryAll();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query Cleanroom's releases and no cached releases found.", e);
        }
    }

    private static List<Version> versions(CleanroomCache cache) {
        try {
            return cache.download();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to grab CleanroomVersion to relaunch.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getOrExtract() {
        String manifestFile = "META-INF/MANIFEST.MF";
        String wrapperDirectory = "wrapper/com/cleanroommc/relauncher/wrapper";
        String wrapperFile = wrapperDirectory + "/RelaunchMainWrapper.class";
        File relauncherJarFile = JavaUtils.jarLocationOf(CleanroomRelauncher.class);
        try (FileSystem containerFs = FileSystems.newFileSystem(relauncherJarFile.toPath(), null);){
            Throwable throwable;
            String originalHash;
            try (InputStream is = Files.newInputStream(containerFs.getPath(manifestFile, new String[0]), new OpenOption[0]);){
                originalHash = new Manifest(is).getMainAttributes().getValue("WrapperHash");
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to read original hash of the wrapper class file", t);
            }
            Path cachedWrapperDirectory = CACHE_DIR.resolve(wrapperDirectory);
            Path cachedWrapperFile = CACHE_DIR.resolve(wrapperFile);
            boolean skip = false;
            if (Files.exists(cachedWrapperFile, new LinkOption[0])) {
                try {
                    throwable = null;
                    try (InputStream is = Files.newInputStream(cachedWrapperFile, new OpenOption[0]);){
                        String cachedHash = DigestUtils.md5Hex((InputStream)is);
                        if (originalHash.equals(cachedHash)) {
                            LOGGER.warn("Hashes matched, no need to copy from jar again.");
                            skip = true;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Unable to calculate MD5 hash to compare.", t);
                }
            }
            if (!skip) {
                if (Files.exists(cachedWrapperDirectory, new LinkOption[0])) {
                    throwable = null;
                    try (Stream<Path> stream = Files.walk(cachedWrapperDirectory, new FileVisitOption[0]);){
                        stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).forEach(File::delete);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                } else {
                    Files.createDirectories(cachedWrapperDirectory, new FileAttribute[0]);
                }
                Path wrapperJarDirectory = containerFs.getPath("/wrapper/", new String[0]);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(wrapperJarDirectory);){
                    for (Path path : stream) {
                        Path to = cachedWrapperFile.resolveSibling(path.getFileName().toString());
                        Files.copy(path, to, new CopyOption[0]);
                        LOGGER.debug("Moved {} to {}", (Object)path.toAbsolutePath().toString(), (Object)to.toAbsolutePath().toString());
                    }
                }
            }
            String string = CACHE_DIR.resolve("wrapper").toAbsolutePath().toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to extract relauncher's jar file", e);
        }
    }

    static void run() {
        boolean shouldShowGui;
        boolean initialSetupNeeded;
        boolean needsNotifyLatest;
        if (CleanroomRelauncher.isCleanroom()) {
            LOGGER.info("Cleanroom detected. No need to relaunch!");
            return;
        }
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String detectedArch = CleanroomRelauncher.detectCurrentArch();
        LOGGER.info("Detected OS: {} ({})", (Object)osName, (Object)osArch);
        LOGGER.info("Hardware Architecture: {}", (Object)detectedArch);
        CleanroomRelauncher.replaceCerts();
        List<CleanroomRelease> releases = CleanroomRelauncher.releases();
        CleanroomRelease latestRelease = releases.get(0);
        LOGGER.info("{} cleanroom releases were queried.", (Object)releases.size());
        CleanroomRelease selected = null;
        String selectedVersion = CONFIG.getCleanroomVersion();
        String notedLatestVersion = CONFIG.getLatestCleanroomVersion();
        String javaPath = CONFIG.getJavaExecutablePath();
        String javaArgs = CONFIG.getJavaArguments();
        boolean autoUpdate = CONFIG.isAutoUpdate();
        boolean bl = needsNotifyLatest = notedLatestVersion == null || !notedLatestVersion.equals(latestRelease.name);
        if (autoUpdate) {
            selected = latestRelease;
            needsNotifyLatest = false;
        } else if (selectedVersion != null) {
            selected = releases.stream().filter(cr -> cr.name.equals(selectedVersion)).findFirst().orElse(null);
        }
        if (javaPath != null && !new File(javaPath).isFile()) {
            javaPath = null;
        }
        boolean didAutoSetup = false;
        final AtomicReference<Object> setupDialogRef = new AtomicReference<Object>(null);
        final int desiredJava = CONFIG.getJavaVersion();
        final String desiredVendor = CleanroomRelauncher.normalizeVendorName(CONFIG.getJavaVendor());
        Integer currentJavaFromPath = CleanroomRelauncher.extractTemurinMajorFromPath(javaPath);
        if (javaPath != null && (currentJavaFromPath == null || currentJavaFromPath != desiredJava)) {
            LOGGER.info("Configured Java version {} differs from current Java path ({}). Switching to {} {}...", (Object)desiredJava, (Object)javaPath, (Object)desiredVendor, (Object)desiredJava);
            javaPath = null;
        }
        String currentVendorFromPath = CleanroomRelauncher.normalizeVendorName(CleanroomRelauncher.extractVendorFromPath(javaPath));
        if (javaPath != null && currentVendorFromPath != null && !currentVendorFromPath.equalsIgnoreCase(desiredVendor)) {
            LOGGER.info("Configured Java vendor '{}' differs from current vendor '{}' at {}. Switching vendor and re-downloading if necessary...", (Object)desiredVendor, (Object)currentVendorFromPath, (Object)javaPath);
            javaPath = null;
        }
        String currentArchFromPath = CleanroomRelauncher.extractArchFromPath(javaPath);
        String currentArch = CleanroomRelauncher.detectCurrentArch();
        if (javaPath != null && currentArchFromPath != null && !currentArchFromPath.equalsIgnoreCase(currentArch)) {
            LOGGER.info("Configured Java architecture '{}' differs from current hardware architecture '{}' at {}. Switching to native architecture and re-downloading...", (Object)currentArchFromPath, (Object)currentArch, (Object)javaPath);
            javaPath = null;
        }
        boolean bl2 = initialSetupNeeded = selected == null || javaPath == null;
        if (initialSetupNeeded) {
            SetupProgressDialog dlg;
            didAutoSetup = true;
            if (selected == null) {
                LOGGER.info("No Cleanroom version selected. Auto-selecting latest release {}.", (Object)latestRelease.name);
                selected = latestRelease;
            }
            if (javaPath == null) {
                LOGGER.info("No Java path configured. Preparing Java {} for this OS (auto-download)...", (Object)desiredJava);
                dlg = SetupProgressDialog.show("Setting Up Necessary Libraries (Only Happens Once)");
                setupDialogRef.set(dlg);
                String vendorName = desiredVendor != null && desiredVendor.equalsIgnoreCase("graalvm") ? "GraalVM" : "Temurin";
                dlg.setMessage("Downloading Java " + desiredJava + " (" + vendorName + ")...");
                dlg.setIndeterminate(true);
                try {
                    String os = System.getProperty("os.name").toLowerCase(Locale.ROOT);
                    if (os.contains("win")) {
                        javaPath = JavaDownloader.ensureWindowsJava(CACHE_DIR.resolve("java"), desiredJava, desiredVendor, new JavaDownloader.ProgressListener(){
                            private long total = -1L;
                            private final CalculationUtilities.DownloadSpeedCalculator speedCalc = new CalculationUtilities.DownloadSpeedCalculator();

                            @Override
                            public void onStart(long totalBytes) {
                                this.total = totalBytes;
                                this.speedCalc.reset();
                                SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                if (dlg != null) {
                                    if (totalBytes > 0L) {
                                        dlg.setIndeterminate(false);
                                        dlg.setProgress(0, "0 B/s  ETA --:--");
                                    } else {
                                        dlg.setIndeterminate(true);
                                    }
                                }
                            }

                            @Override
                            public void onProgress(long downloadedBytes, long totalBytes) {
                                if (this.total > 0L) {
                                    int pct = (int)(downloadedBytes * 100L / this.total);
                                    SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                    if (dlg != null) {
                                        double speed = this.speedCalc.calculateSpeed(downloadedBytes);
                                        long eta = this.speedCalc.calculateSmoothedETA(this.total, downloadedBytes, speed);
                                        dlg.setIndeterminate(false);
                                        dlg.setProgressPercent(pct);
                                        dlg.setMessage(String.format("Downloading Java %d (%s) - %s - ETA: %s", desiredJava, desiredVendor, CalculationUtilities.formatSpeed(speed), CalculationUtilities.formatETA(eta)));
                                    }
                                }
                            }

                            @Override
                            public void onRetryScheduled(int attempt, int maxAttempts, long delayMs) {
                                SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                if (dlg != null) {
                                    int secs = (int)Math.ceil((double)delayMs / 1000.0);
                                    String text = String.format(Locale.ROOT, "Retry %d/%d in %ds", attempt, maxAttempts, secs);
                                    dlg.setProgress(0, text);
                                }
                            }
                        });
                    } else if (os.contains("mac")) {
                        javaPath = JavaDownloader.ensureMacJava(CACHE_DIR.resolve("java"), desiredJava, desiredVendor, new JavaDownloader.ProgressListener(){
                            private CalculationUtilities.DownloadSpeedCalculator speedCalculator = new CalculationUtilities.DownloadSpeedCalculator();
                            private long total = -1L;

                            @Override
                            public void onStart(long totalBytes) {
                                this.total = totalBytes;
                                this.speedCalculator.reset();
                                SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                if (dlg != null) {
                                    if (totalBytes > 0L) {
                                        dlg.setIndeterminate(false);
                                        dlg.setProgress(0, "0 B/s  ETA --:--");
                                    } else {
                                        dlg.setIndeterminate(true);
                                    }
                                }
                            }

                            @Override
                            public void onProgress(long downloadedBytes, long totalBytes) {
                                if (this.total > 0L) {
                                    int pct = (int)(downloadedBytes * 100L / this.total);
                                    SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                    if (dlg != null) {
                                        double speed = this.speedCalculator.calculateSpeed(downloadedBytes);
                                        long eta = this.speedCalculator.calculateSmoothedETA(this.total, downloadedBytes, speed);
                                        dlg.setIndeterminate(false);
                                        dlg.setProgressPercent(pct);
                                        dlg.setMessage(String.format("Downloading Java %d (%s) - %s - ETA: %s", desiredJava, desiredVendor, CalculationUtilities.formatSpeed(speed), CalculationUtilities.formatETA(eta)));
                                    }
                                }
                            }

                            @Override
                            public void onRetryScheduled(int attempt, int maxAttempts, long delayMs) {
                                SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                if (dlg != null) {
                                    int secs = (int)Math.ceil((double)delayMs / 1000.0);
                                    String text = String.format(Locale.ROOT, "Retry %d/%d in %ds", attempt, maxAttempts, secs);
                                    dlg.setProgress(0, text);
                                }
                            }
                        });
                    } else if (os.contains("nux") || os.contains("nix") || os.contains("aix") || os.contains("linux")) {
                        javaPath = JavaDownloader.ensureLinuxJava(CACHE_DIR.resolve("java"), desiredJava, desiredVendor, new JavaDownloader.ProgressListener(){
                            private CalculationUtilities.DownloadSpeedCalculator speedCalculator = new CalculationUtilities.DownloadSpeedCalculator();
                            private long total = -1L;

                            @Override
                            public void onStart(long totalBytes) {
                                this.total = totalBytes;
                                this.speedCalculator.reset();
                                SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                if (dlg != null) {
                                    if (totalBytes > 0L) {
                                        dlg.setIndeterminate(false);
                                        dlg.setProgress(0, "0 B/s  ETA --:--");
                                    } else {
                                        dlg.setIndeterminate(true);
                                    }
                                }
                            }

                            @Override
                            public void onProgress(long downloadedBytes, long totalBytes) {
                                if (this.total > 0L) {
                                    int pct = (int)(downloadedBytes * 100L / this.total);
                                    SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                    if (dlg != null) {
                                        double speed = this.speedCalculator.calculateSpeed(downloadedBytes);
                                        long eta = this.speedCalculator.calculateSmoothedETA(this.total, downloadedBytes, speed);
                                        dlg.setIndeterminate(false);
                                        dlg.setProgressPercent(pct);
                                        dlg.setMessage(String.format("Downloading Java %d (%s) - %s - ETA: %s", desiredJava, desiredVendor, CalculationUtilities.formatSpeed(speed), CalculationUtilities.formatETA(eta)));
                                    }
                                }
                            }

                            @Override
                            public void onRetryScheduled(int attempt, int maxAttempts, long delayMs) {
                                SetupProgressDialog dlg = (SetupProgressDialog)setupDialogRef.get();
                                if (dlg != null) {
                                    int secs = (int)Math.ceil((double)delayMs / 1000.0);
                                    String text = String.format(Locale.ROOT, "Retry %d/%d in %ds", attempt, maxAttempts, secs);
                                    dlg.setProgress(0, text);
                                }
                            }
                        });
                    } else {
                        LOGGER.warn("Auto Temurin Java download is not implemented for this OS: {}. Falling back to manual selection.", (Object)os);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Failed to auto-download Java {}: {}", (Object)desiredJava, (Object)e.toString());
                }
            }
            if (selected != null) {
                CONFIG.setCleanroomVersion(selected.name);
            }
            CONFIG.setLatestCleanroomVersion(latestRelease.name);
            if (javaPath != null) {
                CONFIG.setJavaExecutablePath(javaPath);
            }
            CONFIG.setJavaArguments(javaArgs);
            CONFIG.setJavaVersion(CONFIG.getJavaVersion());
            CONFIG.setJavaVendor(CONFIG.getJavaVendor());
            CONFIG.save();
            if (javaPath == null && (dlg = (SetupProgressDialog)setupDialogRef.getAndSet(null)) != null) {
                dlg.close();
            }
        }
        boolean bl3 = shouldShowGui = selected == null || javaPath == null || !didAutoSetup && needsNotifyLatest && !autoUpdate;
        if (shouldShowGui) {
            SetupProgressDialog dlg = setupDialogRef.getAndSet(null);
            if (dlg != null) {
                dlg.close();
            }
            CleanroomRelease fSelected = selected;
            String fJavaPath = javaPath;
            String fJavaArgs = javaArgs;
            RelauncherGUI gui = RelauncherGUI.show(releases, $ -> {
                $.selected = fSelected;
                $.javaPath = fJavaPath;
                $.javaArgs = fJavaArgs;
                $.autoUpdate = CONFIG.isAutoUpdate();
            });
            selected = gui.selected;
            javaPath = gui.javaPath;
            javaArgs = gui.javaArgs;
            if (gui.autoUpdate) {
                selected = latestRelease;
            }
            CONFIG.setCleanroomVersion(selected.name);
            CONFIG.setLatestCleanroomVersion(latestRelease.name);
            CONFIG.setJavaExecutablePath(javaPath);
            CONFIG.setJavaArguments(javaArgs);
            CONFIG.setAutoUpdate(gui.autoUpdate);
            CONFIG.save();
        }
        if (!didAutoSetup && !shouldShowGui && selected != null) {
            CONFIG.setCleanroomVersion(selected.name);
            CONFIG.setLatestCleanroomVersion(latestRelease.name);
            if (javaPath != null) {
                CONFIG.setJavaExecutablePath(javaPath);
            }
            CONFIG.setJavaArguments(javaArgs);
            CONFIG.save();
        }
        CleanroomCache releaseCache = CleanroomCache.of(selected);
        LOGGER.info("Preparing Cleanroom v{} and its libraries...", (Object)selected.name);
        SetupProgressDialog dlg = setupDialogRef.get();
        if (dlg == null) {
            dlg = SetupProgressDialog.show("Setting Up Necessary Libraries (Only Happens Once)");
            setupDialogRef.set(dlg);
        }
        dlg.setMessage("Downloading Cleanroom libraries...");
        dlg.setIndeterminate(false);
        dlg.setProgressPercent(0);
        final SetupProgressDialog finalDlg = dlg;
        GlobalDownloader.INSTANCE.setProgressListener(new GlobalDownloader.TaskProgressListener(){
            private int totalFiles = 0;
            private long totalBytes = 0L;

            @Override
            public void onTotal(int totalFiles, long totalBytes) {
                this.totalFiles = Math.max(1, totalFiles);
                this.totalBytes = totalBytes;
                finalDlg.setProgressPercent(0);
            }

            @Override
            public void onProgress(int completedFiles, int totalFiles, long downloadedBytes, long totalBytes, double speed, long eta) {
                int pct = totalBytes > 0L ? (int)(downloadedBytes * 100L / totalBytes) : (int)((float)completedFiles * 100.0f / (float)Math.max(1, totalFiles));
                finalDlg.setProgressPercent(pct);
                if (totalBytes > 0L && speed > 0.0) {
                    finalDlg.setMessage(String.format("Downloading libraries - %d/%d files - %s - ETA: %s", completedFiles, totalFiles, CalculationUtilities.formatSpeed(speed), CalculationUtilities.formatETA(eta)));
                } else {
                    finalDlg.setMessage(String.format("Downloading libraries - %d/%d files", completedFiles, totalFiles));
                }
            }
        });
        List<Version> versions = CleanroomRelauncher.versions(releaseCache);
        GlobalDownloader.INSTANCE.setProgressListener(null);
        SetupProgressDialog closeDlg = setupDialogRef.getAndSet(null);
        if (closeDlg != null) {
            closeDlg.close();
        }
        String wrapperClassPath = CleanroomRelauncher.getOrExtract();
        LOGGER.info("Preparing to relaunch Cleanroom v{}", (Object)selected.name);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(javaPath);
        arguments.add("-cp");
        String libraryClassPath = versions.stream().map(version -> version.libraryPaths).flatMap(Collection::stream).collect(Collectors.joining(File.pathSeparator));
        String fullClassPath = wrapperClassPath + File.pathSeparator + libraryClassPath;
        arguments.add(fullClassPath);
        if (javaArgs != null && !javaArgs.isEmpty()) {
            Arrays.stream(javaArgs.split(" ")).map(String::trim).forEach(arguments::add);
        }
        for (String string : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (string.startsWith("-Xms") && arguments.stream().noneMatch(arg -> arg.startsWith("-Xms"))) {
                arguments.add(string);
            }
            if (!string.startsWith("-Xmx") || !arguments.stream().noneMatch(arg -> arg.startsWith("-Xmx"))) continue;
            arguments.add(string);
        }
        arguments.add("-Dcleanroom.relauncher.parent=" + ProcessIdUtil.getProcessId());
        arguments.add("-Dcleanroom.relauncher.mainClass=" + versions.get((int)0).mainClass);
        arguments.add("-Djava.library.path=" + versions.stream().map(version -> version.nativesPaths).flatMap(Collection::stream).collect(Collectors.joining(File.pathSeparator)));
        arguments.add("com.cleanroommc.relauncher.wrapper.RelaunchMainWrapper");
        for (Map.Entry entry : ((Map)Launch.blackboard.get("launchArgs")).entrySet()) {
            arguments.add((String)entry.getKey());
            arguments.add((String)entry.getValue());
        }
        arguments.add("--tweakClass");
        arguments.add("net.minecraftforge.fml.common.launcher.FMLTweaker");
        LOGGER.debug("Relauncher arguments:");
        for (String string : arguments) {
            LOGGER.debug(string);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        processBuilder.directory(null);
        processBuilder.inheritIO();
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            LOGGER.info("Process exited with code: {}", (Object)exitCode);
            ExitVMBypass.exit(exitCode);
        }
        catch (IOException | InterruptedException exception) {
            throw new RuntimeException(exception);
        }
    }
}

