/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download;

import java.util.LinkedList;
import java.util.Locale;

public final class CalculationUtilities {
    private CalculationUtilities() {
    }

    public static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "iB";
        return String.format(Locale.ROOT, "%.1f %s", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    public static String formatSpeed(double bytesPerSecond) {
        return CalculationUtilities.formatBytes((long)bytesPerSecond) + "/s";
    }

    public static String formatETA(long seconds) {
        if (seconds < 0L) {
            return "--:--";
        }
        long m = seconds / 60L;
        long s = seconds % 60L;
        return String.format(Locale.ROOT, "%02d:%02d", m, s);
    }

    public static class DownloadSpeedCalculator {
        private final LinkedList<long[]> samples = new LinkedList();
        private static final long WINDOW_NS = 10000000000L;
        private double smoothedETA = -1.0;
        private static final double ETA_SMOOTHING_ALPHA = 0.05;

        public synchronized void reset() {
            this.samples.clear();
            this.smoothedETA = -1.0;
        }

        public synchronized double calculateSpeed(long downloadedBytes) {
            long nowNs = System.nanoTime();
            this.samples.add(new long[]{nowNs, downloadedBytes});
            while (!this.samples.isEmpty() && nowNs - this.samples.getFirst()[0] > 10000000000L) {
                this.samples.removeFirst();
            }
            if (this.samples.size() > 1) {
                long[] oldest = this.samples.getFirst();
                long elapsedNs = nowNs - oldest[0];
                long bytesInWindow = downloadedBytes - oldest[1];
                double elapsedSec = (double)elapsedNs / 1.0E9;
                if (elapsedSec > 0.0) {
                    return (double)bytesInWindow / elapsedSec;
                }
            }
            return 0.0;
        }

        public synchronized long calculateSmoothedETA(long totalBytes, long downloadedBytes, double speed) {
            if (speed <= 0.0) {
                return -1L;
            }
            long remaining = Math.max(0L, totalBytes - downloadedBytes);
            double rawETA = (double)remaining / speed;
            this.smoothedETA = this.smoothedETA < 0.0 ? rawETA : 0.05 * rawETA + 0.95 * this.smoothedETA;
            return (long)Math.ceil(this.smoothedETA);
        }
    }
}

