/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download;

import com.cleanroommc.relauncher.download.CleanroomZipArtifact;
import com.cleanroommc.relauncher.download.GlobalDownloader;
import com.cleanroommc.relauncher.download.cache.CleanroomCache;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;

public class CleanroomInstaller
implements CleanroomZipArtifact {
    private final String version;
    private final Path location;

    public static CleanroomInstaller of(String version, Path location) {
        return new CleanroomInstaller(version, location);
    }

    private CleanroomInstaller(String version, Path location) {
        this.version = version;
        this.location = location;
    }

    @Override
    public void install(String url) {
        if (!Files.exists(this.location, new LinkOption[0])) {
            GlobalDownloader.INSTANCE.immediatelyFrom(url, this.location.toFile());
        }
    }

    @Override
    public void extract(CleanroomCache cache) throws IOException {
        try (FileSystem jar = FileSystems.newFileSystem(this.location, null);){
            Path universalJarPath;
            Path versionJsonPath = jar.getPath("/version.json", new String[0]);
            if (versionJsonPath != null && Files.exists(versionJsonPath, new LinkOption[0])) {
                Files.copy(versionJsonPath, cache.getVersionJson(), StandardCopyOption.REPLACE_EXISTING);
            }
            if ((universalJarPath = jar.getPath("/maven/com/cleanroommc/cleanroom/" + this.version + "/cleanroom-" + this.version + ".jar", new String[0])) != null && Files.exists(universalJarPath, new LinkOption[0])) {
                Files.copy(universalJarPath, cache.getUniversalJar(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

