/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download;

import com.cleanroommc.relauncher.download.CleanroomZipArtifact;
import com.cleanroommc.relauncher.download.GlobalDownloader;
import com.cleanroommc.relauncher.download.cache.CleanroomCache;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Optional;
import java.util.stream.Stream;

@Deprecated
public class CleanroomMultiMcPack
implements CleanroomZipArtifact {
    private final String version;
    private final Path location;

    public static CleanroomMultiMcPack of(String version, Path location) {
        return new CleanroomMultiMcPack(version, location);
    }

    private CleanroomMultiMcPack(String version, Path location) {
        this.version = version;
        this.location = location;
    }

    @Override
    public void install(String url) throws IOException {
        if (!Files.exists(this.location, new LinkOption[0])) {
            GlobalDownloader.INSTANCE.immediatelyFrom(url, this.location.toFile());
        }
    }

    @Override
    public void extract(CleanroomCache cache) throws IOException {
        try (FileSystem jar = FileSystems.newFileSystem(this.location, null);){
            Files.copy(jar.getPath("/patches/net.minecraft.json", new String[0]), cache.getMinecraftJson(), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(jar.getPath("/patches/net.minecraftforge.json", new String[0]), cache.getForgeJson(), StandardCopyOption.REPLACE_EXISTING);
            Files.copy(jar.getPath("/patches/org.lwjgl3.json", new String[0]), cache.getLwjglVersionJson(), StandardCopyOption.REPLACE_EXISTING);
            try (Stream<Path> stream = Files.walk(jar.getPath("/libraries/", new String[0]), new FileVisitOption[0]);){
                Optional<Path> universalJar = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst();
                if (universalJar.isPresent()) {
                    Files.copy(universalJar.get(), cache.getUniversalJar(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }
}

