/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.cleanroommc.relauncher.download.CalculationUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public final class GlobalDownloader {
    public static final GlobalDownloader INSTANCE = new GlobalDownloader();
    private static final int MAX_DOWNLOAD_THREADS = 8;
    private static final int MAX_RETRIES = 3;
    private static final int CONNECT_TIMEOUT_MS = 30000;
    private static final int READ_TIMEOUT_MS = 120000;
    private static final String USER_AGENT = "Mozilla/5.0 CleanroomRelauncher/1.0";
    private final Set<String> queuedFiles = Collections.synchronizedSet(new HashSet());
    private final List<DownloadTask> downloadTasks = Collections.synchronizedList(new ArrayList());
    private volatile TaskProgressListener progressListener;
    private final AtomicLong totalBytesAcrossFiles = new AtomicLong(0L);
    private final AtomicLong downloadedBytesAcrossFiles = new AtomicLong(0L);
    private final CalculationUtilities.DownloadSpeedCalculator speedCalculator = new CalculationUtilities.DownloadSpeedCalculator();

    public void setProgressListener(TaskProgressListener listener) {
        this.progressListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void from(String source, File destination) {
        String destPath = destination.getAbsolutePath();
        Set<String> set = this.queuedFiles;
        synchronized (set) {
            if (this.queuedFiles.contains(destPath)) {
                CleanroomRelauncher.LOGGER.debug("Skipping duplicate download: {}", (Object)destPath);
                return;
            }
            this.queuedFiles.add(destPath);
        }
        DownloadTask task = new DownloadTask(source, destination);
        this.downloadTasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediatelyFrom(String source, File destination) {
        String destPath = destination.getAbsolutePath();
        Set<String> set = this.queuedFiles;
        synchronized (set) {
            if (this.queuedFiles.contains(destPath)) {
                CleanroomRelauncher.LOGGER.debug("File already queued: {}", (Object)destPath);
                return;
            }
            this.queuedFiles.add(destPath);
        }
        try {
            GlobalDownloader.downloadFile(source, destination.toPath(), 3, null);
            CleanroomRelauncher.LOGGER.debug("Downloaded {} to {}", (Object)source, (Object)destPath);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to download %s to %s", source, destination), e);
        }
    }

    public void blockUntilFinished() {
        int totalTasks = this.downloadTasks.size();
        if (totalTasks == 0) {
            CleanroomRelauncher.LOGGER.info("No library downloads queued, all files already cached");
            return;
        }
        CleanroomRelauncher.LOGGER.info("Starting download of {} library files...", (Object)totalTasks);
        this.cleanupStaleTempFiles();
        this.totalBytesAcrossFiles.set(0L);
        this.downloadedBytesAcrossFiles.set(0L);
        this.speedCalculator.reset();
        TaskProgressListener listener = this.progressListener;
        int cores = Math.max(1, Runtime.getRuntime().availableProcessors());
        int threads = Math.min(8, cores * 2);
        ExecutorService sizeCheckExecutor = Executors.newFixedThreadPool(threads);
        ArrayList<Future<Long>> sizeFutures = new ArrayList<Future<Long>>();
        for (DownloadTask downloadTask : this.downloadTasks) {
            sizeFutures.add(sizeCheckExecutor.submit(() -> GlobalDownloader.getFileSize(task.source)));
        }
        sizeCheckExecutor.shutdown();
        for (Future future : sizeFutures) {
            try {
                long size = (Long)future.get();
                if (size <= 0L) continue;
                this.totalBytesAcrossFiles.addAndGet(size);
            }
            catch (Exception e) {
                CleanroomRelauncher.LOGGER.debug("Failed to get file size: {}", (Object)e.toString());
            }
        }
        long totalBytes = this.totalBytesAcrossFiles.get();
        if (listener != null) {
            listener.onTotal(totalTasks, totalBytes);
        }
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        AtomicInteger completed = new AtomicInteger(0);
        AtomicInteger lastReported = new AtomicInteger(0);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        ProgressCallback progressCallback = bytesDownloaded -> {
            long current = this.downloadedBytesAcrossFiles.addAndGet(bytesDownloaded);
            if (listener != null && totalBytes > 0L) {
                double speed = this.speedCalculator.calculateSpeed(current);
                long eta = this.speedCalculator.calculateSmoothedETA(totalBytes, current, speed);
                listener.onProgress(completed.get(), totalTasks, current, totalBytes, speed, eta);
            }
        };
        for (DownloadTask downloadTask : this.downloadTasks) {
            futures.add(executor.submit(() -> {
                try {
                    GlobalDownloader.downloadFile(task.source, task.destination.toPath(), 3, progressCallback);
                    int nowCompleted = completed.incrementAndGet();
                    int percentage = nowCompleted * 100 / totalTasks;
                    int last = lastReported.get();
                    if (percentage % 10 == 0 && percentage != last && lastReported.compareAndSet(last, percentage)) {
                        CleanroomRelauncher.LOGGER.info("Download Progress: {} / {} files | {}% completed.", (Object)nowCompleted, (Object)totalTasks, (Object)percentage);
                    }
                    CleanroomRelauncher.LOGGER.debug("Downloaded {} to {}", (Object)task.source, (Object)task.destination.getAbsolutePath());
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("Failed to download %s to %s", task.source, task.destination), e);
                }
                return null;
            }));
        }
        executor.shutdown();
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                executor.shutdownNow();
                throw new RuntimeException("Download interrupted", e);
            }
            catch (ExecutionException e) {
                executor.shutdownNow();
                throw new RuntimeException("Download failed", e.getCause());
            }
        }
        try {
            if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    CleanroomRelauncher.LOGGER.error("Executor did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        CleanroomRelauncher.LOGGER.info("All {} library files downloaded successfully", (Object)totalTasks);
        this.downloadTasks.clear();
        this.queuedFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long getFileSize(String urlStr) {
        block9: {
            HttpURLConnection conn = null;
            try {
                URL url = new URL(urlStr);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("HEAD");
                conn.setConnectTimeout(15000);
                conn.setReadTimeout(15000);
                conn.setRequestProperty("User-Agent", USER_AGENT);
                int code = conn.getResponseCode();
                if (code == 200) {
                    try {
                        long l = Long.parseLong(conn.getHeaderField("Content-Length"));
                        return l;
                    }
                    catch (Exception exception) {}
                }
                break block9;
                {
                    catch (Exception exception2) {
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void downloadFile(String urlStr, Path dest, int maxRetries, ProgressCallback progressCallback) throws IOException {
        IOException lastException = null;
        for (int attempt = 0; attempt <= maxRetries; ++attempt) {
            try {
                Files.createDirectories(dest.getParent(), new FileAttribute[0]);
                URL url = new URL(urlStr);
                HttpURLConnection conn = null;
                try {
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(30000);
                    conn.setReadTimeout(120000);
                    conn.setRequestProperty("User-Agent", USER_AGENT);
                    int code = conn.getResponseCode();
                    if (code != 200) {
                        throw new IOException("HTTP " + code + " from " + urlStr);
                    }
                    long expectedSize = -1L;
                    try {
                        expectedSize = Long.parseLong(conn.getHeaderField("Content-Length"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Path temp = dest.resolveSibling(dest.getFileName().toString() + ".tmp");
                    try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                         BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(temp, new OpenOption[0]));){
                        int n;
                        byte[] buffer = new byte[8192];
                        long downloaded = 0L;
                        while ((n = ((InputStream)in).read(buffer)) >= 0) {
                            ((OutputStream)out).write(buffer, 0, n);
                            downloaded += (long)n;
                            if (progressCallback == null) continue;
                            progressCallback.onProgress(n);
                        }
                        if (expectedSize > 0L && downloaded != expectedSize) {
                            throw new IOException(String.format("Size mismatch: expected %d bytes, got %d bytes", expectedSize, downloaded));
                        }
                    }
                    Files.move(temp, dest, StandardCopyOption.REPLACE_EXISTING);
                    return;
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            catch (IOException e) {
                lastException = e;
                if (attempt >= maxRetries) continue;
                long backoff = (long)(1000.0 * Math.pow(2.0, attempt));
                try {
                    Thread.sleep(backoff);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Download interrupted during retry", ie);
                }
            }
        }
        throw lastException != null ? lastException : new IOException("Download failed: " + urlStr);
    }

    private void cleanupStaleTempFiles() {
        HashSet<Path> currentDirs = new HashSet<Path>();
        for (DownloadTask task : this.downloadTasks) {
            Path parent = task.destination.toPath().getParent();
            if (parent == null) continue;
            currentDirs.add(parent);
        }
        for (Path dir : currentDirs) {
            if (!Files.exists(dir, new LinkOption[0])) continue;
            HashSet<String> currentFiles = new HashSet<String>();
            for (DownloadTask task : this.downloadTasks) {
                if (!task.destination.toPath().getParent().equals(dir)) continue;
                currentFiles.add(task.destination.getName());
            }
            try {
                Stream<Path> files = Files.list(dir);
                Throwable throwable = null;
                try {
                    files.filter(path -> {
                        String name = path.getFileName().toString();
                        if (!name.endsWith(".tmp")) {
                            return false;
                        }
                        String baseName = name.substring(0, name.length() - 4);
                        return !currentFiles.contains(baseName);
                    }).forEach(staleFile -> {
                        try {
                            Files.deleteIfExists(staleFile);
                            CleanroomRelauncher.LOGGER.info("Cleaned up stale temp file: {}", (Object)staleFile.getFileName());
                        }
                        catch (IOException e) {
                            CleanroomRelauncher.LOGGER.debug("Failed to delete stale temp file {}: {}", (Object)staleFile.getFileName(), (Object)e.toString());
                        }
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (files == null) continue;
                    if (throwable != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    files.close();
                }
            }
            catch (IOException e) {
                CleanroomRelauncher.LOGGER.debug("Failed to list directory {} for cleanup: {}", (Object)dir, (Object)e.toString());
            }
        }
    }

    private static class DownloadTask {
        final String source;
        final File destination;

        DownloadTask(String source, File destination) {
            this.source = source;
            this.destination = destination;
        }
    }

    @FunctionalInterface
    private static interface ProgressCallback {
        public void onProgress(long var1);
    }

    public static interface TaskProgressListener {
        public void onTotal(int var1, long var2);

        public void onProgress(int var1, int var2, long var3, long var5, double var7, long var9);
    }
}

