/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download.cache;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public final class CacheVerification {
    private CacheVerification() {
    }

    public static boolean verifyJavaArchive(Path archive) {
        if (archive == null || !Files.isRegularFile(archive, new LinkOption[0])) {
            return false;
        }
        String name = archive.getFileName().toString().toLowerCase();
        try {
            if (name.endsWith(".zip")) {
                return CacheVerification.verifyZip(archive);
            }
            if (name.endsWith(".tar.gz")) {
                return CacheVerification.verifyTarGz(archive);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean verifyZip(Path zipPath) throws IOException {
        try (ZipFile zf = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            byte[] buf = new byte[8192];
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                if (ze.isDirectory()) continue;
                BufferedInputStream in = new BufferedInputStream(zf.getInputStream(ze));
                Throwable throwable = null;
                try {
                    int n;
                    long read = 0L;
                    while ((n = ((InputStream)in).read(buf)) >= 0) {
                        read += (long)n;
                    }
                    if (read >= 0L) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)in).close();
                }
            }
        }
        return true;
    }

    private static boolean verifyTarGz(Path tarGzPath) throws IOException {
        try (InputStream fis = Files.newInputStream(tarGzPath, new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(fis);
             GzipCompressorInputStream gis = new GzipCompressorInputStream((InputStream)bis);
             TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)gis);){
            TarArchiveEntry entry;
            byte[] buf = new byte[8192];
            while ((entry = tis.getNextTarEntry()) != null) {
                int n;
                if (entry.isDirectory()) continue;
                long toRead = entry.getSize();
                if (toRead < 0L) {
                    toRead = Long.MAX_VALUE;
                }
                while (toRead > 0L && (n = tis.read(buf, 0, (int)Math.min((long)buf.length, Math.max(1L, Math.min(toRead, (long)buf.length))))) >= 0) {
                    toRead -= (long)n;
                }
            }
        }
        return true;
    }
}

