/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.javautils.locators;

import com.cleanroommc.relauncher.shade.javautils.api.JavaInstall;
import com.cleanroommc.relauncher.shade.javautils.api.JavaVendor;
import com.cleanroommc.relauncher.shade.javautils.locators.AbstractJavaLocator;
import com.cleanroommc.relauncher.shade.platformutils.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DefaultInstalledJavaLocator
extends AbstractJavaLocator {
    @Override
    protected List<JavaInstall> initialize() {
        ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
        switch (Platform.current().operatingSystem()) {
            case WINDOWS: {
                this.windows(installs);
                break;
            }
            case MAC_OS: {
                this.macOs(installs);
                break;
            }
            default: {
                this.linux(installs);
            }
        }
        return installs;
    }

    private void windows(List<JavaInstall> installs) {
        ArrayList<File> locations = new ArrayList<File>();
        String programFiles = DefaultInstalledJavaLocator.env("ProgramFiles");
        if (programFiles != null) {
            locations.add(new File(programFiles));
        }
        if ((programFiles = DefaultInstalledJavaLocator.env("ProgramFiles(x86)")) != null) {
            locations.add(new File(programFiles));
        }
        if ((programFiles = DefaultInstalledJavaLocator.env("ProgramFiles(Arm)")) != null) {
            locations.add(new File(programFiles));
        }
        locations.add(new File(DefaultInstalledJavaLocator.env("LOCALAPPDATA") + "/Programs/"));
        for (File directory : locations) {
            String[] subDirectories;
            if (!directory.exists() || (subDirectories = directory.list()) == null) continue;
            for (String dirName : subDirectories) {
                if (JavaVendor.find(dirName) == JavaVendor.UNKNOWN) continue;
                DefaultInstalledJavaLocator.deepScanForInstalls(new File(directory, dirName), installs);
            }
        }
    }

    private void macOs(List<JavaInstall> installs) {
        File xCode;
        File jvms = new File("/Library/Java/JavaVirtualMachines/");
        File homeJvms = new File(DefaultInstalledJavaLocator.userHome("Library/Java/JavaVirtualMachines/"));
        for (File directory : new File[]{jvms, homeJvms}) {
            File home;
            if (!directory.exists() || !(home = new File(directory, "Contents/Home/bin/java")).exists()) continue;
            DefaultInstalledJavaLocator.parseOrLog(installs, home);
        }
        File javaApplet = new File("/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java");
        if (javaApplet.exists()) {
            DefaultInstalledJavaLocator.parseOrLog(installs, javaApplet);
        }
        if ((xCode = new File("/Applications/Xcode.app/Contents/Applications/Application Loader.app/Contents/MacOS/itms/java/bin/java")).exists()) {
            DefaultInstalledJavaLocator.parseOrLog(installs, xCode);
        }
    }

    private void linux(List<JavaInstall> installs) {
        for (String directoryName : new String[]{"/usr/java", "/usr/lib/jvm", "/usr/lib32/jvm", "/usr/lib64/jvm", "/usr/local", "/opt", "/app/jdk", "/opt/jdk", "/opt/jdks"}) {
            DefaultInstalledJavaLocator.deepScanForInstalls(new File(directoryName), installs);
        }
    }
}

