/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.download.java;

import com.cleanroommc.relauncher.CleanroomRelauncher;
import com.cleanroommc.relauncher.download.cache.CacheVerification;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public final class JavaDownloader {
    public static final int MINIMUM_JAVA_VERSION = 21;
    public static final int DEFAULT_JAVA_VERSION = 24;
    private static final int MAX_DOWNLOAD_RETRIES = 3;
    private static final long CHUNK_SIZE = 0x400000L;
    private static final int CHUNK_TIMEOUT_MINUTES = 10;
    private static final int CHUNK_RETRY_ATTEMPTS = 3;
    private static final int CONNECT_TIMEOUT_MS = 30000;
    private static final int READ_TIMEOUT_MS = 120000;
    private static final int REDIRECT_LIMIT = 7;
    private static final int TEST_RANGE_TIMEOUT_MS = 15000;
    private static final String USER_AGENT = "Mozilla/5.0 CleanroomRelauncher/1.0";

    private JavaDownloader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String detectArch() {
        String arch;
        String osName = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        if (osName.contains("mac")) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"uname", "-m"});
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line = reader.readLine();
                    if (line != null && ((line = line.trim().toLowerCase(Locale.ROOT)).equals("arm64") || line.equals("aarch64"))) {
                        String string = "aarch64";
                        return string;
                    }
                }
                process.waitFor();
            }
            catch (Exception e) {
                CleanroomRelauncher.LOGGER.warn("Failed to detect Mac architecture via uname, falling back to os.arch: {}", (Object)e.toString());
            }
        }
        if ((arch = System.getProperty("os.arch", "").toLowerCase(Locale.ROOT)).contains("aarch64")) return "aarch64";
        if (arch.contains("arm64")) return "aarch64";
        return "x64";
    }

    public static String ensureWindowsJava(Path baseDir, int majorVersion, String vendor, ProgressListener progressListener) throws IOException {
        return JavaDownloader.ensureJava(baseDir, majorVersion, vendor, progressListener, "windows", ".zip");
    }

    public static String ensureLinuxJava(Path baseDir, int majorVersion, String vendor, ProgressListener progressListener) throws IOException {
        return JavaDownloader.ensureJava(baseDir, majorVersion, vendor, progressListener, "linux", ".tar.gz");
    }

    public static String ensureMacJava(Path baseDir, int majorVersion, String vendor, ProgressListener progressListener) throws IOException {
        return JavaDownloader.ensureJava(baseDir, majorVersion, vendor, progressListener, "mac", ".tar.gz");
    }

    private static String ensureJava(Path baseDir, int majorVersion, String vendor, ProgressListener progressListener, String os, String archiveExt) throws IOException {
        Path javaBin;
        if (majorVersion <= 0) {
            majorVersion = 24;
        }
        String arch = JavaDownloader.detectArch();
        Path temDir = baseDir.resolve(String.format("temurin-%d-%s-%s", majorVersion, os, arch));
        Path graDir = baseDir.resolve(String.format("graalvm-%d-%s-%s", majorVersion, os, arch));
        boolean wantGraal = vendor != null && vendor.equalsIgnoreCase("graalvm");
        Path path = javaBin = wantGraal ? JavaDownloader.findJavaBinary(graDir) : JavaDownloader.findJavaBinary(temDir);
        if (javaBin != null && Files.isRegularFile(javaBin, new LinkOption[0])) {
            return javaBin.toAbsolutePath().toString();
        }
        DownloadInfo downloadInfo = JavaDownloader.resolveDownloadUrl(majorVersion, os, arch, vendor);
        String vendorSlug = downloadInfo.vendorUsed;
        Path targetDir = baseDir.resolve(String.format("%s-%d-%s-%s", vendorSlug, majorVersion, os, arch));
        Files.createDirectories(targetDir, new FileAttribute[0]);
        Path archiveFile = baseDir.resolve(String.format("%s-%d-%s-%s%s", vendorSlug, majorVersion, os, arch, archiveExt));
        JavaDownloader.cleanupStalePartialFiles(baseDir, archiveFile.getFileName().toString());
        JavaDownloader.downloadWithVerification(downloadInfo.downloadUrl, archiveFile, progressListener, 3);
        if (archiveExt.equals(".zip")) {
            JavaDownloader.extractZip(archiveFile, targetDir);
        } else {
            JavaDownloader.extractTarGz(archiveFile, targetDir);
        }
        JavaDownloader.normalizeExtractedRoot(targetDir, majorVersion, downloadInfo.imageTypeUsed);
        try {
            Files.deleteIfExists(archiveFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        javaBin = JavaDownloader.findJavaBinary(targetDir);
        if (javaBin == null || !Files.isRegularFile(javaBin, new LinkOption[0])) {
            String binaryName = os.equals("windows") ? "java.exe" : "java";
            throw new IOException("Downloaded Java " + majorVersion + " archive did not contain a valid " + binaryName);
        }
        return javaBin.toAbsolutePath().toString();
    }

    private static DownloadInfo resolveDownloadUrl(int majorVersion, String os, String arch, String vendor) throws IOException {
        String downloadUrl = null;
        String imageTypeUsed = "jre";
        String vendorUsed = null;
        if (vendor != null && vendor.equalsIgnoreCase("graalvm")) {
            try {
                downloadUrl = JavaDownloader.fetchGraalVMDownloadLink(majorVersion, os, arch);
                if (downloadUrl != null) {
                    imageTypeUsed = "jdk";
                    vendorUsed = "graalvm";
                }
            }
            catch (IOException e) {
                CleanroomRelauncher.LOGGER.warn("Failed to resolve GraalVM JDK {} ({}, {}): {}", (Object)majorVersion, (Object)os, (Object)arch, (Object)e.toString());
            }
        }
        if (downloadUrl == null) {
            try {
                downloadUrl = JavaDownloader.fetchAdoptiumDownloadLink(majorVersion, os, arch, "jre");
                if (downloadUrl != null) {
                    imageTypeUsed = "jre";
                    vendorUsed = "temurin";
                }
            }
            catch (IOException e) {
                CleanroomRelauncher.LOGGER.warn("Failed to resolve Temurin {} JRE via assets API ({}): {}", (Object)majorVersion, (Object)os, (Object)e.toString());
            }
            if (downloadUrl == null) {
                try {
                    downloadUrl = JavaDownloader.fetchAdoptiumDownloadLink(majorVersion, os, arch, "jdk");
                    if (downloadUrl != null) {
                        imageTypeUsed = "jdk";
                        vendorUsed = "temurin";
                    }
                }
                catch (IOException e) {
                    CleanroomRelauncher.LOGGER.warn("Failed to resolve Temurin {} JDK via assets API ({}): {}", (Object)majorVersion, (Object)os, (Object)e.toString());
                }
            }
        }
        if (downloadUrl == null || vendorUsed == null) {
            throw new IOException("Unable to resolve Java " + majorVersion + " download URL for " + os + " " + arch + " from vendor(s)");
        }
        return new DownloadInfo(downloadUrl, imageTypeUsed, vendorUsed);
    }

    private static Path findJavaBinary(Path root) throws IOException {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return null;
        }
        try (Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);){
            Path path = stream.filter(p -> {
                String name = p.getFileName().toString();
                return name.equals("java") || name.equalsIgnoreCase("java.exe");
            }).filter(p -> p.getParent() != null && p.getParent().getFileName().toString().equalsIgnoreCase("bin")).findFirst().orElse(null);
            return path;
        }
    }

    private static void normalizeExtractedRoot(Path targetDir, int majorVersion, String imageType) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(targetDir);){
            String desired;
            Path desiredPath;
            Path root = null;
            int count = 0;
            for (Path p : stream) {
                if (!Files.isDirectory(p, new LinkOption[0])) continue;
                root = p;
                ++count;
            }
            if (count == 1 && root != null && !Files.exists(desiredPath = targetDir.resolve(desired = imageType != null && imageType.equalsIgnoreCase("jre") ? String.format("jdk-%d-jre", majorVersion) : String.format("jdk-%d", majorVersion)), new LinkOption[0])) {
                try {
                    Files.move(root, desiredPath, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (AtomicMoveNotSupportedException e) {
                    Files.move(root, desiredPath, new CopyOption[0]);
                }
            }
        }
    }

    private static void extractZip(Path zipFile, Path targetDir) throws IOException {
        try (InputStream fis = Files.newInputStream(zipFile, new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                Path outPath = targetDir.resolve(entry.getName()).normalize();
                if (!outPath.startsWith(targetDir)) {
                    throw new IOException("Zip entry outside target dir: " + entry.getName());
                }
                if (entry.isDirectory()) {
                    Files.createDirectories(outPath, new FileAttribute[0]);
                } else {
                    Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                    try (OutputStream os = Files.newOutputStream(outPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = zis.read(buffer)) > 0) {
                            os.write(buffer, 0, len);
                        }
                    }
                }
                zis.closeEntry();
            }
        }
    }

    private static void extractTarGz(Path tarGzFile, Path targetDir) throws IOException {
        block68: {
            try (InputStream fis = Files.newInputStream(tarGzFile, new OpenOption[0]);
                 BufferedInputStream bis = new BufferedInputStream(fis);
                 GzipCompressorInputStream gis = new GzipCompressorInputStream((InputStream)bis);){
                TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)gis);
                Throwable throwable = null;
                block47: while (true) {
                    try {
                        TarArchiveEntry entry;
                        while ((entry = tis.getNextTarEntry()) != null) {
                            Path outPath = targetDir.resolve(entry.getName()).normalize();
                            if (!outPath.startsWith(targetDir)) {
                                throw new IOException("Tar entry outside target dir: " + entry.getName());
                            }
                            if (entry.isDirectory()) {
                                Files.createDirectories(outPath, new FileAttribute[0]);
                                continue;
                            }
                            Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                            try (OutputStream os = Files.newOutputStream(outPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                                int len;
                                byte[] buffer = new byte[8192];
                                while ((len = tis.read(buffer)) > 0) {
                                    os.write(buffer, 0, len);
                                }
                            }
                            try {
                                Set<PosixFilePermission> perms = PosixFilePermissions.fromString("rwxr-xr-x");
                                if (!Files.getFileStore(outPath).supportsFileAttributeView("posix")) continue block47;
                                Files.setPosixFilePermissions(outPath, perms);
                                continue block47;
                            }
                            catch (Throwable throwable2) {
                            }
                        }
                        break block68;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                finally {
                    if (tis != null) {
                        if (throwable != null) {
                            try {
                                tis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            tis.close();
                        }
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String fetchAdoptiumDownloadLink(int majorVersion, String os, String arch, String imageType) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 61[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String fetchGraalVMDownloadLink(int majorVersion, String os, String arch) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 32[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void downloadWithVerification(String urlStr, Path dest, ProgressListener listener, int maxRetries) throws IOException {
        IOException last = null;
        for (int attempt = 0; attempt <= maxRetries; ++attempt) {
            try {
                boolean canMulti;
                String finalUrl = JavaDownloader.resolveFinalURL(urlStr);
                ProbeInfo info = JavaDownloader.probeServer(finalUrl);
                boolean bl = canMulti = info.totalBytes > 0L && info.acceptRanges && JavaDownloader.testRangeSupport(finalUrl);
                if (canMulti) {
                    if (listener != null) {
                        listener.onStart(info.totalBytes);
                    }
                    JavaDownloader.downloadMultiChunk(finalUrl, dest, info.totalBytes, listener);
                } else {
                    JavaDownloader.downloadFollowingRedirectsWithUA(finalUrl, dest, listener);
                }
                if (!CacheVerification.verifyJavaArchive(dest)) {
                    CleanroomRelauncher.LOGGER.warn("Archive verification failed for {}. Retrying download...", (Object)dest.getFileName().toString());
                    try {
                        Files.deleteIfExists(dest);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                } else {
                    return;
                }
                last = new IOException("Archive verification failed");
                continue;
            }
            catch (IOException e) {
                last = e;
                if (attempt == maxRetries) break;
                long backoff = (long)(2000.0 * Math.pow(2.0, attempt));
                long jitter = (long)((double)backoff * 0.2 * Math.random());
                long sleep = backoff + jitter;
                if (listener != null) {
                    long tick;
                    for (long remaining = sleep; remaining > 0L; remaining -= tick) {
                        try {
                            listener.onRetryScheduled(attempt + 1, maxRetries + 1, remaining);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        tick = Math.min(1000L, remaining);
                        try {
                            Thread.sleep(tick);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    continue;
                }
                try {
                    Thread.sleep(sleep);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        throw last != null ? last : new IOException("Download failed after verification retries: " + urlStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String resolveFinalURL(String urlStr) throws IOException {
        String current = urlStr;
        for (int i = 0; i < 7; ++i) {
            HttpURLConnection conn = null;
            try {
                String location;
                URL url = new URL(current);
                conn = (HttpURLConnection)url.openConnection();
                conn.setInstanceFollowRedirects(false);
                conn.setRequestMethod("HEAD");
                conn.setConnectTimeout(30000);
                conn.setReadTimeout(30000);
                conn.setRequestProperty("User-Agent", USER_AGENT);
                int code = conn.getResponseCode();
                if (code >= 300 && code < 400) {
                    location = conn.getHeaderField("Location");
                    if (location == null) {
                        throw new IOException("Redirect without Location header from " + current);
                    }
                } else {
                    String string = current;
                    return string;
                }
                current = location;
                continue;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        throw new IOException("Too many redirects while resolving: " + urlStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProbeInfo probeServer(String urlStr) throws IOException {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestProperty("User-Agent", USER_AGENT);
            int code = conn.getResponseCode();
            if (code >= 300 && code < 400) {
                String fin = JavaDownloader.resolveFinalURL(urlStr);
                ProbeInfo probeInfo = JavaDownloader.probeServer(fin);
                return probeInfo;
            }
            long total = -1L;
            try {
                total = Long.parseLong(conn.getHeaderField("Content-Length"));
            }
            catch (Exception ignore) {
                total = -1L;
            }
            boolean ranges = false;
            String ar = conn.getHeaderField("Accept-Ranges");
            if (ar != null && ar.toLowerCase(Locale.ROOT).contains("bytes")) {
                ranges = true;
            }
            ProbeInfo probeInfo = new ProbeInfo(total, ranges, urlStr);
            return probeInfo;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean testRangeSupport(String urlStr) {
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            conn.setRequestProperty("User-Agent", USER_AGENT);
            conn.setRequestProperty("Accept", "application/octet-stream");
            conn.setRequestProperty("Range", "bytes=0-0");
            int code = conn.getResponseCode();
            boolean bl = code == 206;
            return bl;
        }
        catch (IOException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static void downloadFollowingRedirectsWithUA(String urlStr, Path dest, ProgressListener listener) throws IOException {
        String current = urlStr;
        Path temp = dest.resolveSibling(dest.getFileName().toString() + ".part");
        if (!Files.exists(temp, new LinkOption[0])) {
            Files.createDirectories(temp.getParent(), new FileAttribute[0]);
            Files.createFile(temp, new FileAttribute[0]);
        }
        for (int i = 0; i < 7; ++i) {
            long existing = 0L;
            try {
                existing = Files.size(temp);
            }
            catch (IOException ignore) {
                existing = 0L;
            }
            HttpURLConnection conn = null;
            try {
                String location;
                int code;
                URL url = new URL(current);
                conn = (HttpURLConnection)url.openConnection();
                conn.setInstanceFollowRedirects(false);
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(30000);
                conn.setReadTimeout(120000);
                conn.setRequestProperty("User-Agent", USER_AGENT);
                conn.setRequestProperty("Accept", "application/octet-stream");
                if (existing > 0L) {
                    conn.setRequestProperty("Range", "bytes=" + existing + "-");
                }
                if ((code = conn.getResponseCode()) >= 300 && code < 400) {
                    location = conn.getHeaderField("Location");
                    if (location == null) {
                        throw new IOException("Redirect without Location header from " + current);
                    }
                } else {
                    if (code == 206 || code == 200) {
                        long total = -1L;
                        if (code == 206) {
                            int slash;
                            String cr = conn.getHeaderField("Content-Range");
                            if (cr != null && cr.startsWith("bytes ") && (slash = cr.indexOf(47)) > 0 && slash + 1 < cr.length()) {
                                try {
                                    total = Long.parseLong(cr.substring(slash + 1).trim());
                                }
                                catch (Exception ignore) {
                                    total = -1L;
                                }
                            }
                            if (total <= 0L) {
                                long remaining = -1L;
                                try {
                                    remaining = Long.parseLong(conn.getHeaderField("Content-Length"));
                                }
                                catch (Exception ignore) {
                                    remaining = -1L;
                                }
                                total = remaining > 0L ? remaining + existing : -1L;
                            }
                        } else {
                            try {
                                total = Long.parseLong(conn.getHeaderField("Content-Length"));
                            }
                            catch (Exception ignore) {
                                total = -1L;
                            }
                            existing = 0L;
                        }
                        if (listener != null) {
                            listener.onStart(total);
                        }
                        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                             OutputStream out = Files.newOutputStream(temp, StandardOpenOption.CREATE, existing > 0L ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
                            int n;
                            byte[] buf = new byte[8192];
                            long downloaded = existing;
                            while ((n = ((InputStream)in).read(buf)) >= 0) {
                                out.write(buf, 0, n);
                                downloaded += (long)n;
                                if (listener == null) continue;
                                listener.onProgress(downloaded, total);
                            }
                        }
                        try {
                            Files.move(temp, dest, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (AtomicMoveNotSupportedException e) {
                            Files.move(temp, dest, StandardCopyOption.REPLACE_EXISTING);
                        }
                        CleanroomRelauncher.LOGGER.info("Downloaded Java from {}", (Object)current);
                        return;
                    }
                    throw new IOException("Unexpected HTTP status " + code + " from " + current);
                }
                current = location;
                continue;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        throw new IOException("Too many redirects while downloading: " + urlStr);
    }

    private static void downloadMultiChunk(String urlStr, Path dest, long totalBytes, ProgressListener listener) throws IOException {
        int cores = Math.max(1, Runtime.getRuntime().availableProcessors());
        int threads = Math.min(8, cores * 2);
        int totalChunks = (int)((totalBytes + 0x400000L - 1L) / 0x400000L);
        Path temp = dest.resolveSibling(dest.getFileName().toString() + ".part");
        Path metaFile = dest.resolveSibling(dest.getFileName().toString() + ".part.meta");
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        BitSet completedChunks = new BitSet(totalChunks);
        long alreadyDownloaded = 0L;
        if (Files.exists(temp, new LinkOption[0]) && Files.exists(metaFile, new LinkOption[0])) {
            try {
                Properties meta = new Properties();
                try (InputStream mis = Files.newInputStream(metaFile, new OpenOption[0]);){
                    meta.load(mis);
                }
                long savedTotal = Long.parseLong(meta.getProperty("totalBytes", "0"));
                int savedChunks = Integer.parseInt(meta.getProperty("totalChunks", "0"));
                if (savedTotal == totalBytes && savedChunks == totalChunks) {
                    String chunksHex = meta.getProperty("completedChunks", "");
                    if (!chunksHex.isEmpty()) {
                        byte[] chunkBytes = JavaDownloader.hexToBytes(chunksHex);
                        completedChunks = BitSet.valueOf(chunkBytes);
                        for (int i = 0; i < totalChunks; ++i) {
                            if (!completedChunks.get(i)) continue;
                            long start = (long)i * 0x400000L;
                            long end = Math.min(totalBytes - 1L, (long)(i + 1) * 0x400000L - 1L);
                            alreadyDownloaded += end - start + 1L;
                        }
                        CleanroomRelauncher.LOGGER.info("Resuming multi-chunk download: {} of {} chunks completed, {} bytes already downloaded", (Object)completedChunks.cardinality(), (Object)totalChunks, (Object)alreadyDownloaded);
                    }
                } else {
                    CleanroomRelauncher.LOGGER.warn("Metadata mismatch for {}. Starting fresh download.", (Object)dest.getFileName().toString());
                    completedChunks.clear();
                    alreadyDownloaded = 0L;
                }
            }
            catch (Exception e) {
                CleanroomRelauncher.LOGGER.warn("Failed to read download metadata: {}. Starting fresh.", (Object)e.toString());
                completedChunks.clear();
                alreadyDownloaded = 0L;
            }
        }
        if (!Files.exists(temp, new LinkOption[0])) {
            try (RandomAccessFile raf = new RandomAccessFile(temp.toFile(), "rw");){
                raf.setLength(totalBytes);
            }
        }
        BitSet[] completedChunksRef = new BitSet[]{completedChunks};
        long finalTotalBytes = totalBytes;
        int finalTotalChunks = totalChunks;
        Path finalMetaFile = metaFile;
        AtomicLong downloaded = new AtomicLong(alreadyDownloaded);
        AtomicBoolean failed = new AtomicBoolean(false);
        ExecutorService pool = Executors.newFixedThreadPool(threads);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (int i = 0; i < totalChunks; ++i) {
            if (completedChunks.get(i)) continue;
            int n = i;
            long start = (long)i * 0x400000L;
            long end = Math.min(totalBytes - 1L, (long)(i + 1) * 0x400000L - 1L);
            futures.add(pool.submit(() -> {
                int attempt = 0;
                IOException last = null;
                while (attempt < 3 && !failed.get()) {
                    HttpURLConnection conn = null;
                    try {
                        URL url = new URL(urlStr);
                        conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("GET");
                        conn.setConnectTimeout(30000);
                        conn.setReadTimeout(600000);
                        conn.setRequestProperty("User-Agent", USER_AGENT);
                        conn.setRequestProperty("Accept", "application/octet-stream");
                        conn.setRequestProperty("Range", "bytes=" + start + "-" + end);
                        int code = conn.getResponseCode();
                        if (code != 206 && code != 200) {
                            throw new IOException("Unexpected HTTP " + code + " for range " + start + "-" + end);
                        }
                        try (BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                             RandomAccessFile raf = new RandomAccessFile(temp.toFile(), "rw");){
                            int n;
                            raf.seek(start);
                            byte[] buf = new byte[8192];
                            long toRead = end - start + 1L;
                            while (toRead > 0L && (n = ((InputStream)in).read(buf, 0, (int)Math.min((long)buf.length, toRead))) >= 0) {
                                raf.write(buf, 0, n);
                                toRead -= (long)n;
                                long cur = downloaded.addAndGet(n);
                                if (listener != null) {
                                    try {
                                        listener.onProgress(cur, finalTotalBytes);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                if (!failed.get()) continue;
                                break;
                            }
                            if (toRead > 0L && !failed.get()) {
                                throw new IOException("Early EOF for chunk " + start + "-" + end);
                            }
                        }
                        BitSet[] bitSetArray = completedChunksRef;
                        synchronized (completedChunksRef) {
                            completedChunksRef[0].set(chunkIndex);
                            JavaDownloader.saveMetadata(finalMetaFile, finalTotalBytes, finalTotalChunks, completedChunksRef[0]);
                            // ** MonitorExit[var20_19] (shouldn't be in output)
                            bitSetArray = null;
                            return bitSetArray;
                        }
                    }
                    catch (IOException e) {
                        last = e;
                        ++attempt;
                        try {
                            Thread.sleep(500L * (long)attempt);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    finally {
                        if (conn == null) continue;
                        conn.disconnect();
                    }
                }
                failed.set(true);
                throw last != null ? last : new IOException("Failed to download chunk " + start + "-" + end);
            }));
        }
        pool.shutdown();
        for (Future future : futures) {
            try {
                future.get(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                failed.set(true);
                pool.shutdownNow();
                throw new IOException("Interrupted while downloading", e);
            }
            catch (ExecutionException e) {
                failed.set(true);
                pool.shutdownNow();
                throw new IOException("Chunk task failed", e.getCause());
            }
            catch (TimeoutException e) {
                failed.set(true);
                pool.shutdownNow();
                throw new IOException("Timed out waiting for chunk", e);
            }
        }
        if (failed.get()) {
            throw new IOException("Multi-chunk download failed");
        }
        try {
            Files.move(temp, dest, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            Files.move(temp, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            Files.deleteIfExists(metaFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CleanroomRelauncher.LOGGER.info("Downloaded (multi-chunk) Java from {}", (Object)urlStr);
    }

    private static void saveMetadata(Path metaFile, long totalBytes, int totalChunks, BitSet completedChunks) {
        try {
            Properties meta = new Properties();
            meta.setProperty("totalBytes", String.valueOf(totalBytes));
            meta.setProperty("totalChunks", String.valueOf(totalChunks));
            byte[] chunkBytes = completedChunks.toByteArray();
            meta.setProperty("completedChunks", JavaDownloader.bytesToHex(chunkBytes));
            try (OutputStream out = Files.newOutputStream(metaFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                meta.store(out, "Multi-chunk download metadata");
            }
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.warn("Failed to save download metadata: {}", (Object)e.toString());
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    private static void cleanupStalePartialFiles(Path baseDir, String expectedFileName) {
        if (!Files.exists(baseDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(baseDir);){
            files.filter(path -> {
                String name = path.getFileName().toString();
                return (name.endsWith(".part") || name.endsWith(".part.meta")) && !name.startsWith(expectedFileName);
            }).forEach(staleFile -> {
                try {
                    Files.deleteIfExists(staleFile);
                    CleanroomRelauncher.LOGGER.info("Cleaned up stale partial file: {}", (Object)staleFile.getFileName());
                }
                catch (IOException e) {
                    CleanroomRelauncher.LOGGER.warn("Failed to delete stale partial file {}: {}", (Object)staleFile.getFileName(), (Object)e.toString());
                }
            });
        }
        catch (IOException e) {
            CleanroomRelauncher.LOGGER.warn("Failed to cleanup stale partial files: {}", (Object)e.toString());
        }
    }

    private static byte[] hexToBytes(String hex) {
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }

    private static class ProbeInfo {
        final long totalBytes;
        final boolean acceptRanges;
        final String finalUrl;

        ProbeInfo(long t, boolean a, String u) {
            this.totalBytes = t;
            this.acceptRanges = a;
            this.finalUrl = u;
        }
    }

    private static class DownloadInfo {
        final String downloadUrl;
        final String imageTypeUsed;
        final String vendorUsed;

        DownloadInfo(String downloadUrl, String imageTypeUsed, String vendorUsed) {
            this.downloadUrl = downloadUrl;
            this.imageTypeUsed = imageTypeUsed;
            this.vendorUsed = vendorUsed;
        }
    }

    public static interface ProgressListener {
        public void onStart(long var1);

        public void onProgress(long var1, long var3);

        default public void onRetryScheduled(int attempt, int maxAttempts, long delayMs) {
        }
    }
}

