/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.relauncher.shade.javautils.locators;

import com.cleanroommc.relauncher.shade.javautils.JavaUtils;
import com.cleanroommc.relauncher.shade.javautils.api.JavaInstall;
import com.cleanroommc.relauncher.shade.javautils.locators.AbstractJavaLocator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GradleProvisionedJavaLocator
extends AbstractJavaLocator {
    @Override
    protected List<JavaInstall> initialize() {
        File jdksDir;
        String gradleUserHome = GradleProvisionedJavaLocator.env("GRADLE_USER_HOME");
        if (gradleUserHome == null) {
            File gradleUserHomeCandidate = new File(GradleProvisionedJavaLocator.userHome(".gradle"));
            if (!gradleUserHomeCandidate.exists() || gradleUserHomeCandidate.isFile()) {
                return Collections.emptyList();
            }
            gradleUserHome = gradleUserHomeCandidate.getAbsolutePath();
        }
        if (!(jdksDir = new File(gradleUserHome + "/jdks")).exists() || jdksDir.isFile()) {
            return Collections.emptyList();
        }
        ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
        for (File jdkDir : jdksDir.listFiles(File::isDirectory)) {
            try {
                installs.add(JavaUtils.parseInstall(jdkDir));
            }
            catch (IOException e1) {
                LOGGER.warn("Could not parse {} as a JavaInstall, checking nested directory to see if it is an older gradle provisioned install...", (Object)jdkDir.getAbsolutePath());
                File[] nestedJdkDirs = jdkDir.listFiles();
                if (nestedJdkDirs == null) continue;
                for (File nestedJdkDir : nestedJdkDirs) {
                    GradleProvisionedJavaLocator.parseOrLog(installs, nestedJdkDir);
                }
            }
        }
        return installs;
    }
}

